/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.ArrayBindable;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.CyclicDefinitionException;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.tools.RelRunner;
import org.apache.calcite.util.ImmutableIntList;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface CalcitePrepare {
    public static final Function0<CalcitePrepare> DEFAULT_FACTORY = CalcitePrepareImpl::new;
    public static final ThreadLocal<@Nullable Deque<Context>> THREAD_CONTEXT_STACK = ThreadLocal.withInitial(ArrayDeque::new);

    public ParseResult parse(Context var1, String var2);

    public ConvertResult convert(Context var1, String var2);

    public void executeDdl(Context var1, SqlNode var2);

    public AnalyzeViewResult analyzeView(Context var1, String var2, boolean var3);

    public <T> CalciteSignature<T> prepareSql(Context var1, Query<T> var2, Type var3, long var4);

    public <T> CalciteSignature<T> prepareQueryable(Context var1, Queryable<T> var2);

    public static class Query<T> {
        public final @Nullable String sql;
        public final @Nullable Queryable<T> queryable;
        public final @Nullable RelNode rel;

        private Query(@Nullable String sql, @Nullable Queryable<T> queryable, @Nullable RelNode rel) {
            this.sql = sql;
            this.queryable = queryable;
            this.rel = rel;
            assert ((sql == null ? 0 : 1) + (queryable == null ? 0 : 1) + (rel == null ? 0 : 1) == 1);
        }

        public static <T> Query<T> of(String sql) {
            return new Query<T>(sql, null, null);
        }

        public static <T> Query<T> of(Queryable<T> queryable) {
            return new Query<T>(null, queryable, null);
        }

        public static <T> Query<T> of(RelNode rel) {
            return new Query<T>(null, null, rel);
        }
    }

    public static class CalciteSignature<T>
    extends Meta.Signature {
        @JsonIgnore
        public final @Nullable RelDataType rowType;
        @JsonIgnore
        public final @Nullable CalciteSchema rootSchema;
        @JsonIgnore
        private final List<RelCollation> collationList;
        private final long maxRowCount;
        private final @Nullable Bindable<T> bindable;

        @Deprecated
        public CalciteSignature(String sql, List<AvaticaParameter> parameterList, Map<String, Object> internalParameters, RelDataType rowType, List<ColumnMetaData> columns, Meta.CursorFactory cursorFactory, CalciteSchema rootSchema, List<RelCollation> collationList, long maxRowCount, Bindable<T> bindable) {
            this(sql, parameterList, internalParameters, rowType, columns, cursorFactory, rootSchema, collationList, maxRowCount, bindable, Nullness.castNonNull(null));
        }

        public CalciteSignature(@Nullable String sql, List<AvaticaParameter> parameterList, Map<String, Object> internalParameters, @Nullable RelDataType rowType, List<ColumnMetaData> columns, Meta.CursorFactory cursorFactory, @Nullable CalciteSchema rootSchema, List<RelCollation> collationList, long maxRowCount, @Nullable Bindable<T> bindable, Meta.StatementType statementType) {
            super(columns, sql, parameterList, internalParameters, cursorFactory, statementType);
            this.rowType = rowType;
            this.rootSchema = rootSchema;
            this.collationList = collationList;
            this.maxRowCount = maxRowCount;
            this.bindable = bindable;
        }

        public Enumerable<T> enumerable(DataContext dataContext) {
            Enumerable<T> enumerable = Nullness.castNonNull(this.bindable).bind(dataContext);
            if (this.maxRowCount >= 0L) {
                enumerable = EnumerableDefaults.take(enumerable, this.maxRowCount);
            }
            return enumerable;
        }

        public List<RelCollation> getCollationList() {
            return this.collationList;
        }
    }

    public static class AnalyzeViewResult
    extends ConvertResult {
        public final @Nullable Table table;
        public final @Nullable ImmutableList<String> tablePath;
        public final @Nullable RexNode constraint;
        public final @Nullable ImmutableIntList columnMapping;
        public final boolean modifiable;

        public AnalyzeViewResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType, RelRoot root, @Nullable Table table, @Nullable ImmutableList<String> tablePath, @Nullable RexNode constraint, @Nullable ImmutableIntList columnMapping, boolean modifiable) {
            super(prepare, validator, sql, sqlNode, rowType, root);
            this.table = table;
            this.tablePath = tablePath;
            this.constraint = constraint;
            this.columnMapping = columnMapping;
            this.modifiable = modifiable;
            Preconditions.checkArgument(modifiable == (table != null));
        }
    }

    public static class ConvertResult
    extends ParseResult {
        public final RelRoot root;

        public ConvertResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType, RelRoot root) {
            super(prepare, validator, sql, sqlNode, rowType);
            this.root = root;
        }
    }

    public static class ParseResult {
        public final CalcitePrepareImpl prepare;
        public final String sql;
        public final SqlNode sqlNode;
        public final RelDataType rowType;
        public final RelDataTypeFactory typeFactory;

        public ParseResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType) {
            this.prepare = prepare;
            this.sql = sql;
            this.sqlNode = sqlNode;
            this.rowType = rowType;
            this.typeFactory = validator.getTypeFactory();
        }

        public SqlKind kind() {
            return this.sqlNode.getKind();
        }
    }

    public static class Dummy {
        private static @Nullable SparkHandler sparkHandler;

        private Dummy() {
        }

        public static synchronized SparkHandler getSparkHandler(boolean enable) {
            if (sparkHandler == null) {
                sparkHandler = enable ? Dummy.createHandler() : new TrivialSparkHandler();
            }
            return sparkHandler;
        }

        private static SparkHandler createHandler() {
            try {
                Class<?> clazz = Class.forName("org.apache.calcite.adapter.spark.SparkHandlerImpl");
                Method method = clazz.getMethod("instance", new Class[0]);
                return (SparkHandler)Objects.requireNonNull(method.invoke(null, new Object[0]), () -> "non-null SparkHandler expected from " + method);
            }
            catch (ClassNotFoundException e) {
                return new TrivialSparkHandler();
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public static void push(Context context) {
            Deque<Context> stack = Nullness.castNonNull(THREAD_CONTEXT_STACK.get());
            List<String> path = context.getObjectPath();
            if (path != null) {
                for (Context context1 : stack) {
                    List<String> path1 = context1.getObjectPath();
                    if (!path.equals(path1)) continue;
                    throw new CyclicDefinitionException(stack.size(), path);
                }
            }
            stack.push(context);
        }

        public static Context peek() {
            return Nullness.castNonNull(Nullness.castNonNull(THREAD_CONTEXT_STACK.get()).peek());
        }

        public static void pop(Context context) {
            Context x = Nullness.castNonNull(THREAD_CONTEXT_STACK.get()).pop();
            assert (x == context);
        }

        private static class TrivialSparkHandler
        implements SparkHandler {
            private TrivialSparkHandler() {
            }

            @Override
            public RelNode flattenTypes(RelOptPlanner planner, RelNode rootRel, boolean restructure) {
                return rootRel;
            }

            @Override
            public void registerRules(SparkHandler.RuleSetBuilder builder) {
            }

            @Override
            public boolean enabled() {
                return false;
            }

            @Override
            public ArrayBindable compile(ClassDeclaration expr, String s2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object sparkContext() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface SparkHandler {
        public RelNode flattenTypes(RelOptPlanner var1, RelNode var2, boolean var3);

        public void registerRules(RuleSetBuilder var1);

        public boolean enabled();

        public ArrayBindable compile(ClassDeclaration var1, String var2);

        public Object sparkContext();

        public static interface RuleSetBuilder {
            public void addRule(RelOptRule var1);

            public void removeRule(RelOptRule var1);
        }
    }

    public static interface Context {
        public JavaTypeFactory getTypeFactory();

        public CalciteSchema getRootSchema();

        public CalciteSchema getMutableRootSchema();

        public List<String> getDefaultSchemaPath();

        public CalciteConnectionConfig config();

        public SparkHandler spark();

        public DataContext getDataContext();

        public @Nullable List<String> getObjectPath();

        public RelRunner getRelRunner();
    }
}

