/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.Iterator;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.linq4j.tree.AbstractNode;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Types;
import org.checkerframework.checker.nullness.qual.Nullable;

class ExpressionWriter {
    private static final int INDENT = 2;
    private final Spacer spacer = new Spacer(0);
    private final StringBuilder buf = new StringBuilder();
    private boolean indentPending;
    private final boolean generics;

    ExpressionWriter() {
        this(true);
    }

    ExpressionWriter(boolean generics) {
        this.generics = generics;
    }

    public void write(Node expression) {
        if (expression instanceof Expression) {
            Expression expression1 = (Expression)expression;
            expression1.accept(this, 0, 0);
        } else {
            expression.accept(this);
        }
    }

    public String toString() {
        return this.buf.toString();
    }

    public boolean requireParentheses(Expression expression, int lprec, int rprec) {
        if (lprec < expression.nodeType.lprec && expression.nodeType.rprec >= rprec) {
            return false;
        }
        this.buf.append("(");
        expression.accept(this, 0, 0);
        this.buf.append(")");
        return true;
    }

    public void begin() {
        this.spacer.add(2);
    }

    public void end() {
        this.spacer.subtract(2);
    }

    public ExpressionWriter newlineAndIndent() {
        this.buf.append("\n");
        this.indentPending = true;
        return this;
    }

    public ExpressionWriter indent() {
        this.spacer.spaces(this.buf);
        return this;
    }

    public ExpressionWriter begin(String s2) {
        this.append(s2);
        this.begin();
        this.indentPending = s2.endsWith("\n");
        return this;
    }

    public ExpressionWriter end(String s2) {
        this.end();
        this.append(s2);
        this.indentPending = s2.endsWith("\n");
        return this;
    }

    public ExpressionWriter append(char c) {
        this.checkIndent();
        this.buf.append(c);
        return this;
    }

    public ExpressionWriter append(Type type2) {
        this.checkIndent();
        if (!this.generics) {
            type2 = Types.stripGenerics(type2);
        }
        this.buf.append(Types.className(type2));
        return this;
    }

    public ExpressionWriter append(AbstractNode o) {
        o.accept0(this);
        return this;
    }

    public ExpressionWriter append(@Nullable Object o) {
        this.checkIndent();
        this.buf.append(o);
        return this;
    }

    public ExpressionWriter append(@Nullable String s2) {
        this.checkIndent();
        this.buf.append(s2);
        return this;
    }

    private void checkIndent() {
        if (this.indentPending) {
            this.spacer.spaces(this.buf);
            this.indentPending = false;
        }
    }

    public StringBuilder getBuf() {
        this.checkIndent();
        return this.buf;
    }

    public ExpressionWriter list(String begin, String sep, String end, Iterable<?> list) {
        Iterator<?> iterator = list.iterator();
        if (iterator.hasNext()) {
            this.begin(begin);
            while (true) {
                Object o;
                if ((o = iterator.next()) instanceof Expression) {
                    ((Expression)o).accept(this, 0, 0);
                } else if (o instanceof MemberDeclaration) {
                    ((MemberDeclaration)o).accept(this);
                } else if (o instanceof Type) {
                    this.append((Type)o);
                } else {
                    this.append(o);
                }
                if (!iterator.hasNext()) break;
                this.buf.append(sep);
                if (!sep.endsWith("\n")) continue;
                this.indentPending = true;
            }
            this.end(end);
        } else {
            while (begin.endsWith("\n")) {
                begin = begin.substring(0, begin.length() - 1);
            }
            this.buf.append(begin).append(end);
        }
        return this;
    }

    public void backUp() {
        if (this.buf.lastIndexOf("\n") == this.buf.length() - 1) {
            this.buf.delete(this.buf.length() - 1, this.buf.length());
            this.indentPending = false;
        }
    }
}

