/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.hep;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepInstruction;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepProgram;

public class HepProgramBuilder {
    private final List<HepInstruction> instructions = new ArrayList<HepInstruction>();
    private int group = -1;

    private void clear() {
        this.instructions.clear();
        this.group = -1;
    }

    public <R extends RelOptRule> HepProgramBuilder addRuleClass(Class<R> ruleClass) {
        return this.addInstruction(new HepInstruction.RuleClass(ruleClass));
    }

    public HepProgramBuilder addRuleCollection(Collection<RelOptRule> rules) {
        return this.addInstruction(new HepInstruction.RuleCollection(rules));
    }

    public HepProgramBuilder addRuleInstance(RelOptRule rule) {
        return this.addInstruction(new HepInstruction.RuleInstance(rule));
    }

    public HepProgramBuilder addRuleByDescription(String ruleDescription) {
        return this.addInstruction(new HepInstruction.RuleLookup(ruleDescription));
    }

    public HepProgramBuilder addGroupBegin() {
        Preconditions.checkArgument(this.group < 0);
        this.group = this.instructions.size();
        return this.addInstruction(new HepInstruction.Placeholder());
    }

    public HepProgramBuilder addGroupEnd() {
        Preconditions.checkArgument(this.group >= 0);
        HepInstruction.EndGroup endGroup = new HepInstruction.EndGroup();
        this.instructions.set(this.group, new HepInstruction.BeginGroup(endGroup));
        this.group = -1;
        return this.addInstruction(endGroup);
    }

    public HepProgramBuilder addConverters(boolean guaranteed) {
        Preconditions.checkArgument(this.group < 0);
        return this.addInstruction(new HepInstruction.ConverterRules(guaranteed));
    }

    public HepProgramBuilder addCommonRelSubExprInstruction() {
        Preconditions.checkArgument(this.group < 0);
        return this.addInstruction(new HepInstruction.CommonRelSubExprRules());
    }

    public HepProgramBuilder addMatchOrder(HepMatchOrder order) {
        Preconditions.checkArgument(this.group < 0);
        return this.addInstruction(new HepInstruction.MatchOrder(order));
    }

    public HepProgramBuilder addMatchLimit(int limit) {
        Preconditions.checkArgument(this.group < 0);
        return this.addInstruction(new HepInstruction.MatchLimit(limit));
    }

    public HepProgramBuilder addSubprogram(HepProgram program) {
        Preconditions.checkArgument(this.group < 0);
        return this.addInstruction(new HepInstruction.SubProgram(program));
    }

    private HepProgramBuilder addInstruction(HepInstruction instruction) {
        this.instructions.add(instruction);
        return this;
    }

    public HepProgram build() {
        Preconditions.checkArgument(this.group < 0);
        HepProgram program = new HepProgram(this.instructions);
        this.clear();
        return program;
    }
}

