/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rel2sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlHint;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlTableRef;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelToSqlConverter
extends SqlImplementor
implements ReflectiveVisitor {
    private final ReflectUtil.MethodDispatcher<SqlImplementor.Result> dispatcher;
    private final Deque<Frame> stack = new ArrayDeque<Frame>();

    public RelToSqlConverter(SqlDialect dialect) {
        super(dialect);
        this.dispatcher = ReflectUtil.createMethodDispatcher(SqlImplementor.Result.class, this, "visit", RelNode.class, new Class[0]);
    }

    protected SqlImplementor.Result dispatch(RelNode e) {
        return this.dispatcher.invoke(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlImplementor.Result visitInput(RelNode parent, int i, boolean anon, boolean ignoreClauses, Set<SqlImplementor.Clause> expectedClauses) {
        try {
            RelNode e = parent.getInput(i);
            this.stack.push(new Frame(parent, i, e, anon, ignoreClauses, expectedClauses));
            SqlImplementor.Result result = this.dispatch(e);
            return result;
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    protected boolean isAnon() {
        Frame peek = this.stack.peek();
        return peek == null || peek.anon;
    }

    @Override
    protected SqlImplementor.Result result(SqlNode node, Collection<SqlImplementor.Clause> clauses, @Nullable String neededAlias, @Nullable RelDataType neededType, Map<String, RelDataType> aliases) {
        Frame frame = Objects.requireNonNull(this.stack.peek());
        return super.result(node, clauses, neededAlias, neededType, aliases).withAnon(this.isAnon()).withExpectedClauses(frame.ignoreClauses, frame.expectedClauses, frame.parent);
    }

    public SqlImplementor.Result visit(RelNode e) {
        throw new AssertionError((Object)("Need to implement " + e.getClass().getName()));
    }

    public SqlImplementor.Result visit(Join e) {
        JoinConditionType condType;
        SqlNode sqlCondition;
        switch (e.getJoinType()) {
            case ANTI: 
            case SEMI: {
                return this.visitAntiOrSemiJoin(e);
            }
        }
        SqlImplementor.Result leftResult = this.visitInput(e, 0).resetAlias();
        SqlImplementor.Result rightResult = this.visitInput(e, 1).resetAlias();
        SqlImplementor.Context leftContext = leftResult.qualifiedContext();
        SqlImplementor.Context rightContext = rightResult.qualifiedContext();
        JoinType joinType = RelToSqlConverter.joinType(e.getJoinType());
        if (joinType == JoinType.INNER && e.getCondition().isAlwaysTrue()) {
            joinType = this.isCommaJoin(e) ? JoinType.COMMA : JoinType.CROSS;
            sqlCondition = null;
            condType = JoinConditionType.NONE;
        } else {
            sqlCondition = RelToSqlConverter.convertConditionToSqlNode(e.getCondition(), leftContext, rightContext);
            condType = JoinConditionType.ON;
        }
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), joinType.symbol(POS), rightResult.asFrom(), condType.symbol(POS), sqlCondition);
        return this.result(join, leftResult, rightResult);
    }

    protected SqlImplementor.Result visitAntiOrSemiJoin(Join e) {
        SqlSelect existsSqlSelect;
        SqlNode fromPart;
        SqlImplementor.Result leftResult = this.visitInput(e, 0).resetAlias();
        SqlImplementor.Result rightResult = this.visitInput(e, 1).resetAlias();
        SqlImplementor.Context leftContext = leftResult.qualifiedContext();
        SqlImplementor.Context rightContext = rightResult.qualifiedContext();
        SqlSelect sqlSelect = leftResult.asSelect();
        SqlNode sqlCondition = RelToSqlConverter.convertConditionToSqlNode(e.getCondition(), leftContext, rightContext);
        if (leftResult.neededAlias != null) {
            AliasReplacementShuttle visitor = new AliasReplacementShuttle(leftResult.neededAlias, e.getLeft().getRowType(), sqlSelect.getSelectList());
            sqlCondition = sqlCondition.accept(visitor);
        }
        if ((fromPart = rightResult.asFrom()).getKind() == SqlKind.SELECT) {
            existsSqlSelect = (SqlSelect)fromPart;
            existsSqlSelect.setSelectList(new SqlNodeList(ImmutableList.of(ONE), POS));
            if (existsSqlSelect.getWhere() != null) {
                sqlCondition = SqlStdOperatorTable.AND.createCall(POS, existsSqlSelect.getWhere(), sqlCondition);
            }
            existsSqlSelect.setWhere(sqlCondition);
        } else {
            existsSqlSelect = new SqlSelect(POS, null, new SqlNodeList(ImmutableList.of(ONE), POS), fromPart, sqlCondition, null, null, null, null, null, null, null);
        }
        sqlCondition = SqlStdOperatorTable.EXISTS.createCall(POS, existsSqlSelect);
        if (e.getJoinType() == JoinRelType.ANTI) {
            sqlCondition = SqlStdOperatorTable.NOT.createCall(POS, sqlCondition);
        }
        if (sqlSelect.getWhere() != null) {
            sqlCondition = SqlStdOperatorTable.AND.createCall(POS, sqlSelect.getWhere(), sqlCondition);
        }
        sqlSelect.setWhere(sqlCondition);
        SqlSelect resultNode = leftResult.neededAlias == null ? sqlSelect : RelToSqlConverter.as(sqlSelect, leftResult.neededAlias);
        return this.result(resultNode, leftResult, rightResult);
    }

    private boolean isCommaJoin(Join join) {
        if (!join.getCondition().isAlwaysTrue()) {
            return false;
        }
        if (this.dialect.emulateJoinTypeForCrossJoin() != JoinType.COMMA) {
            return false;
        }
        assert (!this.stack.isEmpty());
        assert (this.stack.element().r == join);
        Join j = null;
        for (Frame frame : this.stack) {
            j = (Join)frame.r;
            if (frame.parent instanceof Join) continue;
            break;
        }
        Join topJoin = Objects.requireNonNull(j, "top join");
        ArrayList<Join> flatJoins = new ArrayList<Join>();
        flatJoins.add(topJoin);
        int i = 0;
        while (i < flatJoins.size()) {
            Join j2;
            if ((j2 = (Join)flatJoins.get(i++)).getLeft() instanceof Join) {
                flatJoins.add((Join)j2.getLeft());
            }
            if (!(j2.getRight() instanceof Join)) continue;
            flatJoins.add((Join)j2.getRight());
        }
        for (Join j2 : flatJoins) {
            if (j2.getJoinType() == JoinRelType.INNER && j2.getCondition().isAlwaysTrue()) continue;
            return false;
        }
        return true;
    }

    public SqlImplementor.Result visit(Correlate e) {
        SqlImplementor.Result leftResult = this.visitInput(e, 0).resetAlias(e.getCorrelVariable(), e.getRowType());
        this.parseCorrelTable(e, leftResult);
        SqlImplementor.Result rightResult = this.visitInput(e, 1);
        SqlCall rightLateral = SqlStdOperatorTable.LATERAL.createCall(POS, rightResult.node);
        SqlCall rightLateralAs = SqlStdOperatorTable.AS.createCall(POS, rightLateral, new SqlIdentifier(Objects.requireNonNull(rightResult.neededAlias, () -> "rightResult.neededAlias is null, node is " + rightResult.node), POS));
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), JoinType.COMMA.symbol(POS), rightLateralAs, JoinConditionType.NONE.symbol(POS), null);
        return this.result(join, leftResult, rightResult);
    }

    public SqlImplementor.Result visit(Filter e) {
        RelNode input = e.getInput();
        if (input instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)input;
            boolean ignoreClauses = aggregate.getInput() instanceof Project;
            SqlImplementor.Result x = this.visitInput((RelNode)e, 0, this.isAnon(), ignoreClauses, ImmutableSet.of(SqlImplementor.Clause.HAVING));
            this.parseCorrelTable(e, x);
            SqlImplementor.Builder builder = x.builder(e);
            x.asSelect().setHaving(SqlUtil.andExpressions(x.asSelect().getHaving(), builder.context.toSql(null, e.getCondition())));
            return builder.result();
        }
        SqlImplementor.Result x = this.visitInput((RelNode)e, 0, SqlImplementor.Clause.WHERE);
        this.parseCorrelTable(e, x);
        SqlImplementor.Builder builder = x.builder(e);
        builder.setWhere(builder.context.toSql(null, e.getCondition()));
        return builder.result();
    }

    public SqlImplementor.Result visit(Project e) {
        SqlImplementor.Result x = e.getInput() instanceof Sort ? this.visitInput(e, 0) : this.visitInput((RelNode)e, 0, SqlImplementor.Clause.SELECT);
        this.parseCorrelTable(e, x);
        SqlImplementor.Builder builder = x.builder(e);
        if (!RelToSqlConverter.isStar(e.getProjects(), e.getInput().getRowType(), e.getRowType())) {
            ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
            for (RexNode ref : e.getProjects()) {
                SqlNode sqlExpr = builder.context.toSql(null, ref);
                if (SqlUtil.isNullLiteral(sqlExpr, false)) {
                    RelDataTypeField field = e.getRowType().getFieldList().get(selectList.size());
                    sqlExpr = this.castNullType(sqlExpr, field.getType());
                }
                this.addSelect(selectList, sqlExpr, e.getRowType());
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
        }
        return builder.result();
    }

    private SqlNode castNullType(SqlNode nullLiteral, RelDataType type2) {
        SqlNode typeNode = this.dialect.getCastSpec(type2);
        if (typeNode == null) {
            return nullLiteral;
        }
        return SqlStdOperatorTable.CAST.createCall(POS, nullLiteral, typeNode);
    }

    public SqlImplementor.Result visit(Window e) {
        SqlImplementor.Result x = this.visitInput(e, 0);
        SqlImplementor.Builder builder = x.builder(e);
        RelNode input = e.getInput();
        int inputFieldCount = input.getRowType().getFieldCount();
        ArrayList<SqlNode> rexOvers = new ArrayList<SqlNode>();
        for (Window.Group group : e.groups) {
            rexOvers.addAll(builder.context.toSql(group, e.constants, inputFieldCount));
        }
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        for (RelDataTypeField field : input.getRowType().getFieldList()) {
            this.addSelect(selectList, builder.context.field(field.getIndex()), e.getRowType());
        }
        for (SqlNode rexOver : rexOvers) {
            this.addSelect(selectList, rexOver, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        return builder.result();
    }

    public SqlImplementor.Result visit(Aggregate e) {
        SqlImplementor.Builder builder = this.visitAggregate(e, e.getGroupSet().toList(), SqlImplementor.Clause.GROUP_BY);
        return builder.result();
    }

    private SqlImplementor.Builder visitAggregate(Aggregate e, List<Integer> groupKeyList, SqlImplementor.Clause ... clauses) {
        TreeSet<SqlImplementor.Clause> clauseSet = new TreeSet<SqlImplementor.Clause>(Arrays.asList(clauses));
        if (!e.getGroupSet().equals(ImmutableBitSet.union(e.getGroupSets()))) {
            clauseSet.add(SqlImplementor.Clause.HAVING);
        }
        boolean ignoreClauses = e.getInput() instanceof Project;
        SqlImplementor.Result x = this.visitInput((RelNode)e, 0, this.isAnon(), ignoreClauses, clauseSet);
        SqlImplementor.Builder builder = x.builder(e);
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        List<SqlNode> groupByList = this.generateGroupList(builder, selectList, e, groupKeyList);
        return this.buildAggregate(e, builder, selectList, groupByList);
    }

    protected void buildAggGroupList(Aggregate e, SqlImplementor.Builder builder, List<SqlNode> groupByList, List<SqlNode> selectList) {
        for (int group : e.getGroupSet()) {
            SqlNode field = builder.context.field(group);
            this.addSelect(selectList, field, e.getRowType());
            groupByList.add(field);
        }
    }

    protected SqlImplementor.Builder buildAggregate(Aggregate e, SqlImplementor.Builder builder, List<SqlNode> selectList, List<SqlNode> groupByList) {
        for (AggregateCall aggCall : e.getAggCallList()) {
            SqlNode aggCallSqlNode = builder.context.toSql(aggCall);
            if (aggCall.getAggregation() instanceof SqlSingleValueAggFunction) {
                aggCallSqlNode = this.dialect.rewriteSingleValueExpr(aggCallSqlNode);
            }
            this.addSelect(selectList, aggCallSqlNode, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        if (!groupByList.isEmpty() || e.getAggCallList().isEmpty()) {
            builder.setGroupBy(new SqlNodeList(groupByList, POS));
        }
        if (builder.clauses.contains((Object)SqlImplementor.Clause.HAVING) && !e.getGroupSet().equals(ImmutableBitSet.union(e.getGroupSets()))) {
            SqlNodeList groupingList = new SqlNodeList(POS);
            e.getGroupSet().forEach(g2 -> groupingList.add(builder.context.field((int)g2)));
            builder.setHaving(SqlStdOperatorTable.NOT_EQUALS.createCall(POS, SqlStdOperatorTable.GROUPING.createCall(groupingList), ZERO));
        }
        return builder;
    }

    private List<SqlNode> generateGroupList(SqlImplementor.Builder builder, List<SqlNode> selectList, Aggregate aggregate, List<Integer> groupList) {
        AbstractCollection groupSets;
        SqlNode field;
        List<Integer> sortedGroupList = Ordering.natural().sortedCopy(groupList);
        assert (aggregate.getGroupSet().asList().equals(sortedGroupList)) : "groupList " + groupList + " must be equal to groupSet " + aggregate.getGroupSet() + ", just possibly a different order";
        ArrayList<SqlNode> groupKeys = new ArrayList<SqlNode>();
        for (int key : groupList) {
            field = builder.context.field(key);
            groupKeys.add(field);
        }
        for (int key : sortedGroupList) {
            field = builder.context.field(key);
            this.addSelect(selectList, field, aggregate.getRowType());
        }
        switch (aggregate.getGroupType()) {
            case SIMPLE: {
                return ImmutableList.copyOf(groupKeys);
            }
            case CUBE: {
                if (aggregate.getGroupSet().cardinality() > 1) {
                    return ImmutableList.of(SqlStdOperatorTable.CUBE.createCall(SqlParserPos.ZERO, groupKeys));
                }
            }
            case ROLLUP: {
                return ImmutableList.of(SqlStdOperatorTable.ROLLUP.createCall(SqlParserPos.ZERO, groupKeys));
            }
        }
        if (aggregate.getGroupSet().equals(ImmutableBitSet.union(aggregate.groupSets))) {
            groupSets = aggregate.getGroupSets();
        } else {
            groupSets = new ArrayList(aggregate.getGroupSets().size() + 1);
            groupSets.add((ImmutableBitSet)aggregate.getGroupSet());
            groupSets.addAll(aggregate.getGroupSets());
        }
        return ImmutableList.of(SqlStdOperatorTable.GROUPING_SETS.createCall(SqlParserPos.ZERO, groupSets.stream().map(groupSet -> RelToSqlConverter.groupItem(groupKeys, groupSet, aggregate.getGroupSet())).collect(Collectors.toList())));
    }

    private static SqlNode groupItem(List<SqlNode> groupKeys, ImmutableBitSet groupSet, ImmutableBitSet wholeGroupSet) {
        List nodes = groupSet.asList().stream().map(key -> (SqlNode)groupKeys.get(wholeGroupSet.indexOf((int)key))).collect(Collectors.toList());
        switch (nodes.size()) {
            case 1: {
                return (SqlNode)nodes.get(0);
            }
        }
        return SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, nodes);
    }

    public SqlImplementor.Result visit(TableScan e) {
        SqlNode node;
        SqlIdentifier identifier = RelToSqlConverter.getSqlTargetTable(e);
        ImmutableList<RelHint> hints = e.getHints();
        if (!hints.isEmpty()) {
            SqlParserPos pos = identifier.getParserPosition();
            node = new SqlTableRef(pos, identifier, SqlNodeList.of(pos, hints.stream().map(h2 -> RelToSqlConverter.toSqlHint(h2, pos)).collect(Collectors.toList())));
        } else {
            node = identifier;
        }
        return this.result(node, ImmutableList.of(SqlImplementor.Clause.FROM), e, null);
    }

    private static SqlHint toSqlHint(RelHint hint, SqlParserPos pos) {
        if (hint.kvOptions != null) {
            return new SqlHint(pos, new SqlIdentifier(hint.hintName, pos), SqlNodeList.of(pos, hint.kvOptions.entrySet().stream().flatMap(e -> Stream.of(new SqlIdentifier((String)e.getKey(), pos), SqlLiteral.createCharString((String)e.getValue(), pos))).collect(Collectors.toList())), SqlHint.HintOptionFormat.KV_LIST);
        }
        if (hint.listOptions != null) {
            return new SqlHint(pos, new SqlIdentifier(hint.hintName, pos), SqlNodeList.of(pos, hint.listOptions.stream().map(e -> SqlLiteral.createCharString(e, pos)).collect(Collectors.toList())), SqlHint.HintOptionFormat.LITERAL_LIST);
        }
        return new SqlHint(pos, new SqlIdentifier(hint.hintName, pos), SqlNodeList.EMPTY, SqlHint.HintOptionFormat.EMPTY);
    }

    public SqlImplementor.Result visit(Union e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.UNION_ALL : SqlStdOperatorTable.UNION, e);
    }

    public SqlImplementor.Result visit(Intersect e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.INTERSECT_ALL : SqlStdOperatorTable.INTERSECT, e);
    }

    public SqlImplementor.Result visit(Minus e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.EXCEPT_ALL : SqlStdOperatorTable.EXCEPT, e);
    }

    public SqlImplementor.Result visit(Calc e) {
        RexProgram program = e.getProgram();
        ImmutableSet<SqlImplementor.Clause> expectedClauses = program.getCondition() != null ? ImmutableSet.of(SqlImplementor.Clause.WHERE) : ImmutableSet.of();
        SqlImplementor.Result x = this.visitInput((RelNode)e, 0, expectedClauses);
        this.parseCorrelTable(e, x);
        SqlImplementor.Builder builder = x.builder(e);
        if (!RelToSqlConverter.isStar(program)) {
            ArrayList<SqlNode> selectList = new ArrayList<SqlNode>(program.getProjectList().size());
            for (RexLocalRef ref : program.getProjectList()) {
                SqlNode sqlExpr = builder.context.toSql(program, ref);
                this.addSelect(selectList, sqlExpr, e.getRowType());
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
        }
        if (program.getCondition() != null) {
            builder.setWhere(builder.context.toSql(program, program.getCondition()));
        }
        return builder.result();
    }

    public SqlImplementor.Result visit(Values e) {
        SqlNode query;
        ImmutableList<SqlImplementor.Clause> clauses = ImmutableList.of(SqlImplementor.Clause.SELECT);
        ImmutableMap<String, RelDataType> pairs2 = ImmutableMap.of();
        SqlImplementor.Context context = this.aliasContext(pairs2, false);
        boolean rename = this.stack.size() <= 1 || !(Iterables.get(this.stack, 1).r instanceof TableModify);
        List<String> fieldNames = e.getRowType().getFieldNames();
        if (!this.dialect.supportsAliasedValues() && rename) {
            ArrayList<SqlSelect> list = new ArrayList<SqlSelect>();
            for (List list2 : e.getTuples()) {
                ArrayList<SqlCall> arrayList = new ArrayList<SqlCall>();
                SqlNodeList exprList = RelToSqlConverter.exprList(context, list2);
                for (Pair<SqlNode, String> value : Pair.zip(exprList, fieldNames)) {
                    arrayList.add(RelToSqlConverter.as((SqlNode)value.left, (String)value.right));
                }
                list.add(new SqlSelect(POS, null, new SqlNodeList(arrayList, POS), this.getDual(), null, null, null, null, null, null, null, null));
            }
            if (list.isEmpty()) {
                ArrayList<SqlCall> nullColumnNames = new ArrayList<SqlCall>(fieldNames.size());
                for (String string : fieldNames) {
                    SqlCall nullColumnName = RelToSqlConverter.as(SqlLiteral.createNull(POS), string);
                    nullColumnNames.add(nullColumnName);
                }
                SqlIdentifier sqlIdentifier = this.getDual();
                if (sqlIdentifier == null) {
                    query = new SqlSelect(POS, null, new SqlNodeList(nullColumnNames, POS), null, null, null, null, null, null, null, null, null);
                    query = new SqlSelect(POS, null, SqlNodeList.SINGLETON_STAR, RelToSqlConverter.as(query, "t"), RelToSqlConverter.createAlwaysFalseCondition(), null, null, null, null, null, null, null);
                } else {
                    query = new SqlSelect(POS, null, new SqlNodeList(nullColumnNames, POS), sqlIdentifier, RelToSqlConverter.createAlwaysFalseCondition(), null, null, null, null, null, null, null);
                }
            } else {
                query = list.size() == 1 ? (SqlNode)list.get(0) : SqlStdOperatorTable.UNION_ALL.createCall(new SqlNodeList(list, POS));
            }
        } else {
            SqlNodeList selects = new SqlNodeList(POS);
            boolean isEmpty = Values.isEmpty(e);
            if (isEmpty) {
                selects.add(SqlInternalOperators.ANONYMOUS_ROW.createCall(POS, Collections.nCopies(fieldNames.size(), SqlLiteral.createNull(POS))));
            } else {
                for (List list : e.getTuples()) {
                    selects.add(SqlInternalOperators.ANONYMOUS_ROW.createCall(RelToSqlConverter.exprList(context, list)));
                }
            }
            query = SqlStdOperatorTable.VALUES.createCall(selects);
            if (rename) {
                query = this.as(query, "t", fieldNames.toArray(new String[0]));
            }
            if (isEmpty) {
                if (!rename) {
                    query = RelToSqlConverter.as(query, "t");
                }
                query = new SqlSelect(POS, null, SqlNodeList.SINGLETON_STAR, query, RelToSqlConverter.createAlwaysFalseCondition(), null, null, null, null, null, null, null);
            }
        }
        return this.result(query, clauses, e, null);
    }

    private @Nullable SqlIdentifier getDual() {
        List<String> names = this.dialect.getSingleRowTableName();
        if (names == null) {
            return null;
        }
        return new SqlIdentifier(names, POS);
    }

    private static SqlNode createAlwaysFalseCondition() {
        return SqlStdOperatorTable.EQUALS.createCall(POS, ImmutableList.of(ONE, ZERO));
    }

    public SqlImplementor.Result visit(Sort e) {
        Aggregate aggregate;
        Project project;
        Permutation permutation;
        Aggregate aggregate2;
        if (e.getInput() instanceof Aggregate && this.hasTrickyRollup(e, aggregate2 = (Aggregate)e.getInput())) {
            LinkedHashSet<Integer> groupList = new LinkedHashSet<Integer>();
            for (RelFieldCollation fc : e.collation.getFieldCollations()) {
                groupList.add(aggregate2.getGroupSet().nth(fc.getFieldIndex()));
            }
            groupList.addAll(Aggregate.Group.getRollup(aggregate2.getGroupSets()));
            SqlImplementor.Builder builder = this.visitAggregate(aggregate2, ImmutableList.copyOf(groupList), SqlImplementor.Clause.GROUP_BY, SqlImplementor.Clause.OFFSET, SqlImplementor.Clause.FETCH);
            this.offsetFetch(e, builder);
            return builder.result();
        }
        if (e.getInput() instanceof Project && (permutation = (project = (Project)e.getInput()).getPermutation()) != null && project.getInput() instanceof Aggregate && this.hasTrickyRollup(e, aggregate = (Aggregate)project.getInput())) {
            RelCollation collation = RelCollations.permute(e.collation, permutation);
            LogicalSort logicalSort = LogicalSort.create(aggregate, collation, e.offset, e.fetch);
            LogicalProject project2 = LogicalProject.create((RelNode)logicalSort, ImmutableList.of(), project.getProjects(), project.getRowType());
            return this.visit(project2);
        }
        SqlImplementor.Result x = this.visitInput((RelNode)e, 0, SqlImplementor.Clause.ORDER_BY, SqlImplementor.Clause.OFFSET, SqlImplementor.Clause.FETCH);
        SqlImplementor.Builder builder = x.builder(e);
        if (this.stack.size() != 1 && builder.select.getSelectList().equals(SqlNodeList.SINGLETON_STAR)) {
            Expressions.FluentList<SqlNode> selectList = Expressions.list();
            for (RelDataTypeField relDataTypeField : e.getRowType().getFieldList()) {
                this.addSelect(selectList, builder.context.field(relDataTypeField.getIndex()), e.getRowType());
            }
            builder.select.setSelectList(new SqlNodeList(selectList, POS));
        }
        Expressions.FluentList<SqlNode> orderByList = Expressions.list();
        for (RelFieldCollation relFieldCollation : e.getCollation().getFieldCollations()) {
            builder.addOrderItem(orderByList, relFieldCollation);
        }
        if (!orderByList.isEmpty()) {
            builder.setOrderBy(new SqlNodeList(orderByList, POS));
        }
        this.offsetFetch(e, builder);
        return builder.result();
    }

    void offsetFetch(Sort e, SqlImplementor.Builder builder) {
        if (e.fetch != null) {
            builder.setFetch(builder.context.toSql(null, e.fetch));
        }
        if (e.offset != null) {
            builder.setOffset(builder.context.toSql(null, e.offset));
        }
    }

    public boolean hasTrickyRollup(Sort e, Aggregate aggregate) {
        return !this.dialect.supportsAggregateFunction(SqlKind.ROLLUP) && this.dialect.supportsGroupByWithRollup() && (aggregate.getGroupType() == Aggregate.Group.ROLLUP || aggregate.getGroupType() == Aggregate.Group.CUBE && aggregate.getGroupSet().cardinality() == 1) && e.collation.getFieldCollations().stream().allMatch(fc -> fc.getFieldIndex() < aggregate.getGroupSet().cardinality());
    }

    private static SqlIdentifier getSqlTargetTable(RelNode e) {
        RelOptTable table = Objects.requireNonNull(e.getTable());
        return table.maybeUnwrap(JdbcTable.class).map(JdbcTable::tableName).orElseGet(() -> new SqlIdentifier(table.getQualifiedName(), SqlParserPos.ZERO));
    }

    public SqlImplementor.Result visit(TableModify modify) {
        ImmutableMap<String, RelDataType> pairs2 = ImmutableMap.of();
        SqlImplementor.Context context = this.aliasContext(pairs2, false);
        SqlIdentifier sqlTargetTable = RelToSqlConverter.getSqlTargetTable(modify);
        switch (modify.getOperation()) {
            case INSERT: {
                SqlNode sqlSource = this.visitInput(modify, 0).asQueryOrValues();
                SqlInsert sqlInsert = new SqlInsert(POS, SqlNodeList.EMPTY, sqlTargetTable, sqlSource, RelToSqlConverter.identifierList(modify.getTable().getRowType().getFieldNames()));
                return this.result(sqlInsert, ImmutableList.of(), modify, null);
            }
            case UPDATE: {
                SqlImplementor.Result input = this.visitInput(modify, 0);
                SqlUpdate sqlUpdate = new SqlUpdate(POS, sqlTargetTable, RelToSqlConverter.identifierList(Objects.requireNonNull(modify.getUpdateColumnList(), () -> "modify.getUpdateColumnList() is null for " + modify)), RelToSqlConverter.exprList(context, Objects.requireNonNull(modify.getSourceExpressionList(), () -> "modify.getSourceExpressionList() is null for " + modify)), ((SqlSelect)input.node).getWhere(), input.asSelect(), null);
                return this.result(sqlUpdate, input.clauses, modify, null);
            }
            case DELETE: {
                SqlImplementor.Result input = this.visitInput(modify, 0);
                SqlDelete sqlDelete = new SqlDelete(POS, sqlTargetTable, input.asSelect().getWhere(), input.asSelect(), null);
                return this.result(sqlDelete, input.clauses, modify, null);
            }
        }
        throw new AssertionError((Object)("not implemented: " + modify));
    }

    private static SqlNodeList exprList(SqlImplementor.Context context, List<? extends RexNode> exprs) {
        return new SqlNodeList(Util.transform(exprs, e -> context.toSql(null, (RexNode)e)), POS);
    }

    private static SqlNodeList identifierList(List<String> names) {
        return new SqlNodeList(Util.transform(names, name -> new SqlIdentifier((String)name, POS)), POS);
    }

    public SqlImplementor.Result visit(Match e) {
        SqlNode after;
        SqlLiteral rowsPerMatch;
        RelNode input = e.getInput();
        SqlImplementor.Result x = this.visitInput(e, 0);
        SqlImplementor.Context context = this.matchRecognizeContext(x.qualifiedContext());
        SqlNode tableRef = x.asQueryOrValues();
        RexBuilder rexBuilder = input.getCluster().getRexBuilder();
        ArrayList<SqlNode> partitionSqlList = new ArrayList<SqlNode>();
        for (int key : e.getPartitionKeys()) {
            RexInputRef ref = rexBuilder.makeInputRef(input, key);
            SqlNode sqlNode = context.toSql(null, ref);
            partitionSqlList.add(sqlNode);
        }
        SqlNodeList partitionList = new SqlNodeList(partitionSqlList, POS);
        ArrayList<SqlNode> orderBySqlList = new ArrayList<SqlNode>();
        if (e.getOrderKeys() != null) {
            for (RelFieldCollation fc : e.getOrderKeys().getFieldCollations()) {
                if (fc.nullDirection != RelFieldCollation.NullDirection.UNSPECIFIED) {
                    boolean first = fc.nullDirection == RelFieldCollation.NullDirection.FIRST;
                    SqlNode nullDirectionNode = this.dialect.emulateNullDirection(context.field(fc.getFieldIndex()), first, fc.direction.isDescending());
                    if (nullDirectionNode != null) {
                        orderBySqlList.add(nullDirectionNode);
                        fc = new RelFieldCollation(fc.getFieldIndex(), fc.getDirection(), RelFieldCollation.NullDirection.UNSPECIFIED);
                    }
                }
                orderBySqlList.add(context.toSql(fc));
            }
        }
        SqlNodeList orderByList = new SqlNodeList(orderBySqlList, SqlParserPos.ZERO);
        SqlLiteral sqlLiteral = rowsPerMatch = e.isAllRows() ? SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS.symbol(POS) : SqlMatchRecognize.RowsPerMatchOption.ONE_ROW.symbol(POS);
        if (e.getAfter() instanceof RexLiteral) {
            SqlMatchRecognize.AfterOption value = (SqlMatchRecognize.AfterOption)((RexLiteral)e.getAfter()).getValue2();
            after = SqlLiteral.createSymbol(value, POS);
        } else {
            RexCall call = (RexCall)e.getAfter();
            String operand = Objects.requireNonNull(RexLiteral.stringValue(call.getOperands().get(0)), () -> "non-null string value expected for 0th operand of AFTER call " + call);
            after = call.getOperator().createCall(POS, new SqlIdentifier(operand, POS));
        }
        RexNode rexPattern = e.getPattern();
        SqlNode pattern = context.toSql(null, rexPattern);
        SqlLiteral strictStart = SqlLiteral.createBoolean(e.isStrictStart(), POS);
        SqlLiteral strictEnd = SqlLiteral.createBoolean(e.isStrictEnd(), POS);
        RexLiteral rexInterval = (RexLiteral)e.getInterval();
        SqlIntervalLiteral interval = null;
        if (rexInterval != null) {
            interval = (SqlIntervalLiteral)context.toSql(null, rexInterval);
        }
        SqlNodeList subsetList = new SqlNodeList(POS);
        for (Object entry : e.getSubsets().entrySet()) {
            SqlIdentifier left = new SqlIdentifier((String)entry.getKey(), POS);
            ArrayList<SqlIdentifier> rhl = new ArrayList<SqlIdentifier>();
            for (String right : (SortedSet)entry.getValue()) {
                rhl.add(new SqlIdentifier(right, POS));
            }
            subsetList.add(SqlStdOperatorTable.EQUALS.createCall(POS, left, new SqlNodeList(rhl, POS)));
        }
        SqlNodeList measureList = new SqlNodeList(POS);
        for (Object entry : e.getMeasures().entrySet()) {
            String alias = (String)entry.getKey();
            SqlNode sqlNode = context.toSql(null, (RexNode)entry.getValue());
            measureList.add(RelToSqlConverter.as(sqlNode, alias));
        }
        SqlNodeList patternDefList = new SqlNodeList(POS);
        for (Map.Entry entry : e.getPatternDefinitions().entrySet()) {
            String alias = (String)entry.getKey();
            SqlNode sqlNode = context.toSql(null, (RexNode)entry.getValue());
            patternDefList.add(RelToSqlConverter.as(sqlNode, alias));
        }
        SqlMatchRecognize matchRecognize = new SqlMatchRecognize(POS, tableRef, pattern, strictStart, strictEnd, patternDefList, measureList, after, subsetList, rowsPerMatch, partitionList, orderByList, interval);
        return this.result(matchRecognize, Expressions.list(SqlImplementor.Clause.FROM), e, null);
    }

    private static SqlCall as(SqlNode e, String alias) {
        return SqlStdOperatorTable.AS.createCall(POS, e, new SqlIdentifier(alias, POS));
    }

    public SqlImplementor.Result visit(Uncollect e) {
        SqlImplementor.Result x = this.visitInput(e, 0);
        SqlCall unnestNode = SqlStdOperatorTable.UNNEST.createCall(POS, x.asStatement());
        List<SqlNode> operands = this.createAsFullOperands(e.getRowType(), unnestNode, Objects.requireNonNull(x.neededAlias, () -> "x.neededAlias is null, node is " + x.node));
        SqlCall asNode = SqlStdOperatorTable.AS.createCall(POS, operands);
        return this.result(asNode, ImmutableList.of(SqlImplementor.Clause.FROM), e, null);
    }

    public SqlImplementor.Result visit(TableFunctionScan e) {
        ArrayList<SqlNode> inputSqlNodes = new ArrayList<SqlNode>();
        int inputSize = e.getInputs().size();
        for (int i = 0; i < inputSize; ++i) {
            SqlImplementor.Result x = this.visitInput(e, i);
            inputSqlNodes.add(x.asStatement());
        }
        SqlImplementor.Context context = this.tableFunctionScanContext(inputSqlNodes);
        SqlNode callNode = context.toSql(null, e.getCall());
        SqlBasicCall tableCall = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.COLLECTION_TABLE, ImmutableList.of(callNode), SqlParserPos.ZERO);
        SqlSelect select2 = new SqlSelect(SqlParserPos.ZERO, null, SqlNodeList.SINGLETON_STAR, tableCall, null, null, null, null, null, null, null, SqlNodeList.EMPTY);
        return this.result(select2, ImmutableList.of(SqlImplementor.Clause.SELECT), e, null);
    }

    public List<SqlNode> createAsFullOperands(RelDataType rowType, SqlNode leftOperand, String alias) {
        ArrayList<SqlNode> result = new ArrayList<SqlNode>();
        result.add(leftOperand);
        result.add(new SqlIdentifier(alias, POS));
        Ord.forEach(rowType.getFieldNames(), (fieldName, i) -> {
            if (SqlUtil.isGeneratedAlias(fieldName)) {
                fieldName = "col_" + i;
            }
            result.add(new SqlIdentifier((String)fieldName, POS));
        });
        return result;
    }

    @Override
    public void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        String name = rowType.getFieldNames().get(selectList.size());
        String alias = SqlValidatorUtil.getAlias(node, -1);
        if (alias == null || !alias.equals(name)) {
            node = RelToSqlConverter.as(node, name);
        }
        selectList.add(node);
    }

    private void parseCorrelTable(RelNode relNode, SqlImplementor.Result x) {
        for (CorrelationId id : relNode.getVariablesSet()) {
            this.correlTableMap.put(id, x.qualifiedContext());
        }
    }

    private static class Frame {
        private final RelNode parent;
        private final int ordinalInParent;
        private final RelNode r;
        private final boolean anon;
        private final boolean ignoreClauses;
        private final ImmutableSet<? extends SqlImplementor.Clause> expectedClauses;

        Frame(RelNode parent, int ordinalInParent, RelNode r, boolean anon, boolean ignoreClauses, Iterable<? extends SqlImplementor.Clause> expectedClauses) {
            this.parent = Objects.requireNonNull(parent, "parent");
            this.ordinalInParent = ordinalInParent;
            this.r = Objects.requireNonNull(r, "r");
            this.anon = anon;
            this.ignoreClauses = ignoreClauses;
            this.expectedClauses = ImmutableSet.copyOf(expectedClauses);
        }
    }

    private static class AliasReplacementShuttle
    extends SqlShuttle {
        private final String tableAlias;
        private final RelDataType tableType;
        private final SqlNodeList replaceSource;

        AliasReplacementShuttle(String tableAlias, RelDataType tableType, SqlNodeList replaceSource) {
            this.tableAlias = tableAlias;
            this.tableType = tableType;
            this.replaceSource = replaceSource;
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (this.tableAlias.equals(id.names.get(0))) {
                int index = Objects.requireNonNull(this.tableType.getField((String)id.names.get(1), false, false), () -> "field " + (String)id.names.get(1) + " is not found in " + this.tableType).getIndex();
                SqlNode selectItem = Objects.requireNonNull(this.replaceSource, "replaceSource").get(index);
                if (selectItem.getKind() == SqlKind.AS) {
                    selectItem = ((SqlCall)selectItem).operand(0);
                }
                return selectItem.clone(id.getParserPosition());
            }
            return id;
        }
    }
}

