/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.ImmutableAggregateJoinRemoveRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.immutables.value.Value;

@Value.Enclosing
public class AggregateJoinRemoveRule
extends RelRule<Config>
implements TransformationRule {
    protected AggregateJoinRemoveRule(Config config) {
        super(config);
    }

    @Deprecated
    public AggregateJoinRemoveRule(Class<? extends Aggregate> aggregateClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(aggregateClass, joinClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode node;
        Aggregate aggregate = (Aggregate)call.rel(0);
        Join join = (Join)call.rel(1);
        boolean isLeftJoin = join.getJoinType() == JoinRelType.LEFT;
        int lower2 = isLeftJoin ? join.getLeft().getRowType().getFieldCount() : 0;
        int upper2 = isLeftJoin ? join.getRowType().getFieldCount() : join.getLeft().getRowType().getFieldCount();
        Set<Integer> allFields = RelOptUtil.getAllFields(aggregate);
        if (allFields.stream().anyMatch(i -> i >= lower2 && i < upper2)) {
            return;
        }
        if (aggregate.getAggCallList().stream().anyMatch(aggregateCall -> !aggregateCall.isDistinct())) {
            return;
        }
        if (isLeftJoin) {
            node = aggregate.copy(aggregate.getTraitSet(), join.getLeft(), aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList());
        } else {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            allFields.forEach(index -> map.put((Integer)index, index - upper2));
            ImmutableBitSet groupSet = aggregate.getGroupSet().permute(map);
            ImmutableList.Builder aggCalls = ImmutableList.builder();
            int sourceCount = aggregate.getInput().getRowType().getFieldCount();
            Mappings.TargetMapping targetMapping = Mappings.target(map, sourceCount, sourceCount);
            aggregate.getAggCallList().forEach(aggregateCall -> aggCalls.add(aggregateCall.transform(targetMapping)));
            RelBuilder relBuilder = call.builder();
            node = relBuilder.push(join.getRight()).aggregate(relBuilder.groupKey(groupSet), (List<AggregateCall>)((Object)aggCalls.build())).build();
        }
        call.transformTo(node);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateJoinRemoveRule.Config.of().withOperandFor(LogicalAggregate.class, LogicalJoin.class);

        @Override
        default public AggregateJoinRemoveRule toRule() {
            return new AggregateJoinRemoveRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass, Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).oneInput(b1 -> b1.operand(joinClass).predicate(join -> join.getJoinType() == JoinRelType.LEFT || join.getJoinType() == JoinRelType.RIGHT).anyInputs())).as(Config.class);
        }
    }
}

