/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableSortRemoveConstantKeysRule;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class SortRemoveConstantKeysRule
extends RelRule<Config>
implements SubstitutionRule {
    protected SortRemoveConstantKeysRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        Sort sort2 = (Sort)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(input = sort2.getInput());
        if (RelOptPredicateList.isEmpty(predicates)) {
            return;
        }
        RexBuilder rexBuilder = sort2.getCluster().getRexBuilder();
        List<RelFieldCollation> collationsList = sort2.getCollation().getFieldCollations().stream().filter(fc -> !predicates.constantMap.containsKey(rexBuilder.makeInputRef(input, fc.getFieldIndex()))).collect(Collectors.toList());
        if (collationsList.size() == sort2.collation.getFieldCollations().size()) {
            return;
        }
        if (collationsList.isEmpty() && sort2.offset == null && sort2.fetch == null) {
            call.transformTo(input);
            call.getPlanner().prune(sort2);
            return;
        }
        Sort result = sort2.copy(sort2.getTraitSet(), input, RelCollations.of(collationsList));
        call.transformTo(result);
        call.getPlanner().prune(sort2);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortRemoveConstantKeysRule.Config.of().withOperandSupplier(b -> b.operand(Sort.class).anyInputs());

        @Override
        default public SortRemoveConstantKeysRule toRule() {
            return new SortRemoveConstantKeysRule(this);
        }
    }
}

