/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableSortUnionTransposeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class SortUnionTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected SortUnionTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public SortUnionTransposeRule(Class<? extends Sort> sortClass, Class<? extends Union> unionClass, boolean matchNullFetch, RelBuilderFactory relBuilderFactory, String description) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).as(Config.class).withOperandFor(sortClass, unionClass).withMatchNullFetch(matchNullFetch));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort2 = (Sort)call.rel(0);
        Union union = (Union)call.rel(1);
        return union.all && sort2.offset == null && (((Config)this.config).matchNullFetch() || sort2.fetch != null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort2 = (Sort)call.rel(0);
        Union union = (Union)call.rel(1);
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        boolean ret = true;
        RelMetadataQuery mq = call.getMetadataQuery();
        for (RelNode input : union.getInputs()) {
            if (!RelMdUtil.checkInputForCollationAndLimit(mq, input, sort2.getCollation(), sort2.offset, sort2.fetch)) {
                ret = false;
                Sort branchSort = sort2.copy(sort2.getTraitSet(), input, sort2.getCollation(), sort2.offset, sort2.fetch);
                inputs.add(branchSort);
                continue;
            }
            inputs.add(input);
        }
        if (ret) {
            return;
        }
        Union unionCopy = (Union)union.copy(union.getTraitSet(), inputs, union.all);
        Sort result = sort2.copy(sort2.getTraitSet(), unionCopy, sort2.getCollation(), sort2.offset, sort2.fetch);
        call.transformTo(result);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortUnionTransposeRule.Config.of().withOperandFor(Sort.class, Union.class).withMatchNullFetch(false);

        @Override
        default public SortUnionTransposeRule toRule() {
            return new SortUnionTransposeRule(this);
        }

        @Value.Default
        default public boolean matchNullFetch() {
            return false;
        }

        public Config withMatchNullFetch(boolean var1);

        default public Config withOperandFor(Class<? extends Sort> sortClass, Class<? extends Union> unionClass) {
            return this.withOperandSupplier(b0 -> b0.operand(sortClass).oneInput(b1 -> b1.operand(unionClass).anyInputs())).as(Config.class);
        }
    }
}

