/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules.materialize;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateProjectPullUpConstantsRule;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.materialize.MaterializedViewRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

public abstract class MaterializedViewAggregateRule<C extends Config>
extends MaterializedViewRule<C> {
    protected static final ImmutableList<TimeUnitRange> SUPPORTED_DATE_TIME_ROLLUP_UNITS = ImmutableList.of(TimeUnitRange.YEAR, TimeUnitRange.QUARTER, TimeUnitRange.MONTH, TimeUnitRange.DAY, TimeUnitRange.HOUR, TimeUnitRange.MINUTE, TimeUnitRange.SECOND, TimeUnitRange.MILLISECOND, TimeUnitRange.MICROSECOND);

    MaterializedViewAggregateRule(C config) {
        super(config);
    }

    @Override
    protected boolean isValidPlan(@Nullable Project topProject, RelNode node, RelMetadataQuery mq) {
        if (!(node instanceof Aggregate)) {
            return false;
        }
        Aggregate aggregate = (Aggregate)node;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            return false;
        }
        return this.isValidRelNodePlan(aggregate.getInput(), mq);
    }

    @Override
    protected @Nullable MaterializedViewRule.ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, @Nullable Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, MaterializedViewRule.EquivalenceClasses queryEC, @Nullable Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
        HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
        for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
            if (viewTableRefs.contains(tRef)) continue;
            extraTableRefs.add(tRef);
        }
        Multimap<Class<? extends RelNode>, RelNode> nodeTypes = mq.getNodeTypes(node);
        if (nodeTypes == null) {
            return null;
        }
        Collection<RelNode> tableScanNodes = nodeTypes.get(TableScan.class);
        if (tableScanNodes == null) {
            return null;
        }
        ArrayList<RelNode> newRels = new ArrayList<RelNode>();
        block1: for (RexTableInputRef.RelTableRef tRef : extraTableRefs) {
            int i = 0;
            for (RelNode relNode : tableScanNodes) {
                TableScan scan = (TableScan)relNode;
                if (!tRef.getQualifiedName().equals(scan.getTable().getQualifiedName()) || tRef.getEntityNumber() != i++) continue;
                newRels.add(relNode);
                continue block1;
            }
        }
        assert (extraTableRefs.size() == newRels.size());
        relBuilder.push(input);
        for (RelNode newRel : newRels) {
            relBuilder.push(newRel);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
        }
        RelNode newView = relBuilder.build();
        Aggregate aggregateViewNode = (Aggregate)viewNode;
        relBuilder.push(aggregateViewNode.getInput());
        int offset = 0;
        for (RelNode newRel : newRels) {
            relBuilder.push(newRel);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            offset += newRel.getRowType().getFieldCount();
        }
        ImmutableBitSet.Builder groupSet = ImmutableBitSet.builder();
        groupSet.addAll(aggregateViewNode.getGroupSet());
        groupSet.addAll(ImmutableBitSet.range(aggregateViewNode.getInput().getRowType().getFieldCount(), aggregateViewNode.getInput().getRowType().getFieldCount() + offset));
        Aggregate newViewNode = aggregateViewNode.copy(aggregateViewNode.getTraitSet(), relBuilder.build(), groupSet.build(), null, aggregateViewNode.getAggCallList());
        relBuilder.push(newViewNode);
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (topViewProject != null) {
            int i;
            Mappings.TargetMapping shiftMapping = Mappings.createShiftMapping(newViewNode.getRowType().getFieldCount(), 0, 0, aggregateViewNode.getGroupCount(), newViewNode.getGroupCount(), aggregateViewNode.getGroupCount(), aggregateViewNode.getAggCallList().size());
            for (i = 0; i < topViewProject.getProjects().size(); ++i) {
                nodes.add(topViewProject.getProjects().get(i).accept(new RexPermuteInputsShuttle(shiftMapping, newViewNode)));
                fieldNames.add(topViewProject.getRowType().getFieldNames().get(i));
            }
            for (i = aggregateViewNode.getRowType().getFieldCount(); i < newViewNode.getRowType().getFieldCount(); ++i) {
                int idx = i - aggregateViewNode.getAggCallList().size();
                nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
            }
        } else {
            for (int i = 0; i < newViewNode.getRowType().getFieldCount(); ++i) {
                int idx = i < aggregateViewNode.getGroupCount() ? i : (i < aggregateViewNode.getRowType().getFieldCount() ? i + offset : i - aggregateViewNode.getAggCallList().size());
                nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
            }
        }
        relBuilder.project(nodes, fieldNames, true);
        Project newTopViewProject = (Project)relBuilder.build();
        return MaterializedViewRule.ViewPartialRewriting.of(newView, newTopViewProject, newViewNode);
    }

    @Override
    protected @Nullable RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, @Nullable Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, MaterializedViewRule.EquivalenceClasses viewEC, MaterializedViewRule.EquivalenceClasses queryEC) {
        Aggregate aggregate = (Aggregate)node;
        RelNode newAggregateInput = aggregate.getInput(0);
        RelNode target = aggregate.getInput(0);
        HepProgram unionRewritingPullProgram = ((Config)this.config).unionRewritingPullProgram();
        if (unionRewritingPullProgram != null) {
            HepPlanner tmpPlanner = new HepPlanner(unionRewritingPullProgram);
            tmpPlanner.setRoot(newAggregateInput);
            newAggregateInput = tmpPlanner.findBestExp();
            target = newAggregateInput.getInput(0);
        }
        List<RexNode> queryExprs = this.extractReferences(rexBuilder, target);
        if (!compensationColumnsEquiPred.isAlwaysTrue()) {
            RexNode newCompensationColumnsEquiPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, queryToViewTableMapping, queryEC, false, compensationColumnsEquiPred);
            if (newCompensationColumnsEquiPred == null) {
                return null;
            }
            compensationColumnsEquiPred = newCompensationColumnsEquiPred;
        }
        if (!otherCompensationPred.isAlwaysTrue()) {
            RexNode newOtherCompensationPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, queryToViewTableMapping, viewEC, true, otherCompensationPred);
            if (newOtherCompensationPred == null) {
                return null;
            }
            otherCompensationPred = newOtherCompensationPred;
        }
        RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationColumnsEquiPred, otherCompensationPred)));
        RelNode rewrittenPlan = relBuilder.push(target).filter(simplify.simplifyUnknownAsFalse(queryCompensationPred)).build();
        if (((Config)this.config).unionRewritingPullProgram() != null) {
            return aggregate.copy(aggregate.getTraitSet(), ImmutableList.of(newAggregateInput.copy(newAggregateInput.getTraitSet(), ImmutableList.of(rewrittenPlan))));
        }
        return aggregate.copy(aggregate.getTraitSet(), ImmutableList.of(rewrittenPlan));
    }

    @Override
    protected @Nullable RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, @Nullable RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
        RelNode result;
        relBuilder.push(unionInputQuery);
        relBuilder.push(unionInputView);
        relBuilder.union(true);
        ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
        ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
        for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
            RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
            exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
            nameList.add(field.getName());
        }
        relBuilder.project(exprList, nameList);
        Aggregate aggregate = (Aggregate)unionInputQuery;
        ImmutableBitSet groupSet = ImmutableBitSet.range(aggregate.getGroupCount());
        ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            AggregateCall aggCall = aggregate.getAggCallList().get(i);
            if (aggCall.isDistinct()) {
                return null;
            }
            SqlAggFunction rollupAgg = aggCall.getAggregation().getRollup();
            if (rollupAgg == null) {
                return null;
            }
            RexInputRef operand = rexBuilder.makeInputRef(relBuilder.peek(), aggregate.getGroupCount() + i);
            aggregateCalls.add(relBuilder.aggregateCall(rollupAgg, operand).distinct(aggCall.isDistinct()).approximate(aggCall.isApproximate()).as(aggCall.name));
        }
        RelNode prevNode = relBuilder.peek();
        if (prevNode == (result = relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<RelBuilder.AggCall>)aggregateCalls).build()) && groupSet.cardinality() != result.getRowType().getFieldCount()) {
            result = relBuilder.push(result).project(relBuilder.fields(groupSet)).build();
        }
        if (topProject != null) {
            return topProject.copy(topProject.getTraitSet(), ImmutableList.of(result));
        }
        return result;
    }

    @Override
    protected @Nullable RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, MaterializedViewRule.MatchModality matchModality, boolean unionRewriting, RelNode input, @Nullable Project topProject, RelNode node, @Nullable Project topViewProject0, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, MaterializedViewRule.EquivalenceClasses queryEC) {
        RelDataType topRowType;
        ImmutableMultimap<Integer, Integer> rewritingMapping;
        ImmutableBitSet references;
        Aggregate queryAggregate = (Aggregate)node;
        Aggregate viewAggregate = (Aggregate)viewNode;
        ImmutableBitSet.Builder indexes = ImmutableBitSet.builder();
        if (topProject != null && !unionRewriting) {
            int i;
            RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(new LinkedHashSet<RelDataTypeField>());
            inputFinder.visitEach(topProject.getProjects());
            references = inputFinder.build();
            for (i = 0; i < queryAggregate.getGroupCount(); ++i) {
                indexes.set(queryAggregate.getGroupSet().nth(i));
            }
            for (i = 0; i < queryAggregate.getAggCallList().size(); ++i) {
                if (!references.get(queryAggregate.getGroupCount() + i)) continue;
                for (int inputIdx : queryAggregate.getAggCallList().get(i).getArgList()) {
                    indexes.set(inputIdx);
                }
            }
        } else {
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                indexes.set(queryAggregate.getGroupSet().nth(i));
            }
            for (AggregateCall queryAggCall : queryAggregate.getAggCallList()) {
                for (int inputIdx : queryAggCall.getArgList()) {
                    indexes.set(inputIdx);
                }
            }
            references = null;
        }
        ArrayList<RexNode> rollupNodes = new ArrayList<RexNode>();
        Multimap<Integer, Integer> m3 = this.generateMapping(rexBuilder, simplify, mq, queryAggregate.getInput(), viewAggregate.getInput(), indexes.build(), queryToViewTableMapping, queryEC, rollupNodes);
        if (m3 == null) {
            return null;
        }
        int viewAggregateAdditionalFieldCount = rollupNodes.size();
        int viewInputFieldCount = viewAggregate.getInput().getRowType().getFieldCount();
        int viewInputDifferenceViewFieldCount = viewAggregate.getRowType().getFieldCount() - viewInputFieldCount;
        int viewAggregateTotalFieldCount = viewAggregate.getRowType().getFieldCount() + rollupNodes.size();
        boolean forceRollup = false;
        Mapping aggregateMapping = Mappings.create(MappingType.FUNCTION, queryAggregate.getRowType().getFieldCount(), viewAggregateTotalFieldCount);
        for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
            Collection<Integer> c = m3.get(queryAggregate.getGroupSet().nth(i));
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                if (j >= viewAggregate.getInput().getRowType().getFieldCount()) {
                    aggregateMapping.set(i, j + viewInputDifferenceViewFieldCount);
                    forceRollup = true;
                    break;
                }
                int targetIdx = viewAggregate.getGroupSet().indexOf(j);
                if (targetIdx == -1) continue;
                aggregateMapping.set(i, targetIdx);
                break;
            }
            if (aggregateMapping.getTargetOpt(i) != -1) continue;
            return null;
        }
        boolean containsDistinctAgg = false;
        block8: for (Ord ord : Ord.zip(queryAggregate.getAggCallList())) {
            if (references != null && !references.get(queryAggregate.getGroupCount() + ord.i)) continue;
            AggregateCall queryAggCall = (AggregateCall)ord.e;
            if (queryAggCall.filterArg >= 0) {
                return null;
            }
            ArrayList<Integer> queryAggCallIndexes = new ArrayList<Integer>();
            for (int aggCallIdx : queryAggCall.getArgList()) {
                queryAggCallIndexes.add(m3.get(aggCallIdx).iterator().next());
            }
            for (int j = 0; j < viewAggregate.getAggCallList().size(); ++j) {
                AggregateCall viewAggCall = viewAggregate.getAggCallList().get(j);
                if (queryAggCall.getAggregation().getKind() != viewAggCall.getAggregation().getKind() || queryAggCall.isDistinct() != viewAggCall.isDistinct() || queryAggCall.getArgList().size() != viewAggCall.getArgList().size() || queryAggCall.getType() != viewAggCall.getType() || viewAggCall.filterArg >= 0 || !queryAggCallIndexes.equals(viewAggCall.getArgList())) continue;
                aggregateMapping.set(queryAggregate.getGroupCount() + ord.i, viewAggregate.getGroupCount() + j);
                if (!queryAggCall.isDistinct()) continue block8;
                containsDistinctAgg = true;
                continue block8;
            }
        }
        Project topViewProject = topViewProject0 != null ? topViewProject0 : (Project)relBuilder.push(viewNode).project(relBuilder.fields(), ImmutableList.of(), true).build();
        ArrayList<RexInputRef> arrayList = new ArrayList<RexInputRef>();
        relBuilder.push(input);
        ArrayList<RexNode> inputViewExprs = new ArrayList<RexNode>(relBuilder.fields());
        if (forceRollup || queryAggregate.getGroupCount() != viewAggregate.getGroupCount() || matchModality == MaterializedViewRule.MatchModality.VIEW_PARTIAL) {
            if (containsDistinctAgg) {
                return null;
            }
            ImmutableMultimap.Builder<Integer, Integer> rewritingMappingB = ImmutableMultimap.builder();
            ImmutableBitSet.Builder groupSetB = ImmutableBitSet.builder();
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                int targetIdx = aggregateMapping.getTargetOpt(i);
                if (targetIdx == -1) {
                    return null;
                }
                if (targetIdx >= viewAggregate.getRowType().getFieldCount()) {
                    RexNode targetNode = (RexNode)rollupNodes.get(targetIdx - viewInputFieldCount - viewInputDifferenceViewFieldCount);
                    ArrayListMultimap<RexNode, Integer> exprsLineage = ArrayListMultimap.create();
                    for (int r : RelOptUtil.InputFinder.bits(targetNode)) {
                        int j = MaterializedViewAggregateRule.find(viewNode, r);
                        int k = MaterializedViewAggregateRule.find(topViewProject, j);
                        if (k < 0) {
                            return null;
                        }
                        RexInputRef ref = relBuilder.with(viewNode.getInput(0), b -> b.field(r));
                        exprsLineage.put(ref, k);
                    }
                    groupSetB.set(inputViewExprs.size());
                    rewritingMappingB.put(inputViewExprs.size(), i);
                    arrayList.add(new RexInputRef(targetIdx, targetNode.getType()));
                    RexNode rollupExpression = Objects.requireNonNull(this.shuttleReferences(rexBuilder, targetNode, exprsLineage), () -> "shuttleReferences produced null for targetNode=" + targetNode + ", exprsLineage=" + exprsLineage);
                    inputViewExprs.add(rollupExpression);
                    continue;
                }
                int k = MaterializedViewAggregateRule.find(topViewProject, targetIdx);
                if (k < 0) {
                    return null;
                }
                groupSetB.set(k);
                rewritingMappingB.put(k, i);
            }
            ImmutableBitSet groupSet = groupSetB.build();
            ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
            for (Ord<AggregateCall> ord : Ord.zip(queryAggregate.getAggCallList())) {
                int sourceIdx = queryAggregate.getGroupCount() + ord.i;
                if (references != null && !references.get(sourceIdx)) continue;
                int targetIdx = aggregateMapping.getTargetOpt(sourceIdx);
                if (targetIdx < 0) {
                    return null;
                }
                int k = MaterializedViewAggregateRule.find(topViewProject, targetIdx);
                if (k < 0) {
                    return null;
                }
                AggregateCall queryAggCall = (AggregateCall)ord.e;
                SqlAggFunction rollupAgg = queryAggCall.getAggregation().getRollup();
                if (rollupAgg == null) {
                    return null;
                }
                rewritingMappingB.put(k, queryAggregate.getGroupCount() + aggregateCalls.size());
                RexInputRef operand = rexBuilder.makeInputRef(input, k);
                aggregateCalls.add(relBuilder.aggregateCall(rollupAgg, operand).approximate(queryAggCall.isApproximate()).distinct(queryAggCall.isDistinct()).as(queryAggCall.name));
            }
            RelNode prevNode = relBuilder.peek();
            if (inputViewExprs.size() > prevNode.getRowType().getFieldCount()) {
                relBuilder.project(inputViewExprs);
            }
            relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<RelBuilder.AggCall>)aggregateCalls);
            if (prevNode == relBuilder.peek() && groupSet.cardinality() != relBuilder.peek().getRowType().getFieldCount()) {
                relBuilder.project(relBuilder.fields(groupSet));
            }
            rewritingMapping = rewritingMappingB.build();
            ImmutableMultimap inverseMapping = rewritingMapping.inverse();
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            ImmutableBitSet.Builder addedProjects = ImmutableBitSet.builder();
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                int pos = groupSet.indexOf((Integer)((ImmutableCollection)inverseMapping.get((Object)i)).iterator().next());
                addedProjects.set(pos);
                projects.add(relBuilder.field(pos));
            }
            ImmutableBitSet projectedCols = addedProjects.build();
            for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
                if (projectedCols.get(i)) continue;
                projects.add(relBuilder.field(i));
            }
            relBuilder.project(projects);
        } else {
            rewritingMapping = null;
        }
        ArrayList<RexNode> topExprs = new ArrayList<RexNode>();
        if (topProject != null && !unionRewriting) {
            topExprs.addAll(topProject.getProjects());
            topRowType = topProject.getRowType();
        } else {
            for (int pos = 0; pos < queryAggregate.getRowType().getFieldCount(); ++pos) {
                topExprs.add(rexBuilder.makeInputRef(queryAggregate, pos));
            }
            topRowType = queryAggregate.getRowType();
        }
        ArrayListMultimap<RexNode, Integer> viewExprs = ArrayListMultimap.create();
        MaterializedViewAggregateRule.addAllIndexed(viewExprs, topViewProject.getProjects());
        MaterializedViewAggregateRule.addAllIndexed(viewExprs, arrayList);
        ArrayList<RexNode> rewrittenExprs = new ArrayList<RexNode>(topExprs.size());
        for (RexNode expr : topExprs) {
            RexNode e2 = this.shuttleReferences(rexBuilder, expr, aggregateMapping);
            if (e2 == null) {
                return null;
            }
            RexNode e3 = this.shuttleReferences(rexBuilder, e2, viewExprs, relBuilder.peek(), rewritingMapping);
            if (e3 == null) {
                return null;
            }
            rewrittenExprs.add(e3);
        }
        return relBuilder.project(rewrittenExprs).convert(topRowType, false).build();
    }

    private static <K> void addAllIndexed(Multimap<K, Integer> multimap, Iterable<? extends K> list) {
        for (K k : list) {
            multimap.put(k, multimap.size());
        }
    }

    private static int find(RelNode rel, int ref) {
        Aggregate aggregate;
        int k;
        if (rel instanceof Project) {
            Project project = (Project)rel;
            for (Ord<RexNode> p : Ord.zip(project.getProjects())) {
                if (!(p.e instanceof RexInputRef) || ((RexInputRef)p.e).getIndex() != ref) continue;
                return p.i;
            }
        }
        if (rel instanceof Aggregate && (k = (aggregate = (Aggregate)rel).getGroupSet().indexOf(ref)) >= 0) {
            return k;
        }
        return -1;
    }

    protected @Nullable Multimap<Integer, Integer> generateMapping(RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RelNode node, RelNode target, ImmutableBitSet positions, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, MaterializedViewRule.EquivalenceClasses sourceEC, List<RexNode> additionalExprs) {
        Preconditions.checkArgument(additionalExprs.isEmpty());
        ArrayListMultimap<Integer, Integer> m3 = ArrayListMultimap.create();
        Map<RexTableInputRef, Set<RexTableInputRef>> equivalenceClassesMap = sourceEC.getEquivalenceClassesMap();
        ArrayListMultimap<RexNode, Integer> exprsLineage = ArrayListMultimap.create();
        ArrayList<RexNode> timestampExprs = new ArrayList<RexNode>();
        for (int i = 0; i < target.getRowType().getFieldCount(); ++i) {
            Set<RexNode> s2 = mq.getExpressionLineage(target, rexBuilder.makeInputRef(target, i));
            if (s2 == null) continue;
            RexNode e = Iterables.getOnlyElement(s2);
            RexNode simplified = simplify.simplifyUnknownAsFalse(e);
            RexNode expr = RexUtil.swapTableColumnReferences(rexBuilder, simplified, tableMapping.inverse(), equivalenceClassesMap);
            exprsLineage.put(expr, i);
            SqlFunction[] sqlTypeName = expr.getType().getSqlTypeName();
            if (sqlTypeName != SqlTypeName.TIMESTAMP && sqlTypeName != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) continue;
            timestampExprs.add(expr);
        }
        for (RexNode timestampExpr : timestampExprs) {
            for (TimeUnitRange value : SUPPORTED_DATE_TIME_ROLLUP_UNITS) {
                SqlFunction[] functions;
                for (SqlFunction function : functions = new SqlFunction[]{this.getCeilSqlFunction(value), this.getFloorSqlFunction(value)}) {
                    RexNode call = rexBuilder.makeCall((SqlOperator)function, timestampExpr, rexBuilder.makeFlag(value));
                    RexNode rewrittenCall = this.shuttleReferences(rexBuilder, call, exprsLineage);
                    if (rewrittenCall == null) continue;
                    additionalExprs.add(rewrittenCall);
                    RexNode simplified = simplify.simplifyUnknownAsFalse(call);
                    exprsLineage.put(simplified, target.getRowType().getFieldCount() + additionalExprs.size() - 1);
                }
            }
        }
        Iterator<Object> iterator = positions.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Set<RexNode> s3 = mq.getExpressionLineage(node, rexBuilder.makeInputRef(node, i));
            if (s3 == null) {
                return null;
            }
            RexNode e = Iterables.getOnlyElement(s3);
            RexNode simplified = simplify.simplifyUnknownAsFalse(e);
            RexNode targetExpr = RexUtil.swapColumnReferences(rexBuilder, simplified, equivalenceClassesMap);
            Collection c = exprsLineage.get(targetExpr);
            if (!c.isEmpty()) {
                for (Integer j : c) {
                    m3.put(i, j);
                }
                continue;
            }
            RexNode rewrittenTargetExpr = this.shuttleReferences(rexBuilder, targetExpr, exprsLineage);
            if (rewrittenTargetExpr == null) {
                return null;
            }
            m3.put(i, target.getRowType().getFieldCount() + additionalExprs.size());
            additionalExprs.add(rewrittenTargetExpr);
        }
        return m3;
    }

    protected SqlFunction getCeilSqlFunction(TimeUnitRange flag) {
        return SqlStdOperatorTable.CEIL;
    }

    protected SqlFunction getFloorSqlFunction(TimeUnitRange flag) {
        return SqlStdOperatorTable.FLOOR;
    }

    @Deprecated
    protected @Nullable SqlAggFunction getRollup(SqlAggFunction aggregation) {
        if (aggregation == SqlStdOperatorTable.SUM || aggregation == SqlStdOperatorTable.SUM0 || aggregation instanceof SqlMinMaxAggFunction || aggregation == SqlStdOperatorTable.ANY_VALUE) {
            return aggregation;
        }
        if (aggregation == SqlStdOperatorTable.COUNT) {
            return SqlStdOperatorTable.SUM0;
        }
        return null;
    }

    @Override
    public Pair<@Nullable RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder builder, @Nullable RelNode topViewProject, RelNode viewNode, RexNode cond) {
        HepProgramBuilder pushFiltersProgram = new HepProgramBuilder();
        if (topViewProject != null) {
            pushFiltersProgram.addRuleInstance(((Config)this.config).filterProjectTransposeRule());
        }
        pushFiltersProgram.addRuleInstance(((Config)this.config).filterAggregateTransposeRule()).addRuleInstance(((Config)this.config).aggregateProjectPullUpConstantsRule()).addRuleInstance(((Config)this.config).projectMergeRule());
        HepPlanner tmpPlanner = new HepPlanner(pushFiltersProgram.build());
        RelNode topNode = builder.push(topViewProject != null ? topViewProject : viewNode).filter(cond).build();
        tmpPlanner.setRoot(topNode);
        topNode = tmpPlanner.findBestExp();
        RelNode resultTopViewProject = null;
        RelNode resultViewNode = null;
        while (topNode != null) {
            if (topNode instanceof Project) {
                if (resultTopViewProject != null) {
                    return Pair.of(topViewProject, viewNode);
                }
                resultTopViewProject = topNode;
                topNode = topNode.getInput(0);
                continue;
            }
            if (topNode instanceof Aggregate) {
                resultViewNode = topNode;
                topNode = null;
                continue;
            }
            topNode = topNode.getInput(0);
        }
        return Pair.of(resultTopViewProject, Objects.requireNonNull(resultViewNode, "resultViewNode"));
    }

    public static interface Config
    extends MaterializedViewRule.Config {
        @Value.Default
        default public RelOptRule filterProjectTransposeRule() {
            return ((FilterProjectTransposeRule.Config)CoreRules.FILTER_PROJECT_TRANSPOSE.config).withRelBuilderFactory(this.relBuilderFactory()).as(FilterProjectTransposeRule.Config.class).withOperandFor(Filter.class, filter -> !RexUtil.containsCorrelation(filter.getCondition()), Project.class, project -> true).withCopyFilter(true).withCopyProject(true).toRule();
        }

        public Config withFilterProjectTransposeRule(RelOptRule var1);

        @Value.Default
        default public RelOptRule filterAggregateTransposeRule() {
            return ((FilterAggregateTransposeRule.Config)CoreRules.FILTER_AGGREGATE_TRANSPOSE.config).withRelBuilderFactory(this.relBuilderFactory()).as(FilterAggregateTransposeRule.Config.class).withOperandFor(Filter.class, Aggregate.class).toRule();
        }

        public Config withFilterAggregateTransposeRule(RelOptRule var1);

        @Value.Default
        default public RelOptRule aggregateProjectPullUpConstantsRule() {
            return AggregateProjectPullUpConstantsRule.Config.DEFAULT.withRelBuilderFactory(this.relBuilderFactory()).withDescription("AggFilterPullUpConstants").as(AggregateProjectPullUpConstantsRule.Config.class).withOperandFor(Aggregate.class, Filter.class).toRule();
        }

        public Config withAggregateProjectPullUpConstantsRule(RelOptRule var1);

        @Value.Default
        default public RelOptRule projectMergeRule() {
            return ((ProjectMergeRule.Config)CoreRules.PROJECT_MERGE.config).withRelBuilderFactory(this.relBuilderFactory()).toRule();
        }

        public Config withProjectMergeRule(RelOptRule var1);
    }
}

