/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;

class RexCopier
extends RexShuttle {
    private final RexBuilder builder;

    RexCopier(RexBuilder builder) {
        this.builder = builder;
    }

    private RelDataType copy(RelDataType type2) {
        return this.builder.getTypeFactory().copyType(type2);
    }

    @Override
    public RexNode visitOver(RexOver over) {
        boolean[] update = null;
        return new RexOver(this.copy(over.getType()), over.getAggOperator(), this.visitList(over.getOperands(), update), this.visitWindow(over.getWindow()), over.isDistinct(), over.ignoreNulls());
    }

    @Override
    public RexNode visitCall(RexCall call) {
        boolean[] update = null;
        return this.builder.makeCall(this.copy(call.getType()), call.getOperator(), this.visitList(call.getOperands(), update));
    }

    @Override
    public RexNode visitCorrelVariable(RexCorrelVariable variable) {
        return this.builder.makeCorrel(this.copy(variable.getType()), variable.id);
    }

    @Override
    public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
        return this.builder.makeFieldAccess(fieldAccess.getReferenceExpr().accept(this), fieldAccess.getField().getIndex());
    }

    @Override
    public RexNode visitInputRef(RexInputRef inputRef) {
        return this.builder.makeInputRef(this.copy(inputRef.getType()), inputRef.getIndex());
    }

    @Override
    public RexNode visitLocalRef(RexLocalRef localRef) {
        return new RexLocalRef(localRef.getIndex(), this.copy(localRef.getType()));
    }

    @Override
    public RexNode visitLiteral(RexLiteral literal) {
        return new RexLiteral(RexLiteral.value(literal), this.copy(literal.getType()), literal.getTypeName());
    }

    @Override
    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return this.builder.makeDynamicParam(this.copy(dynamicParam.getType()), dynamicParam.getIndex());
    }

    @Override
    public RexNode visitRangeRef(RexRangeRef rangeRef) {
        return this.builder.makeRangeReference(this.copy(rangeRef.getType()), rangeRef.getOffset(), false);
    }
}

