/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexLocalRef
extends RexSlot {
    private static final List<String> NAMES = new RexSlot.SelfPopulatingList("$t", 30);

    public RexLocalRef(int index, RelDataType type2) {
        super(RexLocalRef.createName(index), index, type2);
        assert (type2 != null);
        assert (index >= 0);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LOCAL_REF;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof RexLocalRef && Objects.equals(this.type, ((RexLocalRef)obj).type) && this.index == ((RexLocalRef)obj).index;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.index);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitLocalRef(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitLocalRef(this, arg);
    }

    private static String createName(int index) {
        return NAMES.get(index);
    }
}

