/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.Symbolizable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class SqlExplain
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("EXPLAIN", SqlKind.EXPLAIN){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlExplain(pos, operands[0], (SqlLiteral)operands[1], (SqlLiteral)operands[2], (SqlLiteral)operands[3], 0);
        }
    };
    SqlNode explicandum;
    SqlLiteral detailLevel;
    SqlLiteral depth;
    SqlLiteral format;
    private final int dynamicParameterCount;

    public SqlExplain(SqlParserPos pos, SqlNode explicandum, SqlLiteral detailLevel, SqlLiteral depth, SqlLiteral format2, int dynamicParameterCount) {
        super(pos);
        this.explicandum = explicandum;
        this.detailLevel = detailLevel;
        this.depth = depth;
        this.format = format2;
        this.dynamicParameterCount = dynamicParameterCount;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.EXPLAIN;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.explicandum, this.detailLevel, this.depth, this.format);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.explicandum = operand;
                break;
            }
            case 1: {
                this.detailLevel = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.depth = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.format = (SqlLiteral)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Pure
    public SqlNode getExplicandum() {
        return this.explicandum;
    }

    @Pure
    public SqlExplainLevel getDetailLevel() {
        return this.detailLevel.getValueAs(SqlExplainLevel.class);
    }

    @Pure
    public Depth getDepth() {
        return this.depth.getValueAs(Depth.class);
    }

    @Pure
    public int getDynamicParamCount() {
        return this.dynamicParameterCount;
    }

    @Pure
    public boolean withImplementation() {
        return this.getDepth() == Depth.PHYSICAL;
    }

    @Pure
    public boolean withType() {
        return this.getDepth() == Depth.TYPE;
    }

    @Pure
    public SqlExplainFormat getFormat() {
        return this.format.getValueAs(SqlExplainFormat.class);
    }

    @Deprecated
    public boolean isXml() {
        return this.getFormat() == SqlExplainFormat.XML;
    }

    public boolean isJson() {
        return this.getFormat() == SqlExplainFormat.JSON;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("EXPLAIN PLAN");
        switch (this.getDetailLevel()) {
            case NO_ATTRIBUTES: {
                writer.keyword("EXCLUDING ATTRIBUTES");
                break;
            }
            case EXPPLAN_ATTRIBUTES: {
                writer.keyword("INCLUDING ATTRIBUTES");
                break;
            }
            case ALL_ATTRIBUTES: {
                writer.keyword("INCLUDING ALL ATTRIBUTES");
                break;
            }
        }
        switch (this.getDepth()) {
            case TYPE: {
                writer.keyword("WITH TYPE");
                break;
            }
            case LOGICAL: {
                writer.keyword("WITHOUT IMPLEMENTATION");
                break;
            }
            case PHYSICAL: {
                writer.keyword("WITH IMPLEMENTATION");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (this.getFormat()) {
            case XML: {
                writer.keyword("AS XML");
                break;
            }
            case JSON: {
                writer.keyword("AS JSON");
                break;
            }
            case DOT: {
                writer.keyword("AS DOT");
                break;
            }
        }
        writer.keyword("FOR");
        writer.newlineAndIndent();
        this.explicandum.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
    }

    public static enum Depth implements Symbolizable
    {
        TYPE,
        LOGICAL,
        PHYSICAL;

    }
}

