/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlSelectOperator
extends SqlOperator {
    public static final SqlSelectOperator INSTANCE = new SqlSelectOperator();

    private SqlSelectOperator() {
        super("SELECT", SqlKind.SELECT, 2, true, ReturnTypes.SCOPE, null, null);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (functionQualifier == null);
        return new SqlSelect(pos, (SqlNodeList)operands[0], Objects.requireNonNull((SqlNodeList)operands[1], "selectList"), operands[2], operands[3], (SqlNodeList)operands[4], operands[5], (SqlNodeList)operands[6], (SqlNodeList)operands[7], operands[8], operands[9], (SqlNodeList)operands[10]);
    }

    @Deprecated
    public SqlSelect createCall(SqlNodeList keywordList, SqlNodeList selectList, SqlNode fromClause, SqlNode whereClause, SqlNodeList groupBy, SqlNode having, SqlNodeList windowDecls, SqlNodeList orderBy, SqlNode offset, SqlNode fetch, SqlNodeList hints, SqlParserPos pos) {
        return new SqlSelect(pos, keywordList, selectList, fromClause, whereClause, groupBy, having, windowDecls, orderBy, offset, fetch, hints);
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (!onlyExpressions) {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlNode where;
        SqlSelect select2 = (SqlSelect)call;
        SqlWriter.Frame selectFrame = writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("SELECT");
        if (select2.hasHints()) {
            writer.sep("/*+");
            Nullness.castNonNull(select2.hints).unparse(writer, 0, 0);
            writer.print("*/");
            writer.newlineAndIndent();
        }
        for (int i = 0; i < select2.keywordList.size(); ++i) {
            SqlNode keyword = select2.keywordList.get(i);
            keyword.unparse(writer, 0, 0);
        }
        writer.topN(select2.fetch, select2.offset);
        SqlNodeList selectClause = select2.selectList;
        writer.list(SqlWriter.FrameTypeEnum.SELECT_LIST, SqlWriter.COMMA, selectClause);
        if (select2.from != null) {
            writer.sep("FROM");
            SqlWriter.Frame fromFrame = writer.startList(SqlWriter.FrameTypeEnum.FROM_LIST);
            select2.from.unparse(writer, SqlJoin.OPERATOR.getLeftPrec() - 1, SqlJoin.OPERATOR.getRightPrec() - 1);
            writer.endList(fromFrame);
        }
        if ((where = select2.where) != null) {
            writer.sep("WHERE");
            if (!writer.isAlwaysUseParentheses()) {
                SqlNode node = where;
                SqlBinaryOperator whereSep = SqlStdOperatorTable.AND;
                if (node instanceof SqlCall && node.getKind() == SqlKind.OR) {
                    whereSep = SqlStdOperatorTable.OR;
                }
                ArrayList<Object> list = new ArrayList<Object>(0);
                while (node.getKind() == whereSep.kind) {
                    assert (node instanceof SqlCall);
                    SqlCall call1 = (SqlCall)node;
                    list.add(0, call1.operand(1));
                    node = call1.operand(0);
                }
                list.add(0, node);
                writer.list(SqlWriter.FrameTypeEnum.WHERE_LIST, whereSep, new SqlNodeList(list, where.getParserPosition()));
            } else {
                where.unparse(writer, 0, 0);
            }
        }
        if (select2.groupBy != null) {
            writer.sep("GROUP BY");
            SqlNodeList groupBy = select2.groupBy.size() == 0 ? SqlNodeList.SINGLETON_EMPTY : select2.groupBy;
            writer.list(SqlWriter.FrameTypeEnum.GROUP_BY_LIST, SqlWriter.COMMA, groupBy);
        }
        if (select2.having != null) {
            writer.sep("HAVING");
            select2.having.unparse(writer, 0, 0);
        }
        if (select2.windowDecls.size() > 0) {
            writer.sep("WINDOW");
            writer.list(SqlWriter.FrameTypeEnum.WINDOW_DECL_LIST, SqlWriter.COMMA, select2.windowDecls);
        }
        if (select2.orderBy != null && select2.orderBy.size() > 0) {
            writer.sep("ORDER BY");
            writer.list(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, SqlWriter.COMMA, select2.orderBy);
        }
        writer.fetchOffset(select2.fetch, select2.offset);
        writer.endList(selectFrame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal == 3;
    }
}

