/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlTableRef
extends SqlCall {
    private final SqlIdentifier tableName;
    private final SqlNodeList hints;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("TABLE_REF", SqlKind.TABLE_REF){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlTableRef(pos, (SqlIdentifier)Objects.requireNonNull(operands[0], "tableName"), (SqlNodeList)Objects.requireNonNull(operands[1], "hints"));
        }
    };

    public SqlTableRef(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList hints) {
        super(pos);
        this.tableName = tableName;
        this.hints = hints;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.tableName, this.hints);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.tableName.unparse(writer, leftPrec, rightPrec);
        if (this.hints != null && this.hints.size() > 0) {
            writer.getDialect().unparseTableScanHints(writer, this.hints, leftPrec, rightPrec);
        }
    }
}

