/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.LibraryOperator;
import org.apache.calcite.sql.fun.SqlBasicAggFunction;
import org.apache.calcite.sql.fun.SqlCastOperator;
import org.apache.calcite.sql.fun.SqlJsonDepthFunction;
import org.apache.calcite.sql.fun.SqlJsonKeysFunction;
import org.apache.calcite.sql.fun.SqlJsonLengthFunction;
import org.apache.calcite.sql.fun.SqlJsonPrettyFunction;
import org.apache.calcite.sql.fun.SqlJsonRemoveFunction;
import org.apache.calcite.sql.fun.SqlJsonStorageSizeFunction;
import org.apache.calcite.sql.fun.SqlJsonTypeFunction;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlRegexpReplaceFunction;
import org.apache.calcite.sql.fun.SqlTranslate3Function;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Optionality;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlLibraryOperators {
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction CONVERT_TIMEZONE = new SqlFunction("CONVERT_TIMEZONE", SqlKind.OTHER_FUNCTION, ReturnTypes.DATE_NULLABLE, null, OperandTypes.CHARACTER_CHARACTER_DATETIME, SqlFunctionCategory.TIMEDATE);
    private static final SqlReturnTypeInference DECODE_RETURN_TYPE = opBinding -> {
        ArrayList<RelDataType> list = new ArrayList<RelDataType>();
        int n = opBinding.getOperandCount();
        for (int i = 1; i < n; ++i) {
            if (i < n - 1) {
                ++i;
            }
            list.add(opBinding.getOperandType(i));
        }
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type2 = typeFactory.leastRestrictive(list);
        if (type2 != null && opBinding.getOperandCount() % 2 == 1) {
            type2 = typeFactory.createTypeWithNullability(type2, true);
        }
        return type2;
    };
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction DECODE = new SqlFunction("DECODE", SqlKind.DECODE, DECODE_RETURN_TYPE, null, OperandTypes.VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.HIVE, SqlLibrary.SPARK})
    public static final SqlFunction IF = new SqlFunction("IF", SqlKind.IF, SqlLibraryOperators::inferIfReturnType, null, OperandTypes.and(OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.ANY, SqlTypeFamily.ANY), new SameOperandTypeChecker(3){

        @Override
        protected List<Integer> getOperandList(int operandCount) {
            return ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2));
        }
    }), SqlFunctionCategory.SYSTEM){

        @Override
        public boolean validRexOperands(int count, Litmus litmus) {
            return litmus.fail("not a rex operator", new Object[0]);
        }
    };
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction NVL = new SqlFunction("NVL", SqlKind.NVL, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE_ALL), null, OperandTypes.SAME_SAME, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction LTRIM = new SqlFunction("LTRIM", SqlKind.LTRIM, ReturnTypes.ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction RTRIM = new SqlFunction("RTRIM", SqlKind.RTRIM, ReturnTypes.ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SUBSTR_BIG_QUERY = new SqlFunction("SUBSTR", SqlKind.SUBSTR_BIG_QUERY, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.STRING_INTEGER_OPTIONAL_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction SUBSTR_MYSQL = new SqlFunction("SUBSTR", SqlKind.SUBSTR_MYSQL, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.STRING_INTEGER_OPTIONAL_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction SUBSTR_ORACLE = new SqlFunction("SUBSTR", SqlKind.SUBSTR_ORACLE, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.STRING_INTEGER_OPTIONAL_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction SUBSTR_POSTGRESQL = new SqlFunction("SUBSTR", SqlKind.SUBSTR_POSTGRESQL, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.STRING_INTEGER_OPTIONAL_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction GREATEST = new SqlFunction("GREATEST", SqlKind.GREATEST, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction LEAST = new SqlFunction("LEAST", SqlKind.LEAST, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE, SqlLibrary.POSTGRESQL})
    public static final SqlFunction TRANSLATE3 = new SqlTranslate3Function();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_TYPE = new SqlJsonTypeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_DEPTH = new SqlJsonDepthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_LENGTH = new SqlJsonLengthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_KEYS = new SqlJsonKeysFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_PRETTY = new SqlJsonPrettyFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_REMOVE = new SqlJsonRemoveFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_STORAGE_SIZE = new SqlJsonStorageSizeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.ORACLE})
    public static final SqlFunction REGEXP_REPLACE = new SqlRegexpReplaceFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction COMPRESS = new SqlFunction("COMPRESS", SqlKind.OTHER_FUNCTION, ReturnTypes.explicit(SqlTypeName.VARBINARY).andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction EXTRACT_VALUE = new SqlFunction("EXTRACTVALUE", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.STRING_STRING, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction XML_TRANSFORM = new SqlFunction("XMLTRANSFORM", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.STRING_STRING, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction EXTRACT_XML = new SqlFunction("EXTRACT", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction EXISTS_NODE = new SqlFunction("EXISTSNODE", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE.andThen(SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlAggFunction BOOL_AND = new SqlMinMaxAggFunction("BOOL_AND", SqlKind.MIN, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlAggFunction BOOL_OR = new SqlMinMaxAggFunction("BOOL_OR", SqlKind.MAX, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction LOGICAL_AND = new SqlMinMaxAggFunction("LOGICAL_AND", SqlKind.MIN, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction LOGICAL_OR = new SqlMinMaxAggFunction("LOGICAL_OR", SqlKind.MAX, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction COUNTIF = SqlBasicAggFunction.create(SqlKind.COUNTIF, ReturnTypes.BIGINT, OperandTypes.BOOLEAN).withDistinct(Optionality.FORBIDDEN);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction ARRAY_AGG = SqlBasicAggFunction.create(SqlKind.ARRAY_AGG, ReturnTypes.andThen(ReturnTypes::stripOrderBy, ReturnTypes.TO_ARRAY), OperandTypes.ANY).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION).withAllowsNullTreatment(true);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction ARRAY_CONCAT_AGG = SqlBasicAggFunction.create(SqlKind.ARRAY_CONCAT_AGG, ReturnTypes.ARG0, OperandTypes.ARRAY).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction STRING_AGG = SqlBasicAggFunction.create(SqlKind.STRING_AGG, ReturnTypes.ARG0_NULLABLE, OperandTypes.or(OperandTypes.STRING, OperandTypes.STRING_STRING)).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlAggFunction GROUP_CONCAT = SqlBasicAggFunction.create(SqlKind.GROUP_CONCAT, ReturnTypes.andThen(ReturnTypes::stripOrderBy, ReturnTypes.ARG0_NULLABLE), OperandTypes.or(OperandTypes.STRING, OperandTypes.STRING_STRING)).withFunctionType(SqlFunctionCategory.SYSTEM).withAllowsNullTreatment(false).withAllowsSeparator(true).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE = new SqlFunction("DATE", SqlKind.OTHER_FUNCTION, ReturnTypes.DATE_NULLABLE, null, OperandTypes.STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction CURRENT_DATETIME = new SqlFunction("CURRENT_DATETIME", SqlKind.OTHER_FUNCTION, ReturnTypes.TIMESTAMP.andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.or(OperandTypes.NILADIC, OperandTypes.STRING), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_FROM_UNIX_DATE = new SqlFunction("DATE_FROM_UNIX_DATE", SqlKind.OTHER_FUNCTION, ReturnTypes.DATE_NULLABLE, null, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction UNIX_DATE = new SqlFunction("UNIX_DATE", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.DATE, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction MONTHNAME = new SqlFunction("MONTHNAME", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, null, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction DAYNAME = new SqlFunction("DAYNAME", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, null, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction LEFT = new SqlFunction("LEFT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction REPEAT = new SqlFunction("REPEAT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.STRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction RIGHT = new SqlFunction("RIGHT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction SPACE = new SqlFunction("SPACE", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction STRCMP = new SqlFunction("STRCMP", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction SOUNDEX = new SqlFunction("SOUNDEX", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_4_NULLABLE, null, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction DIFFERENCE = new SqlFunction("DIFFERENCE", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlSpecialOperator ILIKE = new SqlLikeOperator("ILIKE", SqlKind.LIKE, false, false);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlSpecialOperator NOT_ILIKE = new SqlLikeOperator("NOT ILIKE", SqlKind.LIKE, true, false);
    @LibraryOperator(libraries={SqlLibrary.SPARK, SqlLibrary.HIVE})
    public static final SqlSpecialOperator RLIKE = new SqlLikeOperator("RLIKE", SqlKind.RLIKE, false, true);
    @LibraryOperator(libraries={SqlLibrary.SPARK, SqlLibrary.HIVE})
    public static final SqlSpecialOperator NOT_RLIKE = new SqlLikeOperator("NOT RLIKE", SqlKind.RLIKE, true, true);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction CONCAT_FUNCTION = new SqlFunction("CONCAT", SqlKind.OTHER_FUNCTION, ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE, InferTypes.RETURN_TYPE, OperandTypes.repeat(SqlOperandCountRanges.from(2), OperandTypes.STRING), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction CONCAT2 = new SqlFunction("CONCAT", SqlKind.CONCAT2, ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE, InferTypes.RETURN_TYPE, OperandTypes.STRING_SAME_SAME, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_LENGTH = new SqlFunction("ARRAY_LENGTH", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_REVERSE = new SqlFunction("ARRAY_REVERSE", SqlKind.ARRAY_REVERSE, ReturnTypes.ARG0_NULLABLE, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_CONCAT = new SqlFunction("ARRAY_CONCAT", SqlKind.ARRAY_CONCAT, ReturnTypes.LEAST_RESTRICTIVE, null, OperandTypes.AT_LEAST_ONE_SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction REVERSE = new SqlFunction("REVERSE", SqlKind.REVERSE, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction FROM_BASE64 = new SqlFunction("FROM_BASE64", SqlKind.OTHER_FUNCTION, ReturnTypes.explicit(SqlTypeName.VARBINARY).andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction TO_BASE64 = new SqlFunction("TO_BASE64", SqlKind.OTHER_FUNCTION, ReturnTypes.explicit(SqlTypeName.VARCHAR).andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.or(OperandTypes.STRING, OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction TO_DATE = new SqlFunction("TO_DATE", SqlKind.OTHER_FUNCTION, ReturnTypes.DATE_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction TO_TIMESTAMP = new SqlFunction("TO_TIMESTAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.DATE_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_SECONDS = new SqlFunction("TIMESTAMP_SECONDS", SqlKind.OTHER_FUNCTION, ReturnTypes.TIMESTAMP_NULLABLE, null, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_MILLIS = new SqlFunction("TIMESTAMP_MILLIS", SqlKind.OTHER_FUNCTION, ReturnTypes.TIMESTAMP_NULLABLE, null, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_MICROS = new SqlFunction("TIMESTAMP_MICROS", SqlKind.OTHER_FUNCTION, ReturnTypes.TIMESTAMP_NULLABLE, null, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction UNIX_SECONDS = new SqlFunction("UNIX_SECONDS", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT_NULLABLE, null, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction UNIX_MILLIS = new SqlFunction("UNIX_MILLIS", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT_NULLABLE, null, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction UNIX_MICROS = new SqlFunction("UNIX_MICROS", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT_NULLABLE, null, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction CHR = new SqlFunction("CHR", SqlKind.OTHER_FUNCTION, ReturnTypes.CHAR, null, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction TANH = new SqlFunction("TANH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction COSH = new SqlFunction("COSH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction SINH = new SqlFunction("SINH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction MD5 = new SqlFunction("MD5", SqlKind.OTHER_FUNCTION, ReturnTypes.explicit(SqlTypeName.VARCHAR).andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.or(OperandTypes.STRING, OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction SHA1 = new SqlFunction("SHA1", SqlKind.OTHER_FUNCTION, ReturnTypes.explicit(SqlTypeName.VARCHAR).andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.or(OperandTypes.STRING, OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlOperator INFIX_CAST = new SqlCastOperator();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlOperator NULL_SAFE_EQUAL = new SqlBinaryOperator("<=>", SqlKind.IS_NOT_DISTINCT_FROM, 30, true, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED);

    private SqlLibraryOperators() {
    }

    private static @Nullable RelDataType inferIfReturnType(SqlOperatorBinding opBinding) {
        return opBinding.getTypeFactory().leastRestrictive(opBinding.collectOperandTypes().subList(1, 3));
    }
}

