/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.ImplicitCastOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CompositeOperandTypeChecker
implements SqlOperandTypeChecker {
    private final @Nullable SqlOperandCountRange range;
    protected final ImmutableList<@UnknownKeyFor ? extends SqlOperandTypeChecker> allowedRules;
    protected final Composition composition;
    private final @Nullable String allowedSignatures;

    CompositeOperandTypeChecker(Composition composition, ImmutableList<? extends SqlOperandTypeChecker> allowedRules, @Nullable String allowedSignatures, @Nullable SqlOperandCountRange range) {
        this.allowedRules = Objects.requireNonNull(allowedRules, "allowedRules");
        this.composition = Objects.requireNonNull(composition, "composition");
        this.allowedSignatures = allowedSignatures;
        this.range = range;
        assert (range != null == (composition == Composition.REPEAT));
        assert (allowedRules.size() + (range == null ? 0 : 1) > 1);
    }

    @Override
    public boolean isOptional(int i) {
        for (SqlOperandTypeChecker sqlOperandTypeChecker : this.allowedRules) {
            if (!sqlOperandTypeChecker.isOptional(i)) continue;
            return true;
        }
        return false;
    }

    public ImmutableList<? extends SqlOperandTypeChecker> getRules() {
        return this.allowedRules;
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        if (this.allowedSignatures != null) {
            return this.allowedSignatures;
        }
        if (this.composition == Composition.SEQUENCE) {
            throw new AssertionError((Object)"specify allowedSignatures or override getAllowedSignatures");
        }
        StringBuilder ret = new StringBuilder();
        for (Ord<? extends SqlOperandTypeChecker> ord : Ord.zip(this.allowedRules)) {
            if (ord.i > 0) {
                ret.append(SqlOperator.NL);
            }
            ret.append(((SqlOperandTypeChecker)ord.e).getAllowedSignatures(op, opName));
            if (this.composition != Composition.AND) continue;
            break;
        }
        return ret.toString();
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        switch (this.composition) {
            case REPEAT: {
                return Objects.requireNonNull(this.range, "range");
            }
            case SEQUENCE: {
                return SqlOperandCountRanges.of(this.allowedRules.size());
            }
        }
        final AbstractList<SqlOperandCountRange> ranges = new AbstractList<SqlOperandCountRange>(){

            @Override
            public SqlOperandCountRange get(int index) {
                return ((SqlOperandTypeChecker)CompositeOperandTypeChecker.this.allowedRules.get(index)).getOperandCountRange();
            }

            @Override
            public int size() {
                return CompositeOperandTypeChecker.this.allowedRules.size();
            }
        };
        final int min2 = CompositeOperandTypeChecker.minMin((List<SqlOperandCountRange>)ranges);
        final int max2 = this.maxMax((List<SqlOperandCountRange>)ranges);
        SqlOperandCountRange composite = new SqlOperandCountRange(){

            @Override
            public boolean isValidCount(int count) {
                switch (CompositeOperandTypeChecker.this.composition) {
                    case AND: {
                        for (SqlOperandCountRange range : ranges) {
                            if (range.isValidCount(count)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                for (SqlOperandCountRange range : ranges) {
                    if (!range.isValidCount(count)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int getMin() {
                return min2;
            }

            @Override
            public int getMax() {
                return max2;
            }
        };
        if (max2 >= 0) {
            for (int i = min2; i <= max2; ++i) {
                if (composite.isValidCount(i)) continue;
                return composite;
            }
        }
        return min2 == max2 ? SqlOperandCountRanges.of(min2) : SqlOperandCountRanges.between(min2, max2);
    }

    private static int minMin(List<SqlOperandCountRange> ranges) {
        int min2 = Integer.MAX_VALUE;
        for (SqlOperandCountRange range : ranges) {
            min2 = Math.min(min2, range.getMin());
        }
        return min2;
    }

    private int maxMax(List<SqlOperandCountRange> ranges) {
        int max2 = Integer.MIN_VALUE;
        for (SqlOperandCountRange range : ranges) {
            if (range.getMax() < 0) {
                if (this.composition != Composition.OR) continue;
                return -1;
            }
            max2 = Math.max(max2, range.getMax());
        }
        return max2;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (callBinding.isTypeCoercionEnabled()) {
            TypeCoercion typeCoercion = callBinding.getValidator().getTypeCoercion();
            typeCoercion.binaryArithmeticCoercion(callBinding);
        }
        if (this.check(callBinding)) {
            return true;
        }
        if (!throwOnFailure) {
            return false;
        }
        if (this.composition == Composition.OR) {
            for (SqlOperandTypeChecker sqlOperandTypeChecker : this.allowedRules) {
                sqlOperandTypeChecker.checkOperandTypes(callBinding, true);
            }
        }
        throw callBinding.newValidationSignatureError();
    }

    private boolean check(SqlCallBinding callBinding) {
        switch (this.composition) {
            case REPEAT: {
                if (!Objects.requireNonNull(this.range, "range").isValidCount(callBinding.getOperandCount())) {
                    return false;
                }
                for (int operand : Util.range(callBinding.getOperandCount())) {
                    for (SqlOperandTypeChecker sqlOperandTypeChecker : this.allowedRules) {
                        if (((SqlSingleOperandTypeChecker)sqlOperandTypeChecker).checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(operand), 0, false)) continue;
                        if (callBinding.isTypeCoercionEnabled()) {
                            return this.coerceOperands(callBinding, true);
                        }
                        return false;
                    }
                }
                return true;
            }
            case SEQUENCE: {
                if (callBinding.getOperandCount() != this.allowedRules.size()) {
                    return false;
                }
                for (Ord<? extends SqlOperandTypeChecker> ord : Ord.zip(this.allowedRules)) {
                    SqlOperandTypeChecker rule = (SqlOperandTypeChecker)ord.e;
                    if (((SqlSingleOperandTypeChecker)rule).checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(ord.i), 0, false)) continue;
                    if (callBinding.isTypeCoercionEnabled()) {
                        return this.coerceOperands(callBinding, false);
                    }
                    return false;
                }
                return true;
            }
            case AND: {
                for (Ord<? extends SqlOperandTypeChecker> ord : Ord.zip(this.allowedRules)) {
                    SqlOperandTypeChecker rule = (SqlOperandTypeChecker)ord.e;
                    if (rule.checkOperandTypes(callBinding, false)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                if (this.checkWithoutTypeCoercion(callBinding)) {
                    return true;
                }
                for (Ord<? extends SqlOperandTypeChecker> ord : Ord.zip(this.allowedRules)) {
                    SqlOperandTypeChecker rule = (SqlOperandTypeChecker)ord.e;
                    if (!rule.checkOperandTypes(callBinding, false)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new AssertionError();
    }

    private boolean coerceOperands(SqlCallBinding callBinding, boolean repeat) {
        List<SqlTypeFamily> families = this.allowedRules.stream().filter(r -> r instanceof ImplicitCastOperandTypeChecker).map(r -> ((ImplicitCastOperandTypeChecker)((Object)r)).getOperandSqlTypeFamily(0)).collect(Collectors.toList());
        if (families.size() < this.allowedRules.size()) {
            return false;
        }
        if (repeat) {
            assert (families.size() == 1);
            families = Collections.nCopies(callBinding.getOperandCount(), families.get(0));
        }
        ArrayList<RelDataType> operandTypes = new ArrayList<RelDataType>();
        for (int i = 0; i < callBinding.getOperandCount(); ++i) {
            operandTypes.add(callBinding.getOperandType(i));
        }
        TypeCoercion typeCoercion = callBinding.getValidator().getTypeCoercion();
        return typeCoercion.builtinFunctionCoercion(callBinding, operandTypes, families);
    }

    private boolean checkWithoutTypeCoercion(SqlCallBinding callBinding) {
        if (!callBinding.isTypeCoercionEnabled()) {
            return false;
        }
        for (SqlOperandTypeChecker sqlOperandTypeChecker : this.allowedRules) {
            ImplicitCastOperandTypeChecker rule1;
            if (!(sqlOperandTypeChecker instanceof ImplicitCastOperandTypeChecker) || !(rule1 = (ImplicitCastOperandTypeChecker)((Object)sqlOperandTypeChecker)).checkOperandTypesWithoutTypeCoercion(callBinding, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable SqlOperandTypeInference typeInference() {
        SqlOperandTypeChecker checker;
        if (this.composition == Composition.REPEAT && (checker = Iterables.getOnlyElement(this.allowedRules)) instanceof SqlOperandTypeInference) {
            SqlOperandTypeInference rule = (SqlOperandTypeInference)((Object)checker);
            return (callBinding, returnType, operandTypes) -> {
                for (int i = 0; i < callBinding.getOperandCount(); ++i) {
                    RelDataType[] operandTypes0 = new RelDataType[1];
                    rule.inferOperandTypes(callBinding, returnType, operandTypes0);
                    operandTypes[i] = operandTypes0[0];
                }
            };
        }
        return null;
    }

    public static enum Composition {
        AND,
        OR,
        SEQUENCE,
        REPEAT;

    }
}

