/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class ExplicitOperandTypeChecker
implements SqlOperandTypeChecker {
    private final RelDataType type;

    public ExplicitOperandTypeChecker(RelDataType type2) {
        this.type = Objects.requireNonNull(type2, "type");
    }

    @Override
    public boolean isOptional(int i) {
        return false;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
        List<RelDataTypeField> fieldList = this.type.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            RelDataTypeField field = fieldList.get(i);
            SqlTypeName sqlTypeName = field.getType().getSqlTypeName();
            if (sqlTypeName == SqlTypeName.ROW) {
                if (!field.getType().equals(callBinding.getOperandType(i))) continue;
                families.add(SqlTypeFamily.ANY);
                continue;
            }
            families.add(Objects.requireNonNull(sqlTypeName.getFamily(), () -> "keyType.getSqlTypeName().getFamily() null, type is " + (Object)((Object)sqlTypeName)));
        }
        return OperandTypes.family(families).checkOperandTypes(callBinding, throwOnFailure);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(this.type.getFieldCount());
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<TYPE> " + opName + " <TYPE>";
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

