/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.ObjectSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlTypeFactoryImpl
extends RelDataTypeFactoryImpl {
    public SqlTypeFactoryImpl(RelDataTypeSystem typeSystem) {
        super(typeSystem);
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName) {
        if (typeName.allowsPrec()) {
            return this.createSqlType(typeName, this.typeSystem.getDefaultPrecision(typeName));
        }
        SqlTypeFactoryImpl.assertBasic(typeName);
        BasicSqlType newType = new BasicSqlType(this.typeSystem, typeName);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName, int precision) {
        int maxPrecision = this.typeSystem.getMaxPrecision(typeName);
        if (maxPrecision >= 0 && precision > maxPrecision) {
            precision = maxPrecision;
        }
        if (typeName.allowsScale()) {
            return this.createSqlType(typeName, precision, typeName.getDefaultScale());
        }
        SqlTypeFactoryImpl.assertBasic(typeName);
        assert (precision >= 0 || precision == -1);
        RelDataType newType = precision == -1 ? new BasicSqlType(this.typeSystem, typeName) : new BasicSqlType(this.typeSystem, typeName, precision);
        newType = SqlTypeUtil.addCharsetAndCollation(newType, this);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName, int precision, int scale) {
        SqlTypeFactoryImpl.assertBasic(typeName);
        assert (precision >= 0 || precision == -1);
        int maxPrecision = this.typeSystem.getMaxPrecision(typeName);
        if (maxPrecision >= 0 && precision > maxPrecision) {
            precision = maxPrecision;
        }
        RelDataType newType = new BasicSqlType(this.typeSystem, typeName, precision, scale);
        newType = SqlTypeUtil.addCharsetAndCollation(newType, this);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createUnknownType() {
        return this.createSqlType(SqlTypeName.UNKNOWN);
    }

    @Override
    public RelDataType createMultisetType(RelDataType type2, long maxCardinality) {
        assert (maxCardinality == -1L);
        MultisetSqlType newType = new MultisetSqlType(type2, false);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createArrayType(RelDataType elementType, long maxCardinality) {
        assert (maxCardinality == -1L);
        ArraySqlType newType = new ArraySqlType(elementType, false);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createMapType(RelDataType keyType, RelDataType valueType) {
        MapSqlType newType = new MapSqlType(keyType, valueType, false);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createSqlIntervalType(SqlIntervalQualifier intervalQualifier) {
        IntervalSqlType newType = new IntervalSqlType(this.typeSystem, intervalQualifier, false);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createTypeWithCharsetAndCollation(RelDataType type2, Charset charset, SqlCollation collation) {
        RelDataTypeImpl newType;
        assert (SqlTypeUtil.inCharFamily(type2)) : type2;
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(collation, "collation");
        if (type2 instanceof BasicSqlType) {
            BasicSqlType sqlType = (BasicSqlType)type2;
            newType = sqlType.createWithCharsetAndCollation(charset, collation);
        } else if (type2 instanceof RelDataTypeFactoryImpl.JavaType) {
            RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type2;
            newType = new RelDataTypeFactoryImpl.JavaType(javaType.getJavaClass(), javaType.isNullable(), charset, collation);
        } else {
            throw Util.needToImplement("need to implement " + type2);
        }
        return this.canonize(newType);
    }

    @Override
    public @Nullable RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (types.size() >= 1);
        RelDataType type0 = types.get(0);
        if (type0.getSqlTypeName() != null) {
            RelDataType resultType = this.leastRestrictiveSqlType(types);
            if (resultType != null) {
                return resultType;
            }
            return this.leastRestrictiveByCast(types);
        }
        return super.leastRestrictive(types);
    }

    private @Nullable RelDataType leastRestrictiveByCast(List<RelDataType> types) {
        RelDataType resultType = types.get(0);
        boolean anyNullable = resultType.isNullable();
        for (int i = 1; i < types.size(); ++i) {
            RelDataType type2 = types.get(i);
            if (type2.getSqlTypeName() == SqlTypeName.NULL) {
                anyNullable = true;
                continue;
            }
            if (type2.isNullable()) {
                anyNullable = true;
            }
            if (SqlTypeUtil.canCastFrom(type2, resultType, false)) {
                resultType = type2;
                continue;
            }
            if (SqlTypeUtil.canCastFrom(resultType, type2, false)) continue;
            return null;
        }
        if (anyNullable) {
            return this.createTypeWithNullability(resultType, true);
        }
        return resultType;
    }

    @Override
    public RelDataType createTypeWithNullability(RelDataType type2, boolean nullable) {
        RelDataType newType;
        if (type2 instanceof BasicSqlType) {
            newType = ((BasicSqlType)type2).createWithNullability(nullable);
        } else if (type2 instanceof MapSqlType) {
            newType = this.copyMapType(type2, nullable);
        } else if (type2 instanceof ArraySqlType) {
            newType = this.copyArrayType(type2, nullable);
        } else if (type2 instanceof MultisetSqlType) {
            newType = this.copyMultisetType(type2, nullable);
        } else if (type2 instanceof IntervalSqlType) {
            newType = this.copyIntervalType(type2, nullable);
        } else if (type2 instanceof ObjectSqlType) {
            newType = SqlTypeFactoryImpl.copyObjectType(type2, nullable);
        } else {
            return super.createTypeWithNullability(type2, nullable);
        }
        return this.canonize(newType);
    }

    private static void assertBasic(SqlTypeName typeName) {
        assert (typeName != null);
        assert (typeName != SqlTypeName.MULTISET) : "use createMultisetType() instead";
        assert (typeName != SqlTypeName.ARRAY) : "use createArrayType() instead";
        assert (typeName != SqlTypeName.MAP) : "use createMapType() instead";
        assert (typeName != SqlTypeName.ROW) : "use createStructType() instead";
        assert (!SqlTypeName.INTERVAL_TYPES.contains((Object)typeName)) : "use createSqlIntervalType() instead";
    }

    private @Nullable RelDataType leastRestrictiveSqlType(List<RelDataType> types) {
        RelDataType resultType = null;
        int nullCount = 0;
        int nullableCount = 0;
        int javaCount = 0;
        int anyCount = 0;
        for (RelDataType type2 : types) {
            SqlTypeName typeName = type2.getSqlTypeName();
            if (typeName == null) {
                return null;
            }
            if (typeName == SqlTypeName.ANY) {
                ++anyCount;
            }
            if (type2.isNullable()) {
                ++nullableCount;
            }
            if (typeName == SqlTypeName.NULL) {
                ++nullCount;
            }
            if (!SqlTypeFactoryImpl.isJavaType(type2)) continue;
            ++javaCount;
        }
        if (anyCount > 0) {
            return this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), nullCount > 0 || nullableCount > 0);
        }
        for (int i = 0; i < types.size(); ++i) {
            RelDataType type2;
            type2 = types.get(i);
            RelDataTypeFamily family = type2.getFamily();
            SqlTypeName typeName = type2.getSqlTypeName();
            if (typeName == SqlTypeName.NULL) continue;
            if (SqlTypeFactoryImpl.isJavaType(type2) && javaCount + nullCount < types.size()) {
                RelDataType originalType = type2;
                type2 = typeName.allowsPrecScale(true, true) ? this.createSqlType(typeName, type2.getPrecision(), type2.getScale()) : (typeName.allowsPrecScale(true, false) ? this.createSqlType(typeName, type2.getPrecision()) : this.createSqlType(typeName));
                type2 = this.createTypeWithNullability(type2, originalType.isNullable());
            }
            if (resultType == null) {
                resultType = type2;
                SqlTypeName sqlTypeName = resultType.getSqlTypeName();
                if (sqlTypeName == SqlTypeName.ROW) {
                    return this.leastRestrictiveStructuredType(types);
                }
                if (sqlTypeName == SqlTypeName.ARRAY || sqlTypeName == SqlTypeName.MULTISET) {
                    return this.leastRestrictiveArrayMultisetType(types, sqlTypeName);
                }
                if (sqlTypeName == SqlTypeName.MAP) {
                    return this.leastRestrictiveMapType(types, sqlTypeName);
                }
            }
            RelDataTypeFamily resultFamily = resultType.getFamily();
            SqlTypeName resultTypeName = resultType.getSqlTypeName();
            if (resultFamily != family) {
                return null;
            }
            if (SqlTypeUtil.inCharOrBinaryFamilies(type2)) {
                Charset charset1 = type2.getCharset();
                Charset charset2 = resultType.getCharset();
                SqlCollation collation1 = type2.getCollation();
                SqlCollation collation2 = resultType.getCollation();
                int precision = SqlTypeUtil.maxPrecision(resultType.getPrecision(), type2.getPrecision());
                if (SqlTypeUtil.isLob(resultType)) {
                    resultType = this.createSqlType(resultType.getSqlTypeName());
                } else if (SqlTypeUtil.isLob(type2)) {
                    resultType = this.createSqlType(type2.getSqlTypeName());
                } else if (SqlTypeUtil.isBoundedVariableWidth(resultType)) {
                    resultType = this.createSqlType(resultType.getSqlTypeName(), precision);
                } else {
                    SqlTypeName newTypeName = type2.getSqlTypeName();
                    if (this.typeSystem.shouldConvertRaggedUnionTypesToVarying() && resultType.getPrecision() != type2.getPrecision()) {
                        if (newTypeName == SqlTypeName.CHAR) {
                            newTypeName = SqlTypeName.VARCHAR;
                        } else if (newTypeName == SqlTypeName.BINARY) {
                            newTypeName = SqlTypeName.VARBINARY;
                        }
                    }
                    resultType = this.createSqlType(newTypeName, precision);
                }
                Charset charset = null;
                SqlCollation collation0 = collation1 != null && collation2 != null ? SqlCollation.getCoercibilityDyadicOperator(collation1, collation2) : null;
                SqlCollation collation = null;
                if (charset1 != null || charset2 != null) {
                    if (charset1 == null) {
                        charset = charset2;
                        collation = collation2;
                    } else if (charset2 == null) {
                        charset = charset1;
                        collation = collation1;
                    } else if (charset1.equals(charset2)) {
                        charset = charset1;
                        collation = collation1;
                    } else if (charset1.contains(charset2)) {
                        charset = charset1;
                        collation = collation1;
                    } else {
                        charset = charset2;
                        collation = collation2;
                    }
                }
                if (charset == null) continue;
                resultType = this.createTypeWithCharsetAndCollation(resultType, charset, collation0 != null ? collation0 : Objects.requireNonNull(collation, "collation"));
                continue;
            }
            if (SqlTypeUtil.isExactNumeric(type2)) {
                if (SqlTypeUtil.isExactNumeric(resultType)) {
                    RelDataType type1;
                    if (types.size() > i + 1 && SqlTypeUtil.isDatetime(type1 = types.get(i + 1))) {
                        resultType = type1;
                        return this.createTypeWithNullability(resultType, nullCount > 0 || nullableCount > 0);
                    }
                    if (type2.equals(resultType)) continue;
                    if (!typeName.allowsPrec() && !resultTypeName.allowsPrec()) {
                        if (type2.getPrecision() <= resultType.getPrecision()) continue;
                        resultType = type2;
                        continue;
                    }
                    int p1 = resultType.getPrecision();
                    int p2 = type2.getPrecision();
                    int s1 = resultType.getScale();
                    int s2 = type2.getScale();
                    int maxPrecision = this.typeSystem.getMaxNumericPrecision();
                    int maxScale = this.typeSystem.getMaxNumericScale();
                    int dout = Math.max(p1 - s1, p2 - s2);
                    dout = Math.min(dout, maxPrecision);
                    int scale = Math.max(s1, s2);
                    scale = Math.min(scale, maxPrecision - dout);
                    scale = Math.min(scale, maxScale);
                    int precision = dout + scale;
                    assert (precision <= maxPrecision);
                    assert (precision > 0 || resultType.getSqlTypeName() == SqlTypeName.DECIMAL && precision == 0 && scale == 0);
                    resultType = this.createSqlType(SqlTypeName.DECIMAL, precision, scale);
                    continue;
                }
                if (SqlTypeUtil.isApproximateNumeric(resultType)) {
                    if (!SqlTypeUtil.isDecimal(type2)) continue;
                    resultType = this.createDoublePrecisionType();
                    continue;
                }
                return null;
            }
            if (SqlTypeUtil.isApproximateNumeric(type2)) {
                if (SqlTypeUtil.isApproximateNumeric(resultType)) {
                    if (type2.getPrecision() <= resultType.getPrecision()) continue;
                    resultType = type2;
                    continue;
                }
                if (SqlTypeUtil.isExactNumeric(resultType)) {
                    if (SqlTypeUtil.isDecimal(resultType)) {
                        resultType = this.createDoublePrecisionType();
                        continue;
                    }
                    resultType = type2;
                    continue;
                }
                return null;
            }
            if (SqlTypeUtil.isInterval(type2)) {
                RelDataType type1;
                if (types.size() > i + 1 && SqlTypeUtil.isDatetime(type1 = types.get(i + 1))) {
                    resultType = type1;
                    return this.createTypeWithNullability(resultType, nullCount > 0 || nullableCount > 0);
                }
                if (type2.equals(resultType)) continue;
                type1 = resultType;
                resultType = ((IntervalSqlType)resultType).combine(this, (IntervalSqlType)type2);
                resultType = ((IntervalSqlType)resultType).combine(this, (IntervalSqlType)type1);
                continue;
            }
            if (SqlTypeUtil.isDatetime(type2)) {
                RelDataType type1;
                if (types.size() <= i + 1 || !SqlTypeUtil.isInterval(type1 = types.get(i + 1)) && !SqlTypeUtil.isIntType(type1)) continue;
                resultType = type2;
                return this.createTypeWithNullability(resultType, nullCount > 0 || nullableCount > 0);
            }
            return null;
        }
        if (resultType != null && nullableCount > 0) {
            resultType = this.createTypeWithNullability(resultType, true);
        }
        return resultType;
    }

    private RelDataType createDoublePrecisionType() {
        return this.createSqlType(SqlTypeName.DOUBLE);
    }

    private RelDataType copyMultisetType(RelDataType type2, boolean nullable) {
        MultisetSqlType mt = (MultisetSqlType)type2;
        RelDataType elementType = this.copyType(mt.getComponentType());
        return new MultisetSqlType(elementType, nullable);
    }

    private RelDataType copyIntervalType(RelDataType type2, boolean nullable) {
        return new IntervalSqlType(this.typeSystem, Objects.requireNonNull(type2.getIntervalQualifier(), () -> "type.getIntervalQualifier() for " + type2), nullable);
    }

    private static RelDataType copyObjectType(RelDataType type2, boolean nullable) {
        return new ObjectSqlType(type2.getSqlTypeName(), type2.getSqlIdentifier(), nullable, type2.getFieldList(), type2.getComparability());
    }

    private RelDataType copyArrayType(RelDataType type2, boolean nullable) {
        ArraySqlType at = (ArraySqlType)type2;
        RelDataType elementType = this.copyType(at.getComponentType());
        return new ArraySqlType(elementType, nullable);
    }

    private RelDataType copyMapType(RelDataType type2, boolean nullable) {
        MapSqlType mt = (MapSqlType)type2;
        RelDataType keyType = this.copyType(mt.getKeyType());
        RelDataType valueType = this.copyType(mt.getValueType());
        return new MapSqlType(keyType, valueType, nullable);
    }

    @Override
    protected RelDataType canonize(RelDataType type2) {
        if (!((type2 = super.canonize(type2)) instanceof ObjectSqlType)) {
            return type2;
        }
        ObjectSqlType objectType = (ObjectSqlType)type2;
        if (!objectType.isNullable()) {
            objectType.setFamily(objectType);
        } else {
            objectType.setFamily((RelDataTypeFamily)((Object)this.createTypeWithNullability(objectType, false)));
        }
        return type2;
    }
}

