/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ProcedureNamespace
extends AbstractNamespace {
    private final SqlValidatorScope scope;
    private final SqlCall call;

    ProcedureNamespace(SqlValidatorImpl validator, SqlValidatorScope scope, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.scope = scope;
        this.call = call;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.inferUnknownTypes(this.validator.unknownType, this.scope, this.call);
        RelDataType type2 = this.validator.deriveTypeImpl(this.scope, this.call);
        SqlOperator operator = this.call.getOperator();
        SqlCallBinding callBinding = new SqlCallBinding(this.validator, this.scope, this.call);
        if (!(operator instanceof SqlTableFunction)) {
            throw new IllegalArgumentException("Argument must be a table function: " + operator.getNameAsId());
        }
        SqlTableFunction tableFunction = (SqlTableFunction)((Object)operator);
        if (type2.getSqlTypeName() != SqlTypeName.CURSOR) {
            throw new IllegalArgumentException("Table function should have CURSOR type, not " + type2);
        }
        SqlReturnTypeInference rowTypeInference = tableFunction.getRowTypeInference();
        return Objects.requireNonNull(rowTypeInference.inferReturnType(callBinding), () -> "got null from inferReturnType for call " + callBinding.getCall());
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.call;
    }
}

