/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import org.apache.commons.dbcp2.LifetimeExceededException;
import org.apache.commons.dbcp2.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.pool2.SwallowedExceptionListener;

public class SwallowedExceptionLogger
implements SwallowedExceptionListener {
    private final Log log;
    private final boolean logExpiredConnections;

    public SwallowedExceptionLogger(Log log2) {
        this(log2, true);
    }

    public SwallowedExceptionLogger(Log log2, boolean logExpiredConnections) {
        this.log = log2;
        this.logExpiredConnections = logExpiredConnections;
    }

    @Override
    public void onSwallowException(Exception e) {
        if (this.logExpiredConnections || !(e instanceof LifetimeExceededException)) {
            this.log.warn(Utils.getMessage("swallowedExceptionLogger.onSwallowedException"), e);
        }
    }
}

