/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.auth;

import com.google.inject.Inject;
import io.divide.client.GsonResponse;
import io.divide.client.auth.AuthManager;
import io.divide.client.auth.AuthWebService;
import io.divide.client.auth.credentials.LoginCredentials;
import io.divide.client.auth.credentials.SignUpCredentials;
import io.divide.client.auth.credentials.ValidCredentials;
import io.divide.shared.logging.Logger;
import io.divide.shared.server.AuthServerLogic;
import io.divide.shared.server.DAO;
import io.divide.shared.server.KeyManager;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.util.DaoUtils;
import io.divide.shared.util.ObjectUtils;
import java.util.Map;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.Header;
import retrofit.http.Path;
import rx.Observable;
import rx.Subscriber;

public class MockAuthWebService
implements AuthWebService {
    private static Logger logger = Logger.getLogger(MockAuthWebService.class);
    private AuthServerLogic<TransientObject> authServerLogic;
    private AuthManager authManager;

    @Inject
    public MockAuthWebService(DAO<TransientObject, TransientObject> dao, KeyManager keyManager) {
        this.authServerLogic = new AuthServerLogic(dao, keyManager);
    }

    public void setAuthManger(AuthManager authManager) {
        this.authManager = authManager;
    }

    public Response userSignUp(@Body SignUpCredentials credentials) {
        try {
            Credentials c = this.authServerLogic.userSignUp((Credentials)credentials);
            return new GsonResponse("", 200, "", null, c).build();
        }
        catch (DAO.DAOException e) {
            return new GsonResponse("", e.getStatusCode(), e.getMessage(), null, null).build();
        }
    }

    public Observable<ValidCredentials> userSignUpA(@Body SignUpCredentials credentials) {
        try {
            return Observable.from((Object)DaoUtils.to(ValidCredentials.class, (TransientObject)this.authServerLogic.userSignUp((Credentials)credentials)));
        }
        catch (DAO.DAOException e) {
            return Observable.error((Throwable)e);
        }
    }

    public Response login(@Body LoginCredentials credentials) {
        try {
            Credentials dbCreds = this.authServerLogic.userSignIn((Credentials)credentials);
            return new GsonResponse("", 200, "", null, dbCreds).build();
        }
        catch (DAO.DAOException e) {
            return new GsonResponse("", e.getStatusCode(), e.getMessage(), null, null).build();
        }
    }

    public Observable<ValidCredentials> loginA(@Body LoginCredentials credentials) {
        try {
            return Observable.from((Object)DaoUtils.to(ValidCredentials.class, (TransientObject)this.authServerLogic.userSignIn((Credentials)credentials)));
        }
        catch (DAO.DAOException e) {
            return Observable.error((Throwable)e);
        }
    }

    public Observable<byte[]> getPublicKeyA() {
        return Observable.from((Object)this.authServerLogic.getPublicKey());
    }

    public byte[] getPublicKey() {
        return this.authServerLogic.getPublicKey();
    }

    public Observable<ValidCredentials> getUserFromAuthToken(@Path(value="token") String authToken) {
        try {
            return Observable.from((Object)DaoUtils.to(ValidCredentials.class, (TransientObject)this.authServerLogic.getUserFromAuthToken(authToken)));
        }
        catch (DAO.DAOException e) {
            return Observable.error((Throwable)e);
        }
    }

    public Observable<ValidCredentials> getUserFromRecoveryToken(final @Path(value="token") String authToken) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ValidCredentials>(){

            public void call(Subscriber<? super ValidCredentials> subscriber) {
                try {
                    subscriber.onNext((Object)DaoUtils.to(ValidCredentials.class, (TransientObject)MockAuthWebService.this.authServerLogic.getUserFromRecoveryToken(authToken)));
                }
                catch (DAO.DAOException e) {
                    System.out.println(e.getStatusCode() + " : " + e.getMessage());
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    public Observable<Void> sendUserData(@Header(value="Authorization") String authToken, final @Path(value="userId") String userId, final @Body Map<String, ?> data) {
        this.verifyAuthToken(authToken);
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Void>(){

            public void call(Subscriber<? super Void> subscriber) {
                try {
                    System.err.println("Saving: " + userId + ", " + data);
                    MockAuthWebService.this.authServerLogic.recieveUserData(userId, data);
                    subscriber.onNext(null);
                }
                catch (DAO.DAOException e) {
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    public Observable<Map<String, Object>> getUserData(@Header(value="Authorization") String authToken, final String userId) {
        this.verifyAuthToken(authToken);
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Map<String, Object>>(){

            public void call(Subscriber<? super Map<String, Object>> subscriber) {
                try {
                    Credentials x = MockAuthWebService.this.authServerLogic.getUserById(userId);
                    TransientObject to = (TransientObject)ObjectUtils.get1stOrNull((Object[])new Credentials[]{x});
                    if (to != null) {
                        subscriber.onNext((Object)MockAuthWebService.this.authServerLogic.sendUserData(userId));
                    } else {
                        subscriber.onNext(null);
                    }
                }
                catch (DAO.DAOException e) {
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    public void verifyAuthToken(String token) {
        System.out.println("MockAuthWebService: " + token);
        token = token.substring("CUSTOM ".length(), token.length());
        if (token == null || token.length() == 0 || this.authManager == null || this.authManager.getUser() == null || this.authManager.getUser().getAuthToken() == null || !this.authManager.getUser().getAuthToken().equals(token)) {
            throw new RuntimeException("");
        }
    }
}

