/*
 * Decompiled with CFR 0.152.
 */
package io.divide.client.data;

import com.google.inject.Inject;
import io.divide.client.BackendObject;
import io.divide.client.GsonResponse;
import io.divide.client.auth.AuthManager;
import io.divide.client.data.DataWebService;
import io.divide.shared.logging.Logger;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.Query;
import java.util.Collection;
import java.util.List;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.EncodedPath;
import retrofit.http.Header;
import rx.Observable;
import rx.Subscriber;

public class MockDataWebService
implements DataWebService {
    private static Logger logger = Logger.getLogger(MockDataWebService.class);
    @Inject
    private AuthManager authManager;
    @Inject
    private DAO<TransientObject, TransientObject> dao;

    public Response get(@Header(value="Authorization") String authToken, @EncodedPath(value="objectType") String objectType, @Body Collection<String> keys) {
        this.verifyAuthToken(authToken);
        try {
            Collection got = this.dao.get(objectType, keys.toArray(new String[keys.size()]));
            return new GsonResponse("", 200, "", null, got).build();
        }
        catch (DAO.DAOException e) {
            return new GsonResponse("", e.getStatusCode(), e.getMessage(), null, null).build();
        }
    }

    public Response query(@Header(value="Authorization") String authToken, @Body Query query) {
        this.verifyAuthToken(authToken);
        try {
            List got = this.dao.query(query);
            return new GsonResponse("", 200, "", null, got).build();
        }
        catch (DAO.DAOException e) {
            return new GsonResponse("", e.getStatusCode(), e.getMessage(), null, null).build();
        }
    }

    public <B extends BackendObject> Observable<Void> save(@Header(value="Authorization") String authToken, final @Body Collection<B> objects) {
        this.verifyAuthToken(authToken);
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Void>(){

            public void call(Subscriber<? super Void> subscriber) {
                try {
                    MockDataWebService.this.dao.save((TransientObject[])((BackendObject[])objects.toArray()));
                    subscriber.onNext(null);
                }
                catch (DAO.DAOException e) {
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    public Observable<Integer> count(@Header(value="Authorization") String authToken, @EncodedPath(value="objectType") String objectType) {
        this.verifyAuthToken(authToken);
        return Observable.from((Object)this.dao.count(objectType));
    }

    public void verifyAuthToken(String token) {
        if ((token = token.replace("CUSTOM ", "")) == null || token.length() == 0 || this.authManager == null || this.authManager.getUser() == null || this.authManager.getUser().getAuthToken() == null || !this.authManager.getUser().getAuthToken().equals(token)) {
            throw new RuntimeException("");
        }
    }
}

