/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.NodeToStringTransformer;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.Loader;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class OptionHelper {
    static final String DELIM_START = "${";
    static final char DELIM_STOP = '}';
    static final String DELIM_DEFAULT = ":-";
    static final int DELIM_START_LEN = 2;
    static final int DELIM_STOP_LEN = 1;
    static final int DELIM_DEFAULT_LEN = 2;
    static final String _IS_UNDEFINED = "_IS_UNDEFINED";

    public static Object instantiateByClassName(String className2, Class<?> superClass, Context context) throws IncompatibleClassException, DynamicClassLoadingException {
        ClassLoader classLoader2 = Loader.getClassLoaderOfObject(context);
        return OptionHelper.instantiateByClassName(className2, superClass, classLoader2);
    }

    public static Object instantiateByClassNameAndParameter(String className2, Class<?> superClass, Context context, Class<?> type2, Object param) throws IncompatibleClassException, DynamicClassLoadingException {
        ClassLoader classLoader2 = Loader.getClassLoaderOfObject(context);
        return OptionHelper.instantiateByClassNameAndParameter(className2, superClass, classLoader2, type2, param);
    }

    public static Object instantiateByClassName(String className2, Class<?> superClass, ClassLoader classLoader2) throws IncompatibleClassException, DynamicClassLoadingException {
        return OptionHelper.instantiateByClassNameAndParameter(className2, superClass, classLoader2, null, null);
    }

    public static Object instantiateByClassNameAndParameter(String className2, Class<?> superClass, ClassLoader classLoader2, Class<?> type2, Object parameter) throws IncompatibleClassException, DynamicClassLoadingException {
        if (className2 == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> classObj = null;
            classObj = classLoader2.loadClass(className2);
            if (!superClass.isAssignableFrom(classObj)) {
                throw new IncompatibleClassException(superClass, classObj);
            }
            if (type2 == null) {
                return classObj.newInstance();
            }
            Constructor<?> constructor2 = classObj.getConstructor(type2);
            return constructor2.newInstance(parameter);
        }
        catch (IncompatibleClassException ice) {
            throw ice;
        }
        catch (Throwable t) {
            throw new DynamicClassLoadingException("Failed to instantiate type " + className2, t);
        }
    }

    public static String substVars(String val, PropertyContainer pc1) {
        return OptionHelper.substVars(val, pc1, null);
    }

    public static String substVars(String input, PropertyContainer pc0, PropertyContainer pc1) {
        try {
            return NodeToStringTransformer.substituteVariable(input, pc0, pc1);
        }
        catch (ScanException e) {
            throw new IllegalArgumentException("Failed to parse input [" + input + "]", e);
        }
    }

    public static String propertyLookup(String key, PropertyContainer pc1, PropertyContainer pc2) {
        String value2 = null;
        value2 = pc1.getProperty(key);
        if (value2 == null && pc2 != null) {
            value2 = pc2.getProperty(key);
        }
        if (value2 == null) {
            value2 = OptionHelper.getSystemProperty(key, null);
        }
        if (value2 == null) {
            value2 = OptionHelper.getEnv(key);
        }
        return value2;
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (SecurityException e) {
            return def;
        }
    }

    public static String getEnv(String key) {
        try {
            return System.getenv(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static void setSystemProperties(ContextAware contextAware, Properties props) {
        for (Object o : props.keySet()) {
            String key = (String)o;
            String value2 = props.getProperty(key);
            OptionHelper.setSystemProperty(contextAware, key, value2);
        }
    }

    public static void setSystemProperty(ContextAware contextAware, String key, String value2) {
        try {
            System.setProperty(key, value2);
        }
        catch (SecurityException e) {
            contextAware.addError("Failed to set system property [" + key + "]", e);
        }
    }

    public static Properties getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (SecurityException e) {
            return new Properties();
        }
    }

    public static String[] extractDefaultReplacement(String key) {
        String[] result2 = new String[2];
        if (key == null) {
            return result2;
        }
        result2[0] = key;
        int d = key.indexOf(DELIM_DEFAULT);
        if (d != -1) {
            result2[0] = key.substring(0, d);
            result2[1] = key.substring(d + 2);
        }
        return result2;
    }

    public static boolean toBoolean(String value2, boolean dEfault) {
        if (value2 == null) {
            return dEfault;
        }
        String trimmedVal = value2.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

