/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jmx;

import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultObjectNameFactory
implements ObjectNameFactory {
    private static final char[] QUOTABLE_CHARS = new char[]{',', '=', ':', '\"'};
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxReporter.class);

    @Override
    public ObjectName createName(String type2, String domain, String name2) {
        try {
            Hashtable<String, String> properties2 = new Hashtable<String, String>();
            properties2.put("name", name2);
            properties2.put("type", type2);
            ObjectName objectName = new ObjectName(domain, properties2);
            if (objectName.isDomainPattern()) {
                domain = ObjectName.quote(domain);
            }
            if (objectName.isPropertyValuePattern("name") || this.shouldQuote(objectName.getKeyProperty("name"))) {
                properties2.put("name", ObjectName.quote(name2));
            }
            if (objectName.isPropertyValuePattern("type") || this.shouldQuote(objectName.getKeyProperty("type"))) {
                properties2.put("type", ObjectName.quote(type2));
            }
            objectName = new ObjectName(domain, properties2);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(domain, "name", ObjectName.quote(name2));
            }
            catch (MalformedObjectNameException e1) {
                LOGGER.warn("Unable to register {} {}", type2, name2, e1);
                throw new RuntimeException(e1);
            }
        }
    }

    private boolean shouldQuote(String value2) {
        for (char quotableChar : QUOTABLE_CHARS) {
            if (value2.indexOf(quotableChar) == -1) continue;
            return true;
        }
        return false;
    }
}

