/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GarbageCollectorMetricSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final List<GarbageCollectorMXBean> garbageCollectors;

    public GarbageCollectorMetricSet() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    public GarbageCollectorMetricSet(Collection<GarbageCollectorMXBean> garbageCollectors) {
        this.garbageCollectors = new ArrayList<GarbageCollectorMXBean>(garbageCollectors);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Long>> gauges = new HashMap<String, Gauge<Long>>();
        for (GarbageCollectorMXBean gc : this.garbageCollectors) {
            String name2 = WHITESPACE.matcher(gc.getName()).replaceAll("-");
            gauges.put(MetricRegistry.name(name2, "count"), gc::getCollectionCount);
            gauges.put(MetricRegistry.name(name2, "time"), gc::getCollectionTime);
        }
        return Collections.unmodifiableMap(gauges);
    }
}

