/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WeakMemoryHolder;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public class Memory
extends Pointer {
    private static final Map<Memory, Reference<Memory>> allocatedMemory = Collections.synchronizedMap(new WeakHashMap());
    private static final WeakMemoryHolder buffers = new WeakMemoryHolder();
    protected long size;

    public static void purge() {
        buffers.clean();
    }

    public static void disposeAll() {
        LinkedList<Memory> refs = new LinkedList<Memory>(allocatedMemory.keySet());
        for (Memory r : refs) {
            r.dispose();
        }
    }

    public Memory(long size2) {
        this.size = size2;
        if (size2 <= 0L) {
            throw new IllegalArgumentException("Allocation size must be greater than zero");
        }
        this.peer = Memory.malloc(size2);
        if (this.peer == 0L) {
            throw new OutOfMemoryError("Cannot allocate " + size2 + " bytes");
        }
        allocatedMemory.put(this, new WeakReference<Memory>(this));
    }

    protected Memory() {
    }

    @Override
    public Pointer share(long offset2) {
        return this.share(offset2, this.size() - offset2);
    }

    @Override
    public Pointer share(long offset2, long sz) {
        this.boundsCheck(offset2, sz);
        return new SharedMemory(offset2, sz);
    }

    public Memory align(int byteBoundary) {
        if (byteBoundary <= 0) {
            throw new IllegalArgumentException("Byte boundary must be positive: " + byteBoundary);
        }
        for (int i = 0; i < 32; ++i) {
            if (byteBoundary != 1 << i) continue;
            long mask = (long)byteBoundary - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if ((this.peer & mask) != this.peer) {
                long newPeer = this.peer + (long)byteBoundary - 1L & mask;
                long newSize = this.peer + this.size - newPeer;
                if (newSize <= 0L) {
                    throw new IllegalArgumentException("Insufficient memory to align to the requested boundary");
                }
                return (Memory)this.share(newPeer - this.peer, newSize);
            }
            return this;
        }
        throw new IllegalArgumentException("Byte boundary must be a power of two");
    }

    protected void finalize() {
        this.dispose();
    }

    protected synchronized void dispose() {
        try {
            Memory.free(this.peer);
        }
        finally {
            allocatedMemory.remove(this);
            this.peer = 0L;
        }
    }

    public void clear() {
        this.clear(this.size);
    }

    public boolean valid() {
        return this.peer != 0L;
    }

    public long size() {
        return this.size;
    }

    protected void boundsCheck(long off, long sz) {
        if (off < 0L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + off);
        }
        if (off + sz > this.size) {
            String msg2 = "Bounds exceeds available space : size=" + this.size + ", offset=" + (off + sz);
            throw new IndexOutOfBoundsException(msg2);
        }
    }

    @Override
    public void read(long bOff, byte[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 1L);
        super.read(bOff, buf, index2, length);
    }

    @Override
    public void read(long bOff, short[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 2L);
        super.read(bOff, buf, index2, length);
    }

    @Override
    public void read(long bOff, char[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 2L);
        super.read(bOff, buf, index2, length);
    }

    @Override
    public void read(long bOff, int[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 4L);
        super.read(bOff, buf, index2, length);
    }

    @Override
    public void read(long bOff, long[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 8L);
        super.read(bOff, buf, index2, length);
    }

    @Override
    public void read(long bOff, float[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 4L);
        super.read(bOff, buf, index2, length);
    }

    @Override
    public void read(long bOff, double[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 8L);
        super.read(bOff, buf, index2, length);
    }

    @Override
    public void write(long bOff, byte[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 1L);
        super.write(bOff, buf, index2, length);
    }

    @Override
    public void write(long bOff, short[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 2L);
        super.write(bOff, buf, index2, length);
    }

    @Override
    public void write(long bOff, char[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 2L);
        super.write(bOff, buf, index2, length);
    }

    @Override
    public void write(long bOff, int[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 4L);
        super.write(bOff, buf, index2, length);
    }

    @Override
    public void write(long bOff, long[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 8L);
        super.write(bOff, buf, index2, length);
    }

    @Override
    public void write(long bOff, float[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 4L);
        super.write(bOff, buf, index2, length);
    }

    @Override
    public void write(long bOff, double[] buf, int index2, int length) {
        this.boundsCheck(bOff, (long)length * 8L);
        super.write(bOff, buf, index2, length);
    }

    @Override
    public byte getByte(long offset2) {
        this.boundsCheck(offset2, 1L);
        return super.getByte(offset2);
    }

    @Override
    public char getChar(long offset2) {
        this.boundsCheck(offset2, 1L);
        return super.getChar(offset2);
    }

    @Override
    public short getShort(long offset2) {
        this.boundsCheck(offset2, 2L);
        return super.getShort(offset2);
    }

    @Override
    public int getInt(long offset2) {
        this.boundsCheck(offset2, 4L);
        return super.getInt(offset2);
    }

    @Override
    public long getLong(long offset2) {
        this.boundsCheck(offset2, 8L);
        return super.getLong(offset2);
    }

    @Override
    public float getFloat(long offset2) {
        this.boundsCheck(offset2, 4L);
        return super.getFloat(offset2);
    }

    @Override
    public double getDouble(long offset2) {
        this.boundsCheck(offset2, 8L);
        return super.getDouble(offset2);
    }

    @Override
    public Pointer getPointer(long offset2) {
        this.boundsCheck(offset2, Native.POINTER_SIZE);
        return super.getPointer(offset2);
    }

    @Override
    public ByteBuffer getByteBuffer(long offset2, long length) {
        this.boundsCheck(offset2, length);
        ByteBuffer b = super.getByteBuffer(offset2, length);
        buffers.put(b, this);
        return b;
    }

    @Override
    public String getString(long offset2, String encoding) {
        this.boundsCheck(offset2, 0L);
        return super.getString(offset2, encoding);
    }

    @Override
    public String getWideString(long offset2) {
        this.boundsCheck(offset2, 0L);
        return super.getWideString(offset2);
    }

    @Override
    public void setByte(long offset2, byte value2) {
        this.boundsCheck(offset2, 1L);
        super.setByte(offset2, value2);
    }

    @Override
    public void setChar(long offset2, char value2) {
        this.boundsCheck(offset2, Native.WCHAR_SIZE);
        super.setChar(offset2, value2);
    }

    @Override
    public void setShort(long offset2, short value2) {
        this.boundsCheck(offset2, 2L);
        super.setShort(offset2, value2);
    }

    @Override
    public void setInt(long offset2, int value2) {
        this.boundsCheck(offset2, 4L);
        super.setInt(offset2, value2);
    }

    @Override
    public void setLong(long offset2, long value2) {
        this.boundsCheck(offset2, 8L);
        super.setLong(offset2, value2);
    }

    @Override
    public void setFloat(long offset2, float value2) {
        this.boundsCheck(offset2, 4L);
        super.setFloat(offset2, value2);
    }

    @Override
    public void setDouble(long offset2, double value2) {
        this.boundsCheck(offset2, 8L);
        super.setDouble(offset2, value2);
    }

    @Override
    public void setPointer(long offset2, Pointer value2) {
        this.boundsCheck(offset2, Native.POINTER_SIZE);
        super.setPointer(offset2, value2);
    }

    @Override
    public void setString(long offset2, String value2, String encoding) {
        this.boundsCheck(offset2, (long)Native.getBytes(value2, encoding).length + 1L);
        super.setString(offset2, value2, encoding);
    }

    @Override
    public void setWideString(long offset2, String value2) {
        this.boundsCheck(offset2, ((long)value2.length() + 1L) * (long)Native.WCHAR_SIZE);
        super.setWideString(offset2, value2);
    }

    @Override
    public String toString() {
        return "allocated@0x" + Long.toHexString(this.peer) + " (" + this.size + " bytes)";
    }

    protected static void free(long p) {
        if (p != 0L) {
            Native.free(p);
        }
    }

    protected static long malloc(long size2) {
        return Native.malloc(size2);
    }

    public String dump() {
        return this.dump(0L, (int)this.size());
    }

    private class SharedMemory
    extends Memory {
        public SharedMemory(long offset2, long size2) {
            this.size = size2;
            this.peer = Memory.this.peer + offset2;
        }

        @Override
        protected synchronized void dispose() {
            this.peer = 0L;
        }

        @Override
        protected void boundsCheck(long off, long sz) {
            Memory.this.boundsCheck(this.peer - Memory.this.peer + off, sz);
        }

        @Override
        public String toString() {
            return super.toString() + " (shared from " + Memory.this.toString() + ")";
        }
    }
}

