/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;

class NativeString
implements CharSequence,
Comparable {
    static final String WIDE_STRING = "--WIDE-STRING--";
    private Pointer pointer;
    private String encoding;

    public NativeString(String string2) {
        this(string2, Native.getDefaultStringEncoding());
    }

    public NativeString(String string2, boolean wide) {
        this(string2, wide ? WIDE_STRING : Native.getDefaultStringEncoding());
    }

    public NativeString(WString string2) {
        this(string2.toString(), WIDE_STRING);
    }

    public NativeString(String string2, String encoding) {
        if (string2 == null) {
            throw new NullPointerException("String must not be null");
        }
        this.encoding = encoding;
        if (WIDE_STRING.equals(this.encoding)) {
            int len = (string2.length() + 1) * Native.WCHAR_SIZE;
            this.pointer = new StringMemory(len);
            this.pointer.setWideString(0L, string2);
        } else {
            byte[] data2 = Native.getBytes(string2, encoding);
            this.pointer = new StringMemory(data2.length + 1);
            this.pointer.write(0L, data2, 0, data2.length);
            this.pointer.setByte(data2.length, (byte)0);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof CharSequence) {
            return this.compareTo(other) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        boolean wide = WIDE_STRING.equals(this.encoding);
        return wide ? this.pointer.getWideString(0L) : this.pointer.getString(0L, this.encoding);
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    @Override
    public char charAt(int index2) {
        return this.toString().charAt(index2);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start2, int end2) {
        return this.toString().subSequence(start2, end2);
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        return this.toString().compareTo(other.toString());
    }

    private class StringMemory
    extends Memory {
        public StringMemory(long size2) {
            super(size2);
        }

        @Override
        public String toString() {
            return NativeString.this.toString();
        }
    }
}

