/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.FromMapMode;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigObject;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

final class PropertiesParser {
    PropertiesParser() {
    }

    static AbstractConfigObject parse(Reader reader, ConfigOrigin origin2) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        return PropertiesParser.fromProperties(origin2, props);
    }

    static String lastElement(String path2) {
        int i = path2.lastIndexOf(46);
        if (i < 0) {
            return path2;
        }
        return path2.substring(i + 1);
    }

    static String exceptLastElement(String path2) {
        int i = path2.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        return path2.substring(0, i);
    }

    static Path pathFromPropertyKey(String key) {
        String last2 = PropertiesParser.lastElement(key);
        String exceptLast = PropertiesParser.exceptLastElement(key);
        Path path2 = new Path(last2, null);
        while (exceptLast != null) {
            last2 = PropertiesParser.lastElement(exceptLast);
            exceptLast = PropertiesParser.exceptLastElement(exceptLast);
            path2 = new Path(last2, path2);
        }
        return path2;
    }

    static AbstractConfigObject fromProperties(ConfigOrigin origin2, Properties props) {
        return PropertiesParser.fromEntrySet(origin2, props.entrySet());
    }

    private static <K, V> AbstractConfigObject fromEntrySet(ConfigOrigin origin2, Set<Map.Entry<K, V>> entries2) {
        Map<Path, Object> pathMap = PropertiesParser.getPathMap(entries2);
        return PropertiesParser.fromPathMap(origin2, pathMap, true);
    }

    private static <K, V> Map<Path, Object> getPathMap(Set<Map.Entry<K, V>> entries2) {
        HashMap<Path, Object> pathMap = new HashMap<Path, Object>();
        for (Map.Entry<K, V> entry : entries2) {
            K key = entry.getKey();
            if (!(key instanceof String)) continue;
            Path path2 = PropertiesParser.pathFromPropertyKey((String)key);
            pathMap.put(path2, entry.getValue());
        }
        return pathMap;
    }

    static AbstractConfigObject fromStringMap(ConfigOrigin origin2, Map<String, String> stringMap) {
        return PropertiesParser.fromEntrySet(origin2, stringMap.entrySet());
    }

    static AbstractConfigObject fromPathMap(ConfigOrigin origin2, Map<?, ?> pathExpressionMap) {
        HashMap<Path, Object> pathMap = new HashMap<Path, Object>();
        for (Map.Entry<?, ?> entry : pathExpressionMap.entrySet()) {
            Object keyObj = entry.getKey();
            if (!(keyObj instanceof String)) {
                throw new ConfigException.BugOrBroken("Map has a non-string as a key, expecting a path expression as a String");
            }
            Path path2 = Path.newPath((String)keyObj);
            pathMap.put(path2, entry.getValue());
        }
        return PropertiesParser.fromPathMap(origin2, pathMap, false);
    }

    private static AbstractConfigObject fromPathMap(ConfigOrigin origin2, Map<Path, Object> pathMap, boolean convertedFromProperties) {
        HashSet<Path> scopePaths = new HashSet<Path>();
        HashSet<Path> valuePaths = new HashSet<Path>();
        for (Path path2 : pathMap.keySet()) {
            valuePaths.add(path2);
            for (Iterator next = path2.parent(); next != null; next = ((Path)((Object)next)).parent()) {
                scopePaths.add((Path)((Object)next));
            }
        }
        if (convertedFromProperties) {
            valuePaths.removeAll(scopePaths);
        } else {
            for (Path path2 : valuePaths) {
                if (!scopePaths.contains(path2)) continue;
                throw new ConfigException.BugOrBroken("In the map, path '" + path2.render() + "' occurs as both the parent object of a value and as a value. Because Map has no defined ordering, this is a broken situation.");
            }
        }
        HashMap<String, AbstractConfigValue> root2 = new HashMap<String, AbstractConfigValue>();
        HashMap scopes = new HashMap();
        for (Path path3 : scopePaths) {
            HashMap scope2 = new HashMap();
            scopes.put(path3, scope2);
        }
        for (Path path3 : valuePaths) {
            Path parentPath = path3.parent();
            HashMap<String, AbstractConfigValue> parent2 = parentPath != null ? (Map)scopes.get(parentPath) : root2;
            String last2 = path3.last();
            Object rawValue = pathMap.get(path3);
            AbstractConfigValue value2 = convertedFromProperties ? (rawValue instanceof String ? new ConfigString.Quoted(origin2, (String)rawValue) : null) : ConfigImpl.fromAnyRef(pathMap.get(path3), origin2, FromMapMode.KEYS_ARE_PATHS);
            if (value2 == null) continue;
            parent2.put(last2, value2);
        }
        ArrayList<Path> sortedScopePaths = new ArrayList<Path>();
        sortedScopePaths.addAll(scopePaths);
        Collections.sort(sortedScopePaths, new Comparator<Path>(){

            @Override
            public int compare(Path a, Path b) {
                return b.length() - a.length();
            }
        });
        for (Path scopePath : sortedScopePaths) {
            Map scope3 = (Map)scopes.get(scopePath);
            Path parentPath = scopePath.parent();
            HashMap<String, AbstractConfigValue> parent3 = parentPath != null ? (Map)scopes.get(parentPath) : root2;
            SimpleConfigObject o = new SimpleConfigObject(origin2, scope3, ResolveStatus.RESOLVED, false);
            parent3.put(scopePath.last(), o);
        }
        return new SimpleConfigObject(origin2, root2, ResolveStatus.RESOLVED, false);
    }
}

