/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TByteHash;
import gnu.trove.TByteHashingStrategy;
import gnu.trove.TByteIterator;
import gnu.trove.TByteProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class TByteHashSet
extends TByteHash {
    public TByteHashSet() {
    }

    public TByteHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TByteHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TByteHashSet(byte[] array2) {
        this(array2.length);
        this.addAll(array2);
    }

    public TByteHashSet(TByteHashingStrategy strategy) {
        super(strategy);
    }

    public TByteHashSet(int initialCapacity, TByteHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TByteHashSet(int initialCapacity, float loadFactor, TByteHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TByteHashSet(byte[] array2, TByteHashingStrategy strategy) {
        this(array2.length, strategy);
        this.addAll(array2);
    }

    public TByteIterator iterator() {
        return new TByteIterator(this);
    }

    public boolean add(byte val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = val;
        this._states[index2] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        byte[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new byte[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            byte o = oldSet[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._states[index2] = 1;
        }
    }

    public byte[] toArray() {
        byte[] result2 = new byte[this.size()];
        byte[] set2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                result2[j++] = set2[i];
            }
        }
        return result2;
    }

    public void clear() {
        super.clear();
        byte[] set2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = set2.length;
            while (i-- > 0) {
                set2[i] = 0;
                states[i] = 0;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TByteHashSet)) {
            return false;
        }
        final TByteHashSet that = (TByteHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TByteProcedure(){

            public final boolean execute(byte value2) {
                return that.contains(value2);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(byte val) {
        int index2 = this.index(val);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public boolean containsAll(byte[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (this.contains(array2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(byte[] array2) {
        boolean changed = false;
        int i = array2.length;
        while (i-- > 0) {
            if (!this.add(array2[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(byte[] array2) {
        boolean changed = false;
        int i = array2.length;
        while (i-- > 0) {
            if (!this.remove(array2[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(byte[] array2) {
        Arrays.sort(array2);
        byte[] set2 = this._set;
        byte[] states = this._states;
        boolean changed = false;
        if (set2 != null) {
            int i = set2.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array2, set2[i]) >= 0) continue;
                this.remove(set2[i]);
                changed = true;
            }
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = stream.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            byte val = stream.readByte();
            this.add(val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEach(new TByteProcedure(){

            public boolean execute(byte value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(value2);
                return true;
            }
        });
        sb.append(']');
        sb.insert(0, '[');
        return sb.toString();
    }

    private final class HashProcedure
    implements TByteProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(byte key) {
            this.h += TByteHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

