/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatIterator;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class TFloatHashSet
extends TFloatHash {
    public TFloatHashSet() {
    }

    public TFloatHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatHashSet(float[] array2) {
        this(array2.length);
        this.addAll(array2);
    }

    public TFloatHashSet(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatHashSet(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatHashSet(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TFloatHashSet(float[] array2, TFloatHashingStrategy strategy) {
        this(array2.length, strategy);
        this.addAll(array2);
    }

    public TFloatIterator iterator() {
        return new TFloatIterator(this);
    }

    public boolean add(float val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = val;
        this._states[index2] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldSet[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._states[index2] = 1;
        }
    }

    public float[] toArray() {
        float[] result2 = new float[this.size()];
        float[] set2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                result2[j++] = set2[i];
            }
        }
        return result2;
    }

    public void clear() {
        super.clear();
        float[] set2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = set2.length;
            while (i-- > 0) {
                set2[i] = 0.0f;
                states[i] = 0;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatHashSet)) {
            return false;
        }
        final TFloatHashSet that = (TFloatHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TFloatProcedure(){

            public final boolean execute(float value2) {
                return that.contains(value2);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(float val) {
        int index2 = this.index(val);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public boolean containsAll(float[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (this.contains(array2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(float[] array2) {
        boolean changed = false;
        int i = array2.length;
        while (i-- > 0) {
            if (!this.add(array2[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(float[] array2) {
        boolean changed = false;
        int i = array2.length;
        while (i-- > 0) {
            if (!this.remove(array2[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(float[] array2) {
        Arrays.sort(array2);
        float[] set2 = this._set;
        byte[] states = this._states;
        boolean changed = false;
        if (set2 != null) {
            int i = set2.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array2, set2[i]) >= 0) continue;
                this.remove(set2[i]);
                changed = true;
            }
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = stream.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            float val = stream.readFloat();
            this.add(val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEach(new TFloatProcedure(){

            public boolean execute(float value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(value2);
                return true;
            }
        });
        sb.append(']');
        sb.insert(0, '[');
        return sb.toString();
    }

    private final class HashProcedure
    implements TFloatProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key) {
            this.h += TFloatHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

