/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatLongIterator;
import gnu.trove.TFloatLongProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TFloatLongHashMap
extends TFloatHash {
    protected transient long[] _values;

    public TFloatLongHashMap() {
    }

    public TFloatLongHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatLongHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatLongHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatLongHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatLongHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TFloatLongHashMap m = (TFloatLongHashMap)super.clone();
        m._values = this._values == null ? null : (long[])this._values.clone();
        return m;
    }

    public TFloatLongIterator iterator() {
        return new TFloatLongIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new long[capacity];
        return capacity;
    }

    public long put(float key, long value2) {
        long previous = 0L;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldKeys = this._set;
        long[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new long[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
            this._states[index2] = 1;
        }
    }

    public long get(float key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0L : this._values[index2];
    }

    public void clear() {
        super.clear();
        float[] keys2 = this._set;
        long[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i = keys2.length;
        while (i-- > 0) {
            keys2[i] = 0.0f;
            vals[i] = 0L;
            states[i] = 0;
        }
    }

    public long remove(float key) {
        long prev = 0L;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatLongHashMap)) {
            return false;
        }
        TFloatLongHashMap that = (TFloatLongHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index2) {
        this._values[index2] = 0L;
        super.removeAt(index2);
    }

    public long[] getValues() {
        long[] vals = new long[this.size()];
        long[] v = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                vals[j++] = v[i];
            }
        }
        return vals;
    }

    public float[] keys() {
        float[] keys2 = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                keys2[j++] = k[i];
            }
        }
        return keys2;
    }

    public boolean containsValue(long val) {
        byte[] states = this._states;
        long[] vals = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TLongProcedure procedure) {
        byte[] states = this._states;
        long[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TFloatLongProcedure procedure) {
        byte[] states = this._states;
        float[] keys2 = this._set;
        long[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TFloatLongProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys2 = this._set;
        long[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TLongFunction function2) {
        byte[] states = this._states;
        long[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                values2[i] = function2.execute(values2[i]);
            }
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, 1L);
    }

    public boolean adjustValue(float key, long amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = stream.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            float key = stream.readFloat();
            long val = stream.readLong();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TFloatLongProcedure(){

            public boolean execute(float key, long value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value2);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TFloatLongProcedure {
        private final TFloatLongHashMap _otherMap;

        EqProcedure(TFloatLongHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(float key, long value2) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value2, this._otherMap.get(key));
        }

        private static boolean eq(long v1, long v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TFloatLongProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, long value2) {
            this.h += TFloatLongHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

