/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons;

import io.docops.asciidoc.buttons.ButtonMaker;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.theme.Theme;
import io.docops.asciidoc.utils.StringFunctionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lio/docops/asciidoc/buttons/RoundButtonItemRenderer;", "Lio/docops/asciidoc/buttons/ButtonMaker;", "()V", "drawButtonRow", "", "rowCount", "", "buttons", "", "Lio/docops/asciidoc/buttons/models/Button;", "theme", "Lio/docops/asciidoc/buttons/theme/Theme;", "drawButtons", "buttonList", "makeButtons", "makeStyles", "docops-button-render"})
public final class RoundButtonItemRenderer
extends ButtonMaker {
    @Override
    @NotNull
    public String makeButtons(@NotNull List<List<Button>> buttons, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(buttons, "buttons");
        Intrinsics.checkNotNullParameter(theme, "theme");
        StringBuilder sb = new StringBuilder(this.makeSvgHead(buttons, 155, 130, 140, theme));
        sb.append(this.makeDefs(theme));
        sb.append(this.makeStyles());
        sb.append(this.drawButtons(buttons, theme));
        if (theme.getLegendOn()) {
            sb.append(this.drawLegend(this.getTypes()));
        }
        sb.append(this.makeSvgEnd());
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtons(List<List<Button>> buttonList, Theme theme) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = buttonList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void buttons;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)item$iv;
            int index2 = n;
            boolean bl = false;
            sb.append(this.drawButtonRow(index2, (List<Button>)buttons, theme));
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtonRow(int rowCount, List<Button> buttons, Theme theme) {
        StringBuilder sb = new StringBuilder("<g>");
        int recXpos = 0;
        recXpos = 80;
        int yPos = 0;
        yPos = 65;
        if (rowCount > 0) {
            yPos = rowCount * 130 + 65;
        }
        int textXPos = 0;
        textXPos = 55;
        Iterable $this$forEachIndexed$iv = buttons;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String str;
            int i;
            int n;
            int index$iv2;
            boolean $i$f$forEachIndexed2;
            Iterable $this$forEachIndexed$iv2;
            int dy;
            List<String> lines;
            void button;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Button button2 = (Button)item$iv;
            int index2 = n2;
            boolean bl = false;
            if (index2 > 0) {
                recXpos += 125;
                textXPos += 115;
            }
            String win = "_blank";
            if (!theme.getNewWin()) {
                win = "_top";
            }
            if (theme.isPDF()) {
                sb.append(StringsKt.trimIndent("\n                   <use x=\"" + recXpos + "\" y=\"" + yPos + "\" xlink:href=\"#myCircle\" fill=\"" + theme.buttonColor((Button)button) + "\">\n                        <title class=\"description\">" + StringFunctionsKt.escapeXml(button.getDescription()) + "</title>\n                   </use>   \n                "));
                sb.append("\n                <text x=\"" + recXpos + "\" y=\"" + (yPos + 5) + "\" text-anchor=\"middle\" class=\"label\" fill=\"" + theme.buttonTextColor((Button)button) + "\">");
                lines = StringFunctionsKt.makeLines(button.getTitle());
                dy = 0;
                if (lines.size() > 2) {
                    dy = -10 * (lines.size() - 2);
                }
                $this$forEachIndexed$iv2 = lines;
                $i$f$forEachIndexed2 = false;
                index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    if ((n = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string2 = (String)item$iv2;
                    i = n;
                    boolean bl2 = false;
                    if (i > 0) {
                        dy = 12;
                    }
                    sb.append("<tspan x=\"" + recXpos + "\" dy=\"" + dy + "\">" + StringFunctionsKt.escapeXml(str) + "</tspan>");
                }
                sb.append("</text>");
                continue;
            }
            sb.append(StringsKt.trimIndent("\n                    <a xlink:href=\"" + button.getLink() + "\" target=\"" + win + "\">\n                   <use x=\"" + recXpos + "\" y=\"" + yPos + "\" xlink:href=\"#myCircle\" class=\"card\" fill=\"" + theme.buttonColor((Button)button) + "\">\n                        <title class=\"description\">" + StringFunctionsKt.escapeXml(button.getDescription()) + "</title>\n                   </use>\n                   </a>\n                "));
            sb.append(" \n                <a xlink:href=\"" + button.getLink() + "\" target=\"" + win + "\" style=\"fill: " + theme.buttonTextColor((Button)button) + "\" class=\"label\">\n                    <text x=\"" + recXpos + "\" y=\"" + (yPos + 5) + "\" text-anchor=\"middle\" >");
            lines = StringFunctionsKt.makeLines(button.getTitle());
            dy = 0;
            if (lines.size() > 2) {
                dy = -10 * (lines.size() - 2);
            }
            $this$forEachIndexed$iv2 = lines;
            $i$f$forEachIndexed2 = false;
            index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                if ((n = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                str = (String)item$iv2;
                i = n;
                boolean bl3 = false;
                if (i > 0) {
                    dy = 12;
                }
                sb.append("<tspan x=\"" + recXpos + "\" dy=\"" + dy + "\">" + StringFunctionsKt.escapeXml(str) + "</tspan>");
            }
            sb.append("</text>\n</a>");
        }
        sb.append("</g>");
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "sb.toString()");
        return string3;
    }

    private final String makeStyles() {
        return "\n        <style>\n        circle.card {\n            pointer-events: bounding-box;\n            opacity: 1;\n        }\n        circle.card:hover {\n            opacity: 0.6;\n        }\n        use.card {\n            pointer-events: bounding-box;\n            opacity: 1;\n        }\n        use.card:hover {\n            opacity: 0.6;\n        }\n        .subtitle {\n            font-family: \"Noto Sans\",sans-serif;\n            font-weight: normal;\n            font-size: 10px;\n        }\n        rect.legend {\n            pointer-events: bounding-box;\n            opacity: 1;\n        }\n\n        rect.legend:hover {\n            opacity: 0.6;\n        }\n        .label {\n            font-family: \"Noto Sans\",sans-serif;\n            font-size: 10px;\n        }\n    </style>\n    ";
    }
}

