/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoctorj.extension.panels;

import io.docops.asciidoc.buttons.dsl.PanelButton;
import io.docops.asciidoc.buttons.dsl.Panels;
import io.docops.asciidoc.buttons.dsl.PanelsKt;
import io.docops.asciidoc.buttons.service.PanelService;
import io.docops.asciidoc.buttons.service.ScriptLoader;
import io.docops.asciidoctorj.extension.panels.PanelsBlockProcessor;
import io.docops.asciidoctorj.extension.panels.PanelsBlockProcessor$process$;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.script.experimental.api.EvaluationResult;
import kotlin.script.experimental.api.KotlinType;
import kotlin.script.experimental.api.ResultValue;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.host.ConfigurationFromTemplateKt;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.host.StringScriptSource;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.script.experimental.jvm.util.DiagnosticsHelpersKt;
import kotlin.script.experimental.jvmhost.BasicJvmScriptingHost;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.ContentModel;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.Contexts;
import org.asciidoctor.extension.Name;
import org.asciidoctor.extension.Reader;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.jetbrains.annotations.NotNull;

@Name(value="panels")
@Contexts(value={":listing"})
@ContentModel(value=":compound")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0018H\u0016J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/docops/asciidoctorj/extension/panels/PanelsBlockProcessor;", "Lorg/asciidoctor/extension/BlockProcessor;", "()V", "scriptLoader", "Lio/docops/asciidoc/buttons/service/ScriptLoader;", "server", "", "compressString", "body", "createImageBlockFromString", "Lorg/asciidoctor/ast/Block;", "parent", "Lorg/asciidoctor/ast/StructuralNode;", "svg", "dslToLines", "", "dsl", "getSvg", "url", "process", "", "reader", "Lorg/asciidoctor/extension/Reader;", "attributes", "", "produceBlock", "filename", "serverPresent", "", "strToPanelButtons", "", "Lio/docops/asciidoc/buttons/dsl/PanelButton;", "str", "asciidoctorj-docops-panel"})
public final class PanelsBlockProcessor
extends BlockProcessor {
    @NotNull
    private ScriptLoader scriptLoader = new ScriptLoader();
    @NotNull
    private String server = "http://localhost:8010/extension";

    @NotNull
    public Object process(@NotNull StructuralNode parent2, @NotNull Reader reader, @NotNull Map<String, Object> attributes2) {
        Block block2;
        block20: {
            Intrinsics.checkNotNullParameter(parent2, "parent");
            Intrinsics.checkNotNullParameter(reader, "reader");
            Intrinsics.checkNotNullParameter(attributes2, "attributes");
            Object remoteServer = parent2.getDocument().getAttributes().get("panel-server");
            if (remoteServer != null) {
                String cfr_ignored_0 = (String)remoteServer;
                this.server = (String)remoteServer;
            }
            String content2 = reader.read();
            Object format = attributes2.getOrDefault("format", "dsl");
            String filename = (String)attributes2.getOrDefault("2", System.currentTimeMillis() + "_unk");
            Object object = parent2.getDocument().getAttribute((Object)"backend");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String backend = (String)object;
            Object object2 = parent2.getDocument().getAttribute((Object)"env", (Object)"");
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String idea = (String)object2;
            if (this.serverPresent(parent2)) {
                Block block3;
                String string2;
                this.log(new LogRecord(Severity.DEBUG, parent2.getSourceLocation(), "Server is present"));
                try {
                    Intrinsics.checkNotNullExpressionValue(content2, "content");
                    string2 = this.compressString(content2);
                }
                catch (Exception e) {
                    this.log(new LogRecord(Severity.ERROR, parent2.getSourceLocation(), e.getMessage()));
                    string2 = "";
                }
                String payload = string2;
                this.log(new LogRecord(Severity.DEBUG, parent2.getSourceLocation(), "payload compressed is " + payload));
                String isPdf = "HTML";
                if (Intrinsics.areEqual("pdf", backend)) {
                    isPdf = "PDF";
                } else if (Intrinsics.areEqual("idea", idea)) {
                    isPdf = "IDEA";
                }
                String url2 = Intrinsics.areEqual("csv", format) ? this.server + "/api/panel/csv?type=" + isPdf + "&data=" + payload : this.server + "/api/panel?type=" + isPdf + "&data=" + payload;
                this.log(new LogRecord(Severity.DEBUG, parent2.getSourceLocation(), "Url for request is " + url2));
                if (StringsKt.equals("html5", backend, true) || Intrinsics.areEqual("idea", idea)) {
                    String imageStr = this.getSvg(url2, parent2);
                    Block block4 = this.createBlock(parent2, "pass", imageStr);
                    block3 = block4;
                    Intrinsics.checkNotNullExpressionValue(block4, "{\n                // lan\u2026, imageStr)\n            }");
                } else {
                    block3 = this.produceBlock(url2, filename, parent2);
                }
                Block svgBlock = block3;
                Block pdfBlock = null;
                if (Intrinsics.areEqual("PDF", isPdf)) {
                    List<String> lines = this.dslToLines(payload, parent2);
                    pdfBlock = this.createBlock(parent2, "open", lines);
                }
                Map argAttributes = new HashMap();
                argAttributes.put("content_model", ":raw");
                Block block5 = this.createBlock(parent2, "open", "", argAttributes, new HashMap());
                Intrinsics.checkNotNullExpressionValue(block5, "createBlock(parent, \"ope\u2026tes, HashMap<Any, Any>())");
                Block block6 = block5;
                block6.getBlocks().add(svgBlock);
                Block block7 = pdfBlock;
                if (block7 != null) {
                    Block it = block7;
                    boolean bl = false;
                    this.parseContent((StructuralNode)block6, it.getLines());
                }
                return block6;
            }
            Panels panels2 = null;
            if (Intrinsics.areEqual("csv", format)) {
                panels2 = PanelsKt.panels((Function1<? super Panels, Unit>)new Function1<Panels, Unit>(this, content2){
                    final /* synthetic */ PanelsBlockProcessor this$0;
                    final /* synthetic */ String $content;
                    {
                        this.this$0 = $receiver;
                        this.$content = $content;
                        super(1);
                    }

                    public final void invoke(@NotNull Panels $this$panels) {
                        Intrinsics.checkNotNullParameter($this$panels, "$this$panels");
                        $this$panels.setColumns(3);
                        String string2 = this.$content;
                        Intrinsics.checkNotNullExpressionValue(string2, "content");
                        $this$panels.setPanelButtons(PanelsBlockProcessor.access$strToPanelButtons(this.this$0, string2));
                        $this$panels.theme(process.1.INSTANCE);
                    }
                });
            } else {
                Object object3;
                Object ret$iv;
                String source = StringsKt.trimIndent("\n            import io.docops.asciidoc.buttons.dsl.*\n            import io.docops.asciidoc.buttons.models.*\n            import io.docops.asciidoc.buttons.theme.*\n            import io.docops.asciidoc.buttons.*\n            \n            " + content2 + "\n        ");
                ScriptLoader this_$iv = this.scriptLoader;
                boolean $i$f$parseKotlinScript = false;
                Function1 body$iv$iv = process$$inlined$parseKotlinScript$1.INSTANCE;
                ScriptingHostConfiguration baseHostConfiguration$iv$iv = null;
                boolean $i$f$createJvmCompilationConfigurationFromTemplate = false;
                ScriptCompilationConfiguration compilationConfig$iv = ConfigurationFromTemplateKt.createCompilationConfigurationFromTemplate(new KotlinType(Reflection.getOrCreateKotlinClass(Object.class)), HostConfigurationKt.withDefaultsFrom(baseHostConfiguration$iv$iv, JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()), Reflection.getOrCreateKotlinClass(ScriptCompilationConfiguration.class), body$iv$iv);
                ResultWithDiagnostics<EvaluationResult> target$iv = new BasicJvmScriptingHost(null, null, null, 7, null).eval(new StringScriptSource(source, null, 2, null), compilationConfig$iv, null);
                if (!DiagnosticsHelpersKt.isError(target$iv)) {
                    EvaluationResult obj$iv = (EvaluationResult)((ResultWithDiagnostics.Success)target$iv).getValue();
                    object3 = ret$iv = ((ResultValue.Value)obj$iv.getReturnValue()).getValue();
                    if (object3 == null) {
                        throw new RuntimeException("Parsing source failed \n " + source);
                    }
                } else {
                    StringBuilder sb$iv = new StringBuilder();
                    Iterable $this$forEach$iv$iv = target$iv.getReports();
                    boolean $i$f$forEach = false;
                    for (Object element$iv$iv : $this$forEach$iv$iv) {
                        ScriptDiagnostic scriptDiagnostic$iv = (ScriptDiagnostic)element$iv$iv;
                        boolean bl = false;
                        sb$iv.append(scriptDiagnostic$iv.getMessage());
                    }
                    throw new RuntimeException(sb$iv.toString());
                }
                Object it$iv = object3;
                boolean bl = false;
                panels2 = (Panels)ret$iv;
            }
            PanelService panelService = new PanelService();
            Block pdfBlock = null;
            if (Intrinsics.areEqual("pdf", backend)) {
                panels2.setPdf(true);
                filename = filename + "_pdf";
                List<String> lines = panelService.toLines(filename, panels2);
                pdfBlock = this.createBlock(parent2, "open", lines);
            }
            String imgSrc = panelService.fromPanelToSvg(panels2);
            Map argAttributes = new HashMap();
            argAttributes.put("content_model", ":raw");
            Block block8 = this.createBlock(parent2, "open", "", argAttributes, new HashMap());
            Intrinsics.checkNotNullExpressionValue(block8, "createBlock(parent, \"ope\u2026tes, HashMap<Any, Any>())");
            block2 = block8;
            Block imgBlock = this.createImageBlockFromString(parent2, imgSrc);
            block2.getBlocks().add(imgBlock);
            Block block9 = pdfBlock;
            if (block9 == null) break block20;
            Block it = block9;
            boolean bl = false;
            this.parseContent((StructuralNode)block2, pdfBlock.getLines());
        }
        return block2;
    }

    private final Block produceBlock(String url2, String filename, StructuralNode parent2) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("role", "docops.io.panels"), TuplesKt.to("target", url2), TuplesKt.to("alt", "IMG not available"), TuplesKt.to("title", "Figure. " + filename), TuplesKt.to("opts", "interactive"), TuplesKt.to("format", "svg")};
        Map svgMap = MapsKt.mutableMapOf(pairArray);
        Block block2 = this.createBlock(parent2, "image", new ArrayList(), svgMap, new HashMap());
        Intrinsics.checkNotNullExpressionValue(block2, "this.createBlock(parent,\u2026ist(), svgMap, HashMap())");
        return block2;
    }

    private final Block createImageBlockFromString(StructuralNode parent2, String svg) {
        Block block2 = this.createBlock(parent2, "pass", svg);
        Intrinsics.checkNotNullExpressionValue(block2, "createBlock(parent, \"pass\", svg)");
        return block2;
    }

    private final List<PanelButton> strToPanelButtons(String str) {
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = StringsKt.lines(str);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"|"};
            List items2 = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
            PanelButton pb = new PanelButton();
            pb.setLabel(((Object)StringsKt.trim((CharSequence)((String)items2.get(0)))).toString());
            pb.setLink(((Object)StringsKt.trim((CharSequence)((String)items2.get(1)))).toString());
            if (items2.size() == 3) {
                pb.setDescription((String)items2.get(2));
            }
            result2.add(pb);
        }
        return result2;
    }

    private final boolean serverPresent(StructuralNode parent2) {
        boolean bl;
        System.out.println((Object)("Checking if server is present " + this.server + "/api/ping"));
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(20L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.server + "/api/ping")).timeout(Duration.ofMinutes(1L)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            bl = 200 == response.statusCode();
        }
        catch (Exception e) {
            this.log(new LogRecord(Severity.WARN, parent2.getSourceLocation(), e.getMessage()));
            bl = false;
        }
        return bl;
    }

    private final String getSvg(String url2, StructuralNode parent2) {
        String string2;
        System.out.println((Object)("getting image from url " + url2));
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(20L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url2)).timeout(Duration.ofMinutes(1L)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String string3 = response.body();
            Intrinsics.checkNotNullExpressionValue(string3, "{\n            val respon\u2026response.body()\n        }");
            string2 = string3;
        }
        catch (Exception e) {
            this.log(new LogRecord(Severity.ERROR, parent2.getSourceLocation(), e.getMessage()));
            string2 = "";
        }
        return string2;
    }

    private final List<String> dslToLines(String dsl, StructuralNode parent2) {
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.server + "/api/panel/lines?data=" + dsl)).timeout(Duration.ofSeconds(10L)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (200 == response.statusCode()) {
                String string2 = response.body();
                Intrinsics.checkNotNullExpressionValue(string2, "response.body()");
                return StringsKt.lines(string2);
            }
        }
        catch (Exception e) {
            this.log(new LogRecord(Severity.ERROR, parent2.getSourceLocation(), e.getMessage()));
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String compressString(String body2) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream zos = new GZIPOutputStream(baos);
        Closeable closeable = zos;
        Throwable throwable = null;
        try {
            GZIPOutputStream z = (GZIPOutputStream)closeable;
            boolean bl = false;
            byte[] byArray = body2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            z.write(byArray);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        byte[] bytes = baos.toByteArray();
        String string2 = Base64.getUrlEncoder().encodeToString(bytes);
        Intrinsics.checkNotNullExpressionValue(string2, "getUrlEncoder().encodeToString(bytes)");
        return string2;
    }

    public static final /* synthetic */ List access$strToPanelButtons(PanelsBlockProcessor $this, String str) {
        return $this.strToPanelButtons(str);
    }
}

