/*
 * Decompiled with CFR 0.152.
 */
package io.docops.extension.server.web;

import io.docops.asciidoc.buttons.dsl.Panels;
import io.docops.asciidoc.buttons.service.PanelService;
import io.docops.asciidoc.buttons.service.ScriptLoader;
import io.docops.asciidoc.buttons.theme.ButtonType;
import io.docops.extension.server.web.ExtensionsRouteKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nj\u0002`\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0012\u001a\u0016\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\b\u0012\u00060\nj\u0002`\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\tH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lio/docops/extension/server/web/ColorDivCreator;", "", "()V", "scriptLoader", "Lio/docops/asciidoc/buttons/service/ScriptLoader;", "getScriptLoader", "()Lio/docops/asciidoc/buttons/service/ScriptLoader;", "genPanelStr", "Lkotlin/Pair;", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "num", "", "buttonKind", "Lio/docops/asciidoc/buttons/theme/ButtonType;", "genPanels", "", "getColorMapAndPanels", "getRandomColor", "docops-extension-server"})
public final class ColorDivCreator {
    @NotNull
    private final ScriptLoader scriptLoader = new ScriptLoader();

    @NotNull
    public final ScriptLoader getScriptLoader() {
        return this.scriptLoader;
    }

    @NotNull
    public final byte[] genPanels(int num, @NotNull ButtonType buttonKind) {
        String results;
        Intrinsics.checkNotNullParameter((Object)buttonKind, "buttonKind");
        Pair<String, StringBuilder> panelStr = this.genPanelStr(num, buttonKind);
        Panels p = ExtensionsRouteKt.sourceToPanel(panelStr.getFirst(), this.scriptLoader);
        PanelService svc = new PanelService();
        String svg = svc.fromPanelToSvg(p);
        String string2 = results = StringsKt.trimIndent("\n            <div id='imageblock'>\n            " + svg + "\n            </div>\n            <br/>\n            <h3>Panel Source</h3>\n            <div class='contentBox'>\n            <pre>\n            <code>\n            " + panelStr.getFirst() + "\n            </code>\n            </pre>\n            </div>\n            <script>\n            var txt = `" + panelStr.getSecond() + "`;\n            var panelSource = `[panels]\\n----\\n" + panelStr.getFirst() + "\\n----`;\n            document.querySelectorAll('pre code').forEach((el) => {\n                hljs.highlightElement(el);\n            });\n            </script>\n        ");
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    private final String getRandomColor() {
        String letters = "0123456789ABCDEF";
        String color = "#";
        for (int i = 0; i < 6; ++i) {
            color = color + letters.charAt((int)Math.floor(Math.random() * (double)16));
        }
        return color;
    }

    @NotNull
    public final Pair<String, StringBuilder> genPanelStr(int num, @NotNull ButtonType buttonKind) {
        Intrinsics.checkNotNullParameter((Object)buttonKind, "buttonKind");
        StringBuilder str = new StringBuilder();
        str.append("panels{\n");
        Pair<StringBuilder, StringBuilder> panelMap = this.getColorMapAndPanels(num, buttonKind);
        str.append(StringsKt.trimIndent("\n    theme {\n    " + panelMap.getSecond() + "\n        legendOn = false\n        layout {\n            columns = 4\n        }\n    }\n    "));
        str.append((CharSequence)panelMap.getFirst());
        str.append("\n}");
        String string2 = str.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "str.toString()");
        return new Pair<String, StringBuilder>(string2, panelMap.getSecond());
    }

    private final Pair<StringBuilder, StringBuilder> getColorMapAndPanels(int num, ButtonType buttonKind) {
        String type2 = "panel";
        if (buttonKind == ButtonType.ROUND) {
            type2 = "round";
        } else if (buttonKind == ButtonType.SLIM_CARD) {
            type2 = "slim";
        }
        StringBuilder panels2 = new StringBuilder();
        StringBuilder str = new StringBuilder("colorMap {\n");
        for (int x = 0; x < num; ++x) {
            String color = this.getRandomColor();
            str.append("\tcolor(\"" + color + "\")\n");
            panels2.append("\n\t" + type2 + "{\n");
            panels2.append("\t\tlink = \"https://www.apple.com\"\n");
            panels2.append("\t\tlabel = \"" + color + "\"\n");
            panels2.append("\t}");
        }
        str.append("}");
        return new Pair<StringBuilder, StringBuilder>(panels2, str);
    }
}

