/*
 * Decompiled with CFR 0.152.
 */
package io.docops.extension.server.web;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\r"}, d2={"Lio/docops/extension/server/web/CompressionUtil;", "", "()V", "compress", "", "bArray", "text", "", "compressAndReturnB64", "decompress", "compressedTxt", "decompressB64", "b64Compressed", "docops-extension-server"})
public final class CompressionUtil {
    @NotNull
    public static final CompressionUtil INSTANCE = new CompressionUtil();

    private CompressionUtil() {
    }

    @NotNull
    public final String compressAndReturnB64(@NotNull String text2) throws IOException {
        Intrinsics.checkNotNullParameter(text2, "text");
        byte[] byArray = Base64.getUrlEncoder().encode(this.compress(text2));
        Intrinsics.checkNotNullExpressionValue(byArray, "getUrlEncoder().encode(compress(text))");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }

    @NotNull
    public final String decompressB64(@Nullable String b64Compressed) throws IOException {
        byte[] decompressedBArray = this.decompress(Base64.getUrlDecoder().decode(b64Compressed));
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        Charset charset2 = charset;
        return new String(decompressedBArray, charset2);
    }

    @NotNull
    public final byte[] compress(@NotNull String text2) throws IOException {
        Intrinsics.checkNotNullParameter(text2, "text");
        String string2 = text2;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return this.compress(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] compress(@Nullable byte[] bArray) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Closeable closeable = new DeflaterOutputStream(os);
        Throwable throwable = null;
        try {
            DeflaterOutputStream dos = (DeflaterOutputStream)closeable;
            boolean bl = false;
            dos.write(bArray);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "os.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] decompress(@Nullable byte[] compressedTxt) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Closeable closeable = new InflaterOutputStream(os);
        Throwable throwable = null;
        try {
            InflaterOutputStream ios = (InflaterOutputStream)closeable;
            boolean bl = false;
            ios.write(compressedTxt);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "os.toByteArray()");
        return byArray;
    }
}

