/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CodecsKt;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.auth.HeaderValueEncoding;
import io.ktor.http.auth.HttpAuthHeaderKt;
import io.ktor.http.parsing.ParseException;
import io.ktor.util.CryptoKt;
import io.ktor.util.Hash;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/auth/HttpAuthHeader;", "", "authScheme", "", "(Ljava/lang/String;)V", "getAuthScheme", "()Ljava/lang/String;", "render", "encoding", "Lio/ktor/http/auth/HeaderValueEncoding;", "toString", "Companion", "Parameterized", "Parameters", "Single", "Lio/ktor/http/auth/HttpAuthHeader$Single;", "Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "ktor-http"})
public abstract class HttpAuthHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String authScheme;

    private HttpAuthHeader(String authScheme) {
        this.authScheme = authScheme;
        CharSequence charSequence2 = this.authScheme;
        if (!HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence2)) {
            throw new ParseException("Invalid authScheme value: it should be token, but instead it is " + this.authScheme, null, 2, null);
        }
    }

    @NotNull
    public final String getAuthScheme() {
        return this.authScheme;
    }

    @NotNull
    public abstract String render(@NotNull HeaderValueEncoding var1);

    @NotNull
    public abstract String render();

    @NotNull
    public String toString() {
        return this.render();
    }

    public /* synthetic */ HttpAuthHeader(String authScheme, DefaultConstructorMarker $constructor_marker) {
        this(authScheme);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Single;", "Lio/ktor/http/auth/HttpAuthHeader;", "authScheme", "", "blob", "(Ljava/lang/String;Ljava/lang/String;)V", "getBlob", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "render", "encoding", "Lio/ktor/http/auth/HeaderValueEncoding;", "ktor-http"})
    public static final class Single
    extends HttpAuthHeader {
        @NotNull
        private final String blob;

        public Single(@NotNull String authScheme, @NotNull String blob) {
            Intrinsics.checkNotNullParameter(authScheme, "authScheme");
            Intrinsics.checkNotNullParameter(blob, "blob");
            super(authScheme, null);
            this.blob = blob;
            CharSequence charSequence2 = this.blob;
            if (!HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence2)) {
                throw new ParseException("Invalid blob value: it should be token68, but instead it is " + this.blob, null, 2, null);
            }
        }

        @NotNull
        public final String getBlob() {
            return this.blob;
        }

        @Override
        @NotNull
        public String render() {
            return this.getAuthScheme() + ' ' + this.blob;
        }

        @Override
        @NotNull
        public String render(@NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            return this.render();
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Single)) {
                return false;
            }
            return StringsKt.equals(((Single)other).getAuthScheme(), this.getAuthScheme(), true) && StringsKt.equals(((Single)other).blob, this.blob, true);
        }

        public int hashCode() {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue(this.getAuthScheme().toLowerCase(Locale.ROOT), "this as java.lang.String).toLowerCase(Locale.ROOT)");
            Intrinsics.checkNotNullExpressionValue(this.blob.toLowerCase(Locale.ROOT), "this as java.lang.String).toLowerCase(Locale.ROOT)");
            return Hash.INSTANCE.combine(objectArray);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u0014\u0010\u001c\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "Lio/ktor/http/auth/HttpAuthHeader;", "authScheme", "", "parameters", "", "encoding", "Lio/ktor/http/auth/HeaderValueEncoding;", "(Ljava/lang/String;Ljava/util/Map;Lio/ktor/http/auth/HeaderValueEncoding;)V", "", "Lio/ktor/http/HeaderValueParam;", "(Ljava/lang/String;Ljava/util/List;Lio/ktor/http/auth/HeaderValueEncoding;)V", "getEncoding", "()Lio/ktor/http/auth/HeaderValueEncoding;", "getParameters", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "parameter", "name", "render", "withParameter", "value", "withReplacedParameter", "encode", "ktor-http"})
    public static final class Parameterized
    extends HttpAuthHeader {
        @NotNull
        private final List<HeaderValueParam> parameters;
        @NotNull
        private final HeaderValueEncoding encoding;

        public Parameterized(@NotNull String authScheme, @NotNull List<HeaderValueParam> parameters2, @NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkNotNullParameter(authScheme, "authScheme");
            Intrinsics.checkNotNullParameter(parameters2, "parameters");
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            super(authScheme, null);
            this.parameters = parameters2;
            this.encoding = encoding;
            Iterable $this$forEach$iv = this.parameters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HeaderValueParam it = (HeaderValueParam)element$iv;
                boolean bl = false;
                CharSequence charSequence2 = it.getName();
                if (HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence2)) continue;
                throw new ParseException("parameter name should be a token but it is " + it.getName(), null, 2, null);
            }
        }

        public /* synthetic */ Parameterized(String string2, List list2, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string2, list2, headerValueEncoding);
        }

        @NotNull
        public final List<HeaderValueParam> getParameters() {
            return this.parameters;
        }

        @NotNull
        public final HeaderValueEncoding getEncoding() {
            return this.encoding;
        }

        /*
         * WARNING - void declaration
         */
        public Parameterized(@NotNull String authScheme, @NotNull Map<String, String> parameters2, @NotNull HeaderValueEncoding encoding) {
            Collection<HeaderValueParam> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(authScheme, "authScheme");
            Intrinsics.checkNotNullParameter(parameters2, "parameters");
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            Iterable iterable = parameters2.entrySet();
            String string2 = authScheme;
            Parameterized parameterized = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new HeaderValueParam((String)it.getKey(), (String)it.getValue()));
            }
            collection = (List)destination$iv$iv;
            parameterized(string2, (List<HeaderValueParam>)collection, encoding);
        }

        public /* synthetic */ Parameterized(String string2, Map map2, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string2, map2, headerValueEncoding);
        }

        @NotNull
        public final Parameterized withParameter(@NotNull String name2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(value2, "value");
            return new Parameterized(this.getAuthScheme(), CollectionsKt.plus((Collection)this.parameters, new HeaderValueParam(name2, value2)), this.encoding);
        }

        @NotNull
        public final Parameterized withReplacedParameter(@NotNull String name2, @NotNull String value2) {
            int firstIndex;
            block8: {
                int n;
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(value2, "value");
                List<HeaderValueParam> $this$indexOfFirst$iv = this.parameters;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<HeaderValueParam> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    HeaderValueParam headerValueParam;
                    HeaderValueParam it = headerValueParam = iterator2.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual(it.getName(), name2)) {
                        n = index$iv;
                        break block8;
                    }
                    ++index$iv;
                }
                n = firstIndex = -1;
            }
            if (firstIndex == -1) {
                return this.withParameter(name2, value2);
            }
            boolean replaced = false;
            Iterable $this$mapNotNull$iv = this.parameters;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                HeaderValueParam headerValueParam;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                HeaderValueParam it = (HeaderValueParam)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getName(), name2)) {
                    headerValueParam = it;
                } else if (!replaced) {
                    replaced = true;
                    headerValueParam = new HeaderValueParam(name2, value2);
                } else {
                    headerValueParam = null;
                }
                if (headerValueParam == null) continue;
                HeaderValueParam it$iv$iv = headerValueParam;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List newParameters = (List)destination$iv$iv;
            return new Parameterized(this.getAuthScheme(), newParameters, this.encoding);
        }

        @Override
        @NotNull
        public String render(@NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            return CollectionsKt.joinToString$default(this.parameters, ", ", this.getAuthScheme() + ' ', null, 0, null, new Function1<HeaderValueParam, CharSequence>(this, encoding){
                final /* synthetic */ Parameterized this$0;
                final /* synthetic */ HeaderValueEncoding $encoding;
                {
                    this.this$0 = $receiver;
                    this.$encoding = $encoding;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull HeaderValueParam it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getName() + '=' + Parameterized.access$encode(this.this$0, it.getValue(), this.$encoding);
                }
            }, 28, null);
        }

        @Nullable
        public final String parameter(@NotNull String name2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(name2, "name");
                Iterable $this$firstOrNull$iv = this.parameters;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HeaderValueParam it = (HeaderValueParam)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), name2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            HeaderValueParam headerValueParam = v0;
            return headerValueParam != null ? headerValueParam.getValue() : null;
        }

        private final String encode(String $this$encode, HeaderValueEncoding encoding) {
            String string2;
            switch (WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
                case 1: {
                    string2 = HeaderValueWithParametersKt.escapeIfNeeded($this$encode);
                    break;
                }
                case 2: {
                    string2 = HeaderValueWithParametersKt.quote($this$encode);
                    break;
                }
                case 3: {
                    string2 = CodecsKt.encodeURLParameter$default($this$encode, false, 1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string2;
        }

        @Override
        @NotNull
        public String render() {
            return this.render(this.encoding);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Parameterized)) {
                return false;
            }
            return StringsKt.equals(((Parameterized)other).getAuthScheme(), this.getAuthScheme(), true) && Intrinsics.areEqual(((Parameterized)other).parameters, this.parameters);
        }

        public int hashCode() {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue(this.getAuthScheme().toLowerCase(Locale.ROOT), "this as java.lang.String).toLowerCase(Locale.ROOT)");
            objectArray[1] = this.parameters;
            return Hash.INSTANCE.combine(objectArray);
        }

        public static final /* synthetic */ String access$encode(Parameterized $this, String $receiver, HeaderValueEncoding encoding) {
            return $this.encode($receiver, encoding);
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HeaderValueEncoding.values().length];
                nArray[HeaderValueEncoding.QUOTED_WHEN_REQUIRED.ordinal()] = 1;
                nArray[HeaderValueEncoding.QUOTED_ALWAYS.ordinal()] = 2;
                nArray[HeaderValueEncoding.URI_ENCODE.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tJO\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Companion;", "", "()V", "basicAuthChallenge", "Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "realm", "", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "digestAuthChallenge", "nonce", "domain", "", "opaque", "stale", "", "algorithm", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Parameterized basicAuthChallenge(@NotNull String realm, @Nullable Charset charset) {
            void $this$basicAuthChallenge_u24lambda_u2d0;
            LinkedHashMap linkedHashMap;
            Intrinsics.checkNotNullParameter(realm, "realm");
            LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
            String string2 = "Basic";
            boolean bl = false;
            $this$basicAuthChallenge_u24lambda_u2d0.put("realm", realm);
            if (charset != null) {
                $this$basicAuthChallenge_u24lambda_u2d0.put("charset", CharsetJVMKt.getName(charset));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            HeaderValueEncoding headerValueEncoding = null;
            Map map2 = linkedHashMap;
            String string3 = string2;
            return new Parameterized(string3, map2, headerValueEncoding, n, defaultConstructorMarker);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Parameterized digestAuthChallenge(@NotNull String realm, @NotNull String nonce, @NotNull List<String> domain, @Nullable String opaque, @Nullable Boolean stale, @NotNull String algorithm) {
            void $this$digestAuthChallenge_u24lambda_u2d1;
            LinkedHashMap linkedHashMap;
            Intrinsics.checkNotNullParameter(realm, "realm");
            Intrinsics.checkNotNullParameter(nonce, "nonce");
            Intrinsics.checkNotNullParameter(domain, "domain");
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
            String string2 = "Digest";
            boolean bl = false;
            $this$digestAuthChallenge_u24lambda_u2d1.put("realm", realm);
            $this$digestAuthChallenge_u24lambda_u2d1.put("nonce", nonce);
            if (!((Collection)domain).isEmpty()) {
                $this$digestAuthChallenge_u24lambda_u2d1.put("domain", CollectionsKt.joinToString$default(domain, " ", null, null, 0, null, null, 62, null));
            }
            if (opaque != null) {
                $this$digestAuthChallenge_u24lambda_u2d1.put("opaque", opaque);
            }
            if (stale != null) {
                $this$digestAuthChallenge_u24lambda_u2d1.put("stale", stale.toString());
            }
            $this$digestAuthChallenge_u24lambda_u2d1.put("algorithm", algorithm);
            HeaderValueEncoding headerValueEncoding = HeaderValueEncoding.QUOTED_ALWAYS;
            Map map2 = linkedHashMap;
            String string3 = string2;
            return new Parameterized(string3, map2, headerValueEncoding);
        }

        public static /* synthetic */ Parameterized digestAuthChallenge$default(Companion companion, String string2, String string3, List list2, String string4, Boolean bl, String string5, int n, Object object) {
            if ((n & 2) != 0) {
                string3 = CryptoKt.generateNonce();
            }
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                bl = null;
            }
            if ((n & 0x20) != 0) {
                string5 = "MD5";
            }
            return companion.digestAuthChallenge(string2, string3, list2, string4, bl, string5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Parameters;", "", "()V", "Charset", "", "OAuthCallback", "OAuthCallbackConfirmed", "OAuthConsumerKey", "OAuthNonce", "OAuthSignature", "OAuthSignatureMethod", "OAuthTimestamp", "OAuthToken", "OAuthTokenSecret", "OAuthVerifier", "OAuthVersion", "Realm", "ktor-http"})
    public static final class Parameters {
        @NotNull
        public static final Parameters INSTANCE = new Parameters();
        @NotNull
        public static final String Realm = "realm";
        @NotNull
        public static final String Charset = "charset";
        @NotNull
        public static final String OAuthCallback = "oauth_callback";
        @NotNull
        public static final String OAuthConsumerKey = "oauth_consumer_key";
        @NotNull
        public static final String OAuthNonce = "oauth_nonce";
        @NotNull
        public static final String OAuthToken = "oauth_token";
        @NotNull
        public static final String OAuthTokenSecret = "oauth_token_secret";
        @NotNull
        public static final String OAuthVerifier = "oauth_verifier";
        @NotNull
        public static final String OAuthSignatureMethod = "oauth_signature_method";
        @NotNull
        public static final String OAuthTimestamp = "oauth_timestamp";
        @NotNull
        public static final String OAuthVersion = "oauth_version";
        @NotNull
        public static final String OAuthSignature = "oauth_signature";
        @NotNull
        public static final String OAuthCallbackConfirmed = "oauth_callback_confirmed";

        private Parameters() {
        }
    }
}

