/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CookieUtilsKt;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.http.auth.HttpAuthHeaderKt;
import io.ktor.http.parsing.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\rH\u0002\u001a$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0002H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0014*\u00020\u0002H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\f\u0010\u0019\u001a\u00020\n*\u00020\nH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"TOKEN68_EXTRA", "", "", "TOKEN_EXTRA", "escapeRegex", "Lkotlin/text/Regex;", "token68Pattern", "matchParameter", "", "headerValue", "", "startIndex", "parameters", "", "matchParameters", "", "matchToken68", "parseAuthorizationHeader", "Lio/ktor/http/auth/HttpAuthHeader;", "isToken", "", "isToken68", "skipDelimiter", "delimiter", "skipSpaces", "unescaped", "ktor-http"})
public final class HttpAuthHeaderKt {
    @NotNull
    private static final Set<Character> TOKEN_EXTRA;
    @NotNull
    private static final Set<Character> TOKEN68_EXTRA;
    @NotNull
    private static final Regex token68Pattern;
    @NotNull
    private static final Regex escapeRegex;

    @Nullable
    public static final HttpAuthHeader parseAuthorizationHeader(@NotNull String headerValue) {
        Intrinsics.checkNotNullParameter(headerValue, "headerValue");
        int index2 = 0;
        int tokenStartIndex = index2 = HttpAuthHeaderKt.skipSpaces(headerValue, index2);
        while (index2 < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index2))) {
            ++index2;
        }
        String authScheme = StringsKt.substring(headerValue, RangesKt.until(tokenStartIndex, index2));
        tokenStartIndex = index2 = HttpAuthHeaderKt.skipSpaces(headerValue, index2);
        if (StringsKt.isBlank(authScheme)) {
            return null;
        }
        if (headerValue.length() == index2) {
            return new HttpAuthHeader.Parameterized(authScheme, CollectionsKt.emptyList(), null, 4, null);
        }
        String token68 = HttpAuthHeaderKt.matchToken68(headerValue, index2);
        if (token68 != null) {
            return new HttpAuthHeader.Single(authScheme, token68);
        }
        Map<String, String> parameters2 = HttpAuthHeaderKt.matchParameters(headerValue, tokenStartIndex);
        return new HttpAuthHeader.Parameterized(authScheme, parameters2, null, 4, null);
    }

    private static final Map<String, String> matchParameters(String headerValue, int startIndex) {
        Map result2 = new LinkedHashMap();
        int index2 = startIndex;
        while (index2 > 0 && index2 < headerValue.length()) {
            index2 = HttpAuthHeaderKt.matchParameter(headerValue, index2, result2);
            index2 = HttpAuthHeaderKt.skipDelimiter(headerValue, index2, ',');
        }
        return result2;
    }

    private static final int matchParameter(String headerValue, int startIndex, Map<String, String> parameters2) {
        int keyStart;
        int index2;
        for (index2 = keyStart = HttpAuthHeaderKt.skipSpaces(headerValue, startIndex); index2 < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index2)); ++index2) {
        }
        String key = StringsKt.substring(headerValue, RangesKt.until(keyStart, index2));
        if ((index2 = HttpAuthHeaderKt.skipSpaces(headerValue, index2)) >= headerValue.length() || headerValue.charAt(index2) != '=') {
            throw new ParseException("Expected `=` after parameter key '" + key + "': " + headerValue, null, 2, null);
        }
        ++index2;
        boolean quoted = false;
        int valueStart = index2;
        if (headerValue.charAt(index2) == '\"') {
            quoted = true;
            valueStart = ++index2;
            boolean escaped = false;
            while (index2 < headerValue.length() && (headerValue.charAt(index2) != '\"' || escaped)) {
                escaped = !escaped && headerValue.charAt(index2) == '\\';
                ++index2;
            }
            if (index2 == headerValue.length()) {
                throw new ParseException("Expected closing quote'\"' in parameter: " + headerValue + ' ', null, 2, null);
            }
        } else {
            for (index2 = HttpAuthHeaderKt.skipSpaces(headerValue, index2); index2 < headerValue.length() && headerValue.charAt(index2) != ' ' && headerValue.charAt(index2) != ','; ++index2) {
            }
        }
        String value2 = StringsKt.substring(headerValue, RangesKt.until(valueStart, index2));
        parameters2.put(key, quoted ? HttpAuthHeaderKt.unescaped(value2) : value2);
        if (quoted) {
            ++index2;
        }
        return index2;
    }

    private static final String matchToken68(String headerValue, int startIndex) {
        boolean onlySpaceRemaining;
        int index2;
        block6: {
            boolean bl;
            for (index2 = startIndex; index2 < headerValue.length() && HttpAuthHeaderKt.isToken68(headerValue.charAt(index2)); ++index2) {
            }
            while (index2 < headerValue.length() && headerValue.charAt(index2) == '=') {
                ++index2;
            }
            Iterable $this$all$iv = RangesKt.until(index2, headerValue.length());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (headerValue.charAt(it) == ' ') continue;
                    bl = false;
                    break block6;
                }
                bl = onlySpaceRemaining = true;
            }
        }
        if (onlySpaceRemaining) {
            return StringsKt.substring(headerValue, RangesKt.until(startIndex, index2));
        }
        return null;
    }

    private static final String unescaped(String $this$unescaped) {
        CharSequence charSequence2 = $this$unescaped;
        Regex regex = escapeRegex;
        Function1 function1 = unescaped.1.INSTANCE;
        return regex.replace(charSequence2, function1);
    }

    private static final int skipDelimiter(String $this$skipDelimiter, int startIndex, char delimiter) {
        int index2;
        for (index2 = HttpAuthHeaderKt.skipSpaces($this$skipDelimiter, startIndex); index2 < $this$skipDelimiter.length() && $this$skipDelimiter.charAt(index2) != delimiter; ++index2) {
        }
        if (index2 == $this$skipDelimiter.length()) {
            return -1;
        }
        return HttpAuthHeaderKt.skipSpaces($this$skipDelimiter, ++index2);
    }

    private static final int skipSpaces(String $this$skipSpaces, int startIndex) {
        int index2;
        for (index2 = startIndex; index2 < $this$skipSpaces.length() && $this$skipSpaces.charAt(index2) == ' '; ++index2) {
        }
        return index2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToken68(char $this$isToken68) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isToken68) {
            if ($this$isToken68 < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isToken68) {
            if ($this$isToken68 < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (CookieUtilsKt.isDigit($this$isToken68)) return true;
        if (!TOKEN68_EXTRA.contains(Character.valueOf($this$isToken68))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToken(char $this$isToken) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isToken) {
            if ($this$isToken < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isToken) {
            if ($this$isToken < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (CookieUtilsKt.isDigit($this$isToken)) return true;
        if (!TOKEN_EXTRA.contains(Character.valueOf($this$isToken))) return false;
        return true;
    }

    public static final /* synthetic */ Regex access$getToken68Pattern$p() {
        return token68Pattern;
    }

    static {
        Character[] characterArray = new Character[]{Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~')};
        TOKEN_EXTRA = SetsKt.setOf(characterArray);
        characterArray = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('+'), Character.valueOf('/')};
        TOKEN68_EXTRA = SetsKt.setOf(characterArray);
        token68Pattern = new Regex("[a-zA-Z0-9\\-._~+/]+=*");
        escapeRegex = new Regex("\\\\.");
    }
}

