/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.HttpHeadersMapKt;
import io.ktor.http.cio.internals.CharArrayBuilder;
import io.ktor.http.cio.internals.CharsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\bJ\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\bJ6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bJ\u0006\u0010\u001e\u001a\u00020\u0017J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lio/ktor/http/cio/HttpHeadersMap;", "", "builder", "Lio/ktor/http/cio/internals/CharArrayBuilder;", "(Lio/ktor/http/cio/internals/CharArrayBuilder;)V", "indexes", "", "<set-?>", "", "size", "getSize", "()I", "find", "name", "", "fromIndex", "get", "", "getAll", "Lkotlin/sequences/Sequence;", "nameAt", "idx", "put", "", "nameHash", "valueHash", "nameStartIndex", "nameEndIndex", "valueStartIndex", "valueEndIndex", "release", "toString", "valueAt", "ktor-http-cio"})
public final class HttpHeadersMap {
    @NotNull
    private final CharArrayBuilder builder;
    private int size;
    @NotNull
    private int[] indexes;

    public HttpHeadersMap(@NotNull CharArrayBuilder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        this.builder = builder2;
        this.indexes = (int[])HttpHeadersMapKt.access$getIntArrayPool$p().borrow();
    }

    public final int getSize() {
        return this.size;
    }

    public final void put(int nameHash, int valueHash, int nameStartIndex, int nameEndIndex, int valueStartIndex, int valueEndIndex) {
        int base2 = this.size * 8;
        int[] array2 = this.indexes;
        if (base2 >= this.indexes.length) {
            String string2 = "Implement headers overflow";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        array2[base2 + 0] = nameHash;
        array2[base2 + 1] = valueHash;
        array2[base2 + 2] = nameStartIndex;
        array2[base2 + 3] = nameEndIndex;
        array2[base2 + 4] = valueStartIndex;
        array2[base2 + 5] = valueEndIndex;
        array2[base2 + 6] = -1;
        array2[base2 + 7] = -1;
        int n = this.size;
        this.size = n + 1;
    }

    public final int find(@NotNull String name2, int fromIndex) {
        Intrinsics.checkNotNullParameter(name2, "name");
        int nameHash = CharsKt.hashCodeLowerCase$default(name2, 0, 0, 3, null);
        int n = this.size;
        for (int i = fromIndex; i < n; ++i) {
            int offset2 = i * 8;
            if (this.indexes[offset2] != nameHash) continue;
            return i;
        }
        return -1;
    }

    public static /* synthetic */ int find$default(HttpHeadersMap httpHeadersMap, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return httpHeadersMap.find(string2, n);
    }

    @Nullable
    public final CharSequence get(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        int nameHash = CharsKt.hashCodeLowerCase$default(name2, 0, 0, 3, null);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            int offset2 = i * 8;
            if (this.indexes[offset2] != nameHash) continue;
            return this.builder.subSequence(this.indexes[offset2 + 4], this.indexes[offset2 + 5]);
        }
        return null;
    }

    @NotNull
    public final Sequence<CharSequence> getAll(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        int nameHash = CharsKt.hashCodeLowerCase$default(name2, 0, 0, 3, null);
        return SequencesKt.map(SequencesKt.filter(SequencesKt.map(SequencesKt.generateSequence(0, (Function1)new Function1<Integer, Integer>(this){
            final /* synthetic */ HttpHeadersMap this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Integer invoke(int it) {
                return it + 1 >= this.this$0.getSize() ? null : Integer.valueOf(it + 1);
            }
        }), getAll.2.INSTANCE), (Function1)new Function1<Integer, Boolean>(this, nameHash){
            final /* synthetic */ HttpHeadersMap this$0;
            final /* synthetic */ int $nameHash;
            {
                this.this$0 = $receiver;
                this.$nameHash = $nameHash;
                super(1);
            }

            @NotNull
            public final Boolean invoke(int it) {
                return HttpHeadersMap.access$getIndexes$p(this.this$0)[it] == this.$nameHash;
            }
        }), (Function1)new Function1<Integer, CharSequence>(this){
            final /* synthetic */ HttpHeadersMap this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(int it) {
                return HttpHeadersMap.access$getBuilder$p(this.this$0).subSequence(HttpHeadersMap.access$getIndexes$p(this.this$0)[it + 4], HttpHeadersMap.access$getIndexes$p(this.this$0)[it + 5]);
            }
        });
    }

    @NotNull
    public final CharSequence nameAt(int idx) {
        if (!(idx >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(idx < this.size)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        int offset2 = idx * 8;
        int[] array2 = this.indexes;
        int nameStart = array2[offset2 + 2];
        int nameEnd = array2[offset2 + 3];
        return this.builder.subSequence(nameStart, nameEnd);
    }

    @NotNull
    public final CharSequence valueAt(int idx) {
        if (!(idx >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(idx < this.size)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        int offset2 = idx * 8;
        int[] array2 = this.indexes;
        int nameStart = array2[offset2 + 4];
        int nameEnd = array2[offset2 + 5];
        return this.builder.subSequence(nameStart, nameEnd);
    }

    public final void release() {
        this.size = 0;
        int[] indexes2 = this.indexes;
        this.indexes = HttpHeadersMapKt.access$getEMPTY_INT_LIST$p();
        if (indexes2 != HttpHeadersMapKt.access$getEMPTY_INT_LIST$p()) {
            HttpHeadersMapKt.access$getIntArrayPool$p().recycle(indexes2);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder2;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        HttpHeadersMapKt.dumpTo(this, "", $this$toString_u24lambda_u2d0);
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static final /* synthetic */ int[] access$getIndexes$p(HttpHeadersMap $this) {
        return $this.indexes;
    }

    public static final /* synthetic */ CharArrayBuilder access$getBuilder$p(HttpHeadersMap $this) {
        return $this.builder;
    }
}

