/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.selector;

import io.ktor.network.selector.InterestSuspensionsMap;
import io.ktor.network.selector.SelectInterest;
import io.ktor.network.selector.Selectable;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.selector.SelectorManagerSupport;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0004J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0004J\u001a\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0004J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0013H\u0004J$\u0010#\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'H\u0004J \u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0011H\u0004J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0011H$J!\u0010*\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010+\u001a\u00020,H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR,\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport;", "Lio/ktor/network/selector/SelectorManager;", "()V", "cancelled", "", "getCancelled", "()I", "setCancelled", "(I)V", "pending", "getPending", "setPending", "provider", "Ljava/nio/channels/spi/SelectorProvider;", "getProvider", "()Ljava/nio/channels/spi/SelectorProvider;", "newValue", "Lio/ktor/network/selector/Selectable;", "subject", "Ljava/nio/channels/SelectionKey;", "getSubject", "(Ljava/nio/channels/SelectionKey;)Lio/ktor/network/selector/Selectable;", "setSubject", "(Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "applyInterest", "", "selector", "Ljava/nio/channels/Selector;", "selectable", "cancelAllSuspensions", "attachment", "cause", "", "handleSelectedKey", "key", "handleSelectedKeys", "selectedKeys", "", "keys", "", "notifyClosedImpl", "publishInterest", "select", "interest", "Lio/ktor/network/selector/SelectInterest;", "(Lio/ktor/network/selector/Selectable;Lio/ktor/network/selector/SelectInterest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ClosedSelectorCancellationException", "ktor-network"})
public abstract class SelectorManagerSupport
implements SelectorManager {
    @NotNull
    private final SelectorProvider provider;
    private int pending;
    private int cancelled;

    public SelectorManagerSupport() {
        SelectorProvider selectorProvider = SelectorProvider.provider();
        Intrinsics.checkNotNullExpressionValue(selectorProvider, "provider()");
        this.provider = selectorProvider;
    }

    @Override
    @NotNull
    public final SelectorProvider getProvider() {
        return this.provider;
    }

    protected final int getPending() {
        return this.pending;
    }

    protected final void setPending(int n) {
        this.pending = n;
    }

    protected final int getCancelled() {
        return this.cancelled;
    }

    protected final void setCancelled(int n) {
        this.cancelled = n;
    }

    protected abstract void publishInterest(@NotNull Selectable var1);

    @Override
    @Nullable
    public final Object select(@NotNull Selectable selectable, @NotNull SelectInterest interest, @NotNull Continuation<? super Unit> $completion) {
        int flag;
        int interestedOps = selectable.getInterestedOps();
        if ((interestedOps & (flag = interest.getFlag())) == 0) {
            String message = selectable.isClosed() ? "Selectable is closed" : "Selectable is invalid state: " + interestedOps + ", " + flag;
            throw new IllegalArgumentException(message);
        }
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl<? super Unit> cancellable$iv = new CancellableContinuationImpl<Unit>(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation2 = cancellable$iv;
        boolean bl2 = false;
        continuation2.invokeOnCancellation(select.2.1.INSTANCE);
        selectable.getSuspensions().addSuspension(interest, continuation2);
        if (!continuation2.isCancelled()) {
            this.publishInterest(selectable);
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected final void handleSelectedKeys(@NotNull Set<SelectionKey> selectedKeys, @NotNull Set<? extends SelectionKey> keys2) {
        Intrinsics.checkNotNullParameter(selectedKeys, "selectedKeys");
        Intrinsics.checkNotNullParameter(keys2, "keys");
        int selectedCount = selectedKeys.size();
        this.pending = keys2.size() - selectedCount;
        this.cancelled = 0;
        if (selectedCount > 0) {
            Iterator<SelectionKey> iter = selectedKeys.iterator();
            while (iter.hasNext()) {
                SelectionKey k = iter.next();
                this.handleSelectedKey(k);
                iter.remove();
            }
        }
    }

    protected final void handleSelectedKey(@NotNull SelectionKey key) {
        block5: {
            Intrinsics.checkNotNullParameter(key, "key");
            try {
                int readyOps = key.readyOps();
                int interestOps = key.interestOps();
                Selectable subject = this.getSubject(key);
                if (subject == null) {
                    key.cancel();
                    int n = this.cancelled;
                    this.cancelled = n + 1;
                    break block5;
                }
                InterestSuspensionsMap this_$iv = subject.getSuspensions();
                int $i$f$invokeForEachPresent = 0;
                int[] flags$iv = SelectInterest.Companion.getFlags();
                int n = flags$iv.length;
                for (int ordinal$iv = 0; ordinal$iv < n; ++ordinal$iv) {
                    CancellableContinuation<Unit> $this$handleSelectedKey_u24lambda_u2d1;
                    if ((flags$iv[ordinal$iv] & readyOps) == 0 || this_$iv.removeSuspension(ordinal$iv) == null) continue;
                    boolean bl = false;
                    ((Continuation)$this$handleSelectedKey_u24lambda_u2d1).resumeWith(Result.constructor-impl(Unit.INSTANCE));
                }
                int newOps = interestOps & ~readyOps;
                if (newOps != interestOps) {
                    key.interestOps(newOps);
                }
                if (newOps == 0) break block5;
                $i$f$invokeForEachPresent = this.pending;
                this.pending = $i$f$invokeForEachPresent + 1;
            }
            catch (Throwable cause) {
                key.cancel();
                int n = this.cancelled;
                this.cancelled = n + 1;
                Selectable selectable = this.getSubject(key);
                if (selectable == null) break block5;
                Selectable subject = selectable;
                boolean bl = false;
                this.cancelAllSuspensions(subject, cause);
                this.setSubject(key, null);
            }
        }
    }

    protected final void applyInterest(@NotNull Selector selector, @NotNull Selectable selectable) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Intrinsics.checkNotNullParameter(selectable, "selectable");
        try {
            SelectableChannel channel = selectable.getChannel();
            SelectionKey key = channel.keyFor(selector);
            int ops = selectable.getInterestedOps();
            if (key == null) {
                if (ops != 0) {
                    channel.register(selector, ops, selectable);
                }
            } else if (key.interestOps() != ops) {
                key.interestOps(ops);
            }
            if (ops != 0) {
                int n = this.pending;
                this.pending = n + 1;
            }
        }
        catch (Throwable cause) {
            SelectionKey selectionKey = selectable.getChannel().keyFor(selector);
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.cancelAllSuspensions(selectable, cause);
        }
    }

    protected final void notifyClosedImpl(@NotNull Selector selector, @NotNull SelectionKey key, @NotNull Selectable attachment) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(attachment, "attachment");
        this.cancelAllSuspensions(attachment, (Throwable)new ClosedChannelException());
        this.setSubject(key, null);
        selector.wakeup();
    }

    protected final void cancelAllSuspensions(@NotNull Selectable attachment, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(attachment, "attachment");
        Intrinsics.checkNotNullParameter(cause, "cause");
        InterestSuspensionsMap this_$iv = attachment.getSuspensions();
        boolean $i$f$invokeForEachPresent = false;
        for (SelectInterest interest$iv : SelectInterest.Companion.getAllInterests()) {
            CancellableContinuation<Unit> $this$invokeForEachPresent_u24lambda_u2d0$iv;
            if (this_$iv.removeSuspension(interest$iv) == null) continue;
            boolean bl = false;
            SelectInterest selectInterest = interest$iv;
            CancellableContinuation<Unit> $this$cancelAllSuspensions_u24lambda_u2d3 = $this$invokeForEachPresent_u24lambda_u2d0$iv;
            boolean bl2 = false;
            ((Continuation)$this$cancelAllSuspensions_u24lambda_u2d3).resumeWith(Result.constructor-impl(ResultKt.createFailure(cause)));
        }
    }

    protected final void cancelAllSuspensions(@NotNull Selector selector, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Throwable throwable = cause;
        if (throwable == null) {
            throwable = new ClosedSelectorCancellationException();
        }
        Throwable currentCause = throwable;
        Set<SelectionKey> set2 = selector.keys();
        Intrinsics.checkNotNullExpressionValue(set2, "selector.keys()");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            SelectionKey key = (SelectionKey)element$iv;
            boolean bl = false;
            try {
                if (key.isValid()) {
                    key.interestOps(0);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
            if (((object = key.attachment()) instanceof Selectable ? (Selectable)object : null) != null) {
                Selectable it;
                it = it;
                boolean bl2 = false;
                this.cancelAllSuspensions(it, currentCause);
            }
            key.cancel();
        }
    }

    private final Selectable getSubject(SelectionKey $this$subject) {
        Object object = $this$subject.attachment();
        return object instanceof Selectable ? (Selectable)object : null;
    }

    private final void setSubject(SelectionKey $this$subject, Selectable newValue2) {
        $this$subject.attach(newValue2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport$ClosedSelectorCancellationException;", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "()V", "ktor-network"})
    public static final class ClosedSelectorCancellationException
    extends CancellationException {
        public ClosedSelectorCancellationException() {
            super("Closed selector");
        }
    }
}

