/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.sockets.InetSocketAddress;
import io.ktor.network.sockets.SocketAddress;
import io.ktor.network.sockets.UnixSocketAddress;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0002\u001a\u0012\u0012\u0002\b\u0003 \u0004*\b\u0012\u0002\b\u0003\u0018\u00010\u00030\u0003*\u00020\u0005H\u0000\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\f\u0010\t\u001a\u00020\b*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"UNIX_DOMAIN_SOCKET_ADDRESS_CLASS", "", "checkSupportForUnixDomainSockets", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "toJavaAddress", "Ljava/net/SocketAddress;", "Lio/ktor/network/sockets/SocketAddress;", "toSocketAddress", "ktor-network"})
public final class JavaSocketAddressUtilsKt {
    @NotNull
    private static final String UNIX_DOMAIN_SOCKET_ADDRESS_CLASS = "java.net.UnixDomainSocketAddress";

    @NotNull
    public static final java.net.SocketAddress toJavaAddress(@NotNull SocketAddress $this$toJavaAddress) {
        java.net.SocketAddress socketAddress;
        Intrinsics.checkNotNullParameter($this$toJavaAddress, "<this>");
        SocketAddress socketAddress2 = $this$toJavaAddress;
        if (socketAddress2 instanceof InetSocketAddress) {
            socketAddress = new java.net.InetSocketAddress(((InetSocketAddress)$this$toJavaAddress).getHostname(), ((InetSocketAddress)$this$toJavaAddress).getPort());
        } else if (socketAddress2 instanceof UnixSocketAddress) {
            JavaSocketAddressUtilsKt.checkSupportForUnixDomainSockets($this$toJavaAddress);
            Class[] classArray = new Class[]{String.class};
            Method ofMethod = Class.forName(UNIX_DOMAIN_SOCKET_ADDRESS_CLASS).getMethod("of", classArray);
            Object[] objectArray = new Object[]{((UnixSocketAddress)$this$toJavaAddress).getPath()};
            Object object = ofMethod.invoke(null, objectArray);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.SocketAddress");
            }
            socketAddress = (java.net.SocketAddress)object;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return socketAddress;
    }

    @NotNull
    public static final SocketAddress toSocketAddress(@NotNull java.net.SocketAddress $this$toSocketAddress) {
        SocketAddress socketAddress;
        Intrinsics.checkNotNullParameter($this$toSocketAddress, "<this>");
        if ($this$toSocketAddress instanceof java.net.InetSocketAddress) {
            String string2 = ((java.net.InetSocketAddress)$this$toSocketAddress).getHostName();
            Intrinsics.checkNotNullExpressionValue(string2, "hostName");
            socketAddress = new InetSocketAddress(string2, ((java.net.InetSocketAddress)$this$toSocketAddress).getPort());
        } else if (Intrinsics.areEqual($this$toSocketAddress.getClass().getName(), UNIX_DOMAIN_SOCKET_ADDRESS_CLASS)) {
            Method getPath = Class.forName(UNIX_DOMAIN_SOCKET_ADDRESS_CLASS).getMethod("getPath", new Class[0]);
            socketAddress = new UnixSocketAddress(getPath.invoke((Object)$this$toSocketAddress, new Object[0]).toString());
        } else {
            throw new IllegalStateException("Unknown socket address type".toString());
        }
        return socketAddress;
    }

    public static final Class<?> checkSupportForUnixDomainSockets(@NotNull Object $this$checkSupportForUnixDomainSockets) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter($this$checkSupportForUnixDomainSockets, "<this>");
        try {
            clazz = Class.forName(UNIX_DOMAIN_SOCKET_ADDRESS_CLASS, false, $this$checkSupportForUnixDomainSockets.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unix domain sockets are unsupported before Java 16.".toString());
        }
        return clazz;
    }
}

