/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.config.HoconApplicationConfig;
import io.ktor.server.config.HoconApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.CommandLineJvmKt;
import io.ktor.server.engine.CommandLineKt;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import io.ktor.util.PlatformUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0019\b\u0002\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"commandLineEnvironment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "args", "", "", "environmentBuilder", "Lkotlin/Function1;", "Lio/ktor/server/engine/ApplicationEngineEnvironmentBuilder;", "", "Lkotlin/ExtensionFunctionType;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lio/ktor/server/engine/ApplicationEngineEnvironment;", "ktor-server-host-common"})
public final class CommandLineJvmKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationEngineEnvironment commandLineEnvironment(@NotNull String[] args2, @NotNull Function1<? super ApplicationEngineEnvironmentBuilder, Unit> environmentBuilder) {
        String string2;
        Object object;
        Config environmentConfig;
        Map commandLineMap;
        File configFile;
        URL jar2;
        Map argsMap;
        block14: {
            block13: {
                void $this$mapKeysTo$iv$iv;
                void $this$mapKeys$iv;
                File file2;
                URL uRL;
                Map.Entry it$iv$iv;
                Map.Entry it;
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter(args2, "args");
                Intrinsics.checkNotNullParameter(environmentBuilder, "environmentBuilder");
                String[] $this$mapNotNull$iv = args2;
                boolean $i$f$mapNotNull = false;
                String[] stringArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    Iterator element$iv$iv = element$iv$iv$iv;
                    boolean bl = false;
                    it = element$iv$iv;
                    boolean bl2 = false;
                    if (CommandLineKt.splitPair((String)((Object)it), '=') == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                argsMap = MapsKt.toMap((List)destination$iv$iv);
                String string3 = (String)argsMap.get("-jar");
                if (string3 != null) {
                    String it2 = string3;
                    boolean bl = false;
                    uRL = StringsKt.startsWith$default(it2, "file:", false, 2, null) || StringsKt.startsWith$default(it2, "jrt:", false, 2, null) || StringsKt.startsWith$default(it2, "jar:", false, 2, null) ? new URI(it2).toURL() : new File(it2).toURI().toURL();
                } else {
                    uRL = null;
                }
                jar2 = uRL;
                String string4 = (String)argsMap.get("-config");
                if (string4 != null) {
                    String it3 = string4;
                    boolean bl = false;
                    file2 = new File(it3);
                } else {
                    file2 = null;
                }
                configFile = file2;
                Map $this$filterKeys$iv = argsMap;
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                    String it4 = (String)entry$iv.getKey();
                    boolean bl = false;
                    if (!StringsKt.startsWith$default(it4, "-P:", false, 2, null)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $this$filterKeys$iv = result$iv;
                boolean $i$f$mapKeys = false;
                result$iv = $this$mapKeys$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    it = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl = false;
                    it$iv$iv = (Map.Entry)element$iv$iv$iv;
                    String bl3 = StringsKt.removePrefix((String)it.getKey(), (CharSequence)"-P:");
                    Map map3 = map2;
                    boolean bl4 = false;
                    it = it$iv$iv.getValue();
                    map3.put(bl3, it);
                }
                commandLineMap = destination$iv$iv2;
                environmentConfig = ConfigFactory.systemProperties().withOnlyPath("ktor");
                object = configFile;
                if (object == null) break block13;
                File it5 = object;
                boolean bl = false;
                Config config = ConfigFactory.parseFile(it5);
                object = config;
                if (config != null) break block14;
            }
            object = ConfigFactory.load();
        }
        Object fileConfig = object;
        Config argConfig = ConfigFactory.parseMap(commandLineMap, "Command-line options");
        Config combinedConfig = argConfig.withFallback((ConfigMergeable)fileConfig).withFallback(environmentConfig).resolve();
        String applicationIdPath = "ktor.application.id";
        String hostConfigPath = "ktor.deployment.host";
        String hostPortPath = "ktor.deployment.port";
        String hostWatchPaths = "ktor.deployment.watch";
        String rootPathPath = "ktor.deployment.rootPath";
        String hostSslPortPath = "ktor.deployment.sslPort";
        String hostSslKeyStore = "ktor.security.ssl.keyStore";
        String hostSslKeyAlias = "ktor.security.ssl.keyAlias";
        String hostSslKeyStorePassword = "ktor.security.ssl.keyStorePassword";
        String hostSslPrivateKeyPassword = "ktor.security.ssl.privateKeyPassword";
        String developmentModeKey = "ktor.development";
        Intrinsics.checkNotNullExpressionValue(combinedConfig, "combinedConfig");
        String string5 = HoconApplicationConfigKt.tryGetString(combinedConfig, applicationIdPath);
        if (string5 == null) {
            string5 = "Application";
        }
        String applicationId = string5;
        Logger appLog = LoggerFactory.getLogger(applicationId);
        if (configFile != null && !configFile.exists()) {
            appLog.error("Configuration file '" + configFile + "' specified as command line argument was not found");
            appLog.warn("Will attempt to start without loading configuration\u2026");
        }
        if ((string2 = (String)argsMap.get("-path")) == null && (string2 = HoconApplicationConfigKt.tryGetString(combinedConfig, rootPathPath)) == null) {
            string2 = "";
        }
        String rootPath = string2;
        ApplicationEngineEnvironment environment2 = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1<? super ApplicationEngineEnvironmentBuilder, Unit>)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(appLog, jar2, combinedConfig, rootPath, (Map<String, String>)argsMap, hostConfigPath, hostPortPath, hostSslPortPath, hostSslKeyStore, hostSslKeyStorePassword, hostSslPrivateKeyPassword, hostSslKeyAlias, developmentModeKey, hostWatchPaths, environmentBuilder){
            final /* synthetic */ Logger $appLog;
            final /* synthetic */ URL $jar;
            final /* synthetic */ Config $combinedConfig;
            final /* synthetic */ String $rootPath;
            final /* synthetic */ Map<String, String> $argsMap;
            final /* synthetic */ String $hostConfigPath;
            final /* synthetic */ String $hostPortPath;
            final /* synthetic */ String $hostSslPortPath;
            final /* synthetic */ String $hostSslKeyStore;
            final /* synthetic */ String $hostSslKeyStorePassword;
            final /* synthetic */ String $hostSslPrivateKeyPassword;
            final /* synthetic */ String $hostSslKeyAlias;
            final /* synthetic */ String $developmentModeKey;
            final /* synthetic */ String $hostWatchPaths;
            final /* synthetic */ Function1<ApplicationEngineEnvironmentBuilder, Unit> $environmentBuilder;
            {
                this.$appLog = $appLog;
                this.$jar = $jar;
                this.$combinedConfig = $combinedConfig;
                this.$rootPath = $rootPath;
                this.$argsMap = $argsMap;
                this.$hostConfigPath = $hostConfigPath;
                this.$hostPortPath = $hostPortPath;
                this.$hostSslPortPath = $hostSslPortPath;
                this.$hostSslKeyStore = $hostSslKeyStore;
                this.$hostSslKeyStorePassword = $hostSslKeyStorePassword;
                this.$hostSslPrivateKeyPassword = $hostSslPrivateKeyPassword;
                this.$hostSslKeyAlias = $hostSslKeyAlias;
                this.$developmentModeKey = $developmentModeKey;
                this.$hostWatchPaths = $hostWatchPaths;
                this.$environmentBuilder = $environmentBuilder;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
                String[] keyStore$iv;
                boolean bl;
                EngineConnectorBuilder it;
                String string2;
                String sslPort;
                String string3;
                String port2;
                String string4;
                String host2;
                String string5;
                ClassLoader classLoader2;
                List<EngineConnectorConfig> list2;
                Intrinsics.checkNotNullParameter($this$applicationEngineEnvironment, "$this$applicationEngineEnvironment");
                Logger logger2 = this.$appLog;
                Intrinsics.checkNotNullExpressionValue(logger2, "appLog");
                $this$applicationEngineEnvironment.setLog(logger2);
                ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$applicationEngineEnvironment;
                URL uRL = this.$jar;
                if (uRL != null) {
                    URL uRL2 = uRL;
                    URL uRL3 = this.$jar;
                    URL uRL4 = uRL2;
                    list2 = applicationEngineEnvironmentBuilder;
                    boolean bl2 = false;
                    URL[] uRLArray = new URL[]{uRL3};
                    applicationEngineEnvironmentBuilder = list2;
                    classLoader2 = new URLClassLoader(uRLArray, ApplicationEnvironment.class.getClassLoader());
                } else {
                    ClassLoader classLoader3 = ApplicationEnvironment.class.getClassLoader();
                    classLoader2 = classLoader3;
                    Intrinsics.checkNotNullExpressionValue(classLoader3, "ApplicationEnvironment::class.java.classLoader");
                }
                applicationEngineEnvironmentBuilder.setClassLoader(classLoader2);
                Config config = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue(config, "combinedConfig");
                $this$applicationEngineEnvironment.setConfig(new HoconApplicationConfig(config));
                $this$applicationEngineEnvironment.setRootPath(this.$rootPath);
                ConfigValue contentHiddenValue = ConfigValueFactory.fromAnyRef("***", "Content hidden");
                if (this.$combinedConfig.hasPath("ktor")) {
                    $this$applicationEngineEnvironment.getLog().trace(this.$combinedConfig.getObject("ktor").withoutKey("security").withValue("security", contentHiddenValue).render());
                } else {
                    $this$applicationEngineEnvironment.getLog().trace("No configuration provided: neither application.conf nor system properties nor command line options (-config or -P:ktor...=) provided");
                }
                if ((string5 = this.$argsMap.get("-host")) == null) {
                    Config config2 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue(config2, "combinedConfig");
                    string5 = HoconApplicationConfigKt.tryGetString(config2, this.$hostConfigPath);
                    if (string5 == null) {
                        string5 = host2 = "0.0.0.0";
                    }
                }
                if ((string4 = this.$argsMap.get("-port")) == null) {
                    Config config3 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue(config3, "combinedConfig");
                    string4 = port2 = HoconApplicationConfigKt.tryGetString(config3, this.$hostPortPath);
                }
                if ((string3 = this.$argsMap.get("-sslPort")) == null) {
                    Config config4 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue(config4, "combinedConfig");
                    string3 = sslPort = HoconApplicationConfigKt.tryGetString(config4, this.$hostSslPortPath);
                }
                if ((string2 = this.$argsMap.get("-sslKeyStore")) == null) {
                    Config config5 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue(config5, "combinedConfig");
                    string2 = HoconApplicationConfigKt.tryGetString(config5, this.$hostSslKeyStore);
                }
                String sslKeyStorePath = string2;
                Config config6 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue(config6, "combinedConfig");
                String string6 = HoconApplicationConfigKt.tryGetString(config6, this.$hostSslKeyStorePassword);
                String sslKeyStorePassword = string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null;
                Config config7 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue(config7, "combinedConfig");
                String string7 = HoconApplicationConfigKt.tryGetString(config7, this.$hostSslPrivateKeyPassword);
                String sslPrivateKeyPassword = string7 != null ? ((Object)StringsKt.trim((CharSequence)string7)).toString() : null;
                Config config8 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue(config8, "combinedConfig");
                String string8 = HoconApplicationConfigKt.tryGetString(config8, this.$hostSslKeyAlias);
                if (string8 == null) {
                    string8 = "mykey";
                }
                String sslKeyAlias = string8;
                ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder2 = $this$applicationEngineEnvironment;
                Config config9 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue(config9, "combinedConfig");
                String string9 = HoconApplicationConfigKt.tryGetString(config9, this.$developmentModeKey);
                if (string9 != null) {
                    String string10 = string9;
                    list2 = applicationEngineEnvironmentBuilder2;
                    boolean bl3 = false;
                    boolean bl4 = Boolean.parseBoolean((String)((Object)it));
                    applicationEngineEnvironmentBuilder2 = list2;
                    bl = bl4;
                } else {
                    bl = PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE();
                }
                applicationEngineEnvironmentBuilder2.setDevelopmentMode(bl);
                if (port2 != null) {
                    void $this$invoke_u24lambda_u2d2;
                    EngineConnectorBuilder engineConnectorBuilder;
                    ApplicationEngineEnvironmentBuilder $this$connector$iv = $this$applicationEngineEnvironment;
                    boolean $i$f$connector = false;
                    it = engineConnectorBuilder = new EngineConnectorBuilder(null, 1, null);
                    list2 = $this$connector$iv.getConnectors();
                    boolean bl5 = false;
                    $this$invoke_u24lambda_u2d2.setHost(host2);
                    $this$invoke_u24lambda_u2d2.setPort(Integer.parseInt(port2));
                    list2.add(engineConnectorBuilder);
                }
                if (sslPort != null) {
                    void $this$invoke_u24lambda_u2d7;
                    void $this$sslConnector$iv;
                    void keyStorePassword$iv;
                    Object object;
                    if (sslKeyStorePath == null) {
                        throw new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or " + this.$hostSslKeyStore + " config");
                    }
                    if (sslKeyStorePassword == null) {
                        throw new IllegalArgumentException("SSL requires keystore password: use " + this.$hostSslKeyStorePassword + " config");
                    }
                    if (sslPrivateKeyPassword == null) {
                        throw new IllegalArgumentException("SSL requires certificate password: use " + this.$hostSslPrivateKeyPassword + " config");
                    }
                    Object file2 = new File(sslKeyStorePath);
                    boolean bl6 = false;
                    File keyStoreFile = ((File)file2).exists() || ((File)file2).isAbsolute() ? file2 : new File(".", sslKeyStorePath).getAbsoluteFile();
                    Object $this$invoke_u24lambda_u2d6 = file2 = KeyStore.getInstance("JKS");
                    boolean $i$a$-apply-CommandLineJvmKt$commandLineEnvironment$environment$1$keyStore$22 = false;
                    Closeable closeable = new FileInputStream(keyStoreFile);
                    Throwable throwable = null;
                    try {
                        FileInputStream it2 = (FileInputStream)closeable;
                        boolean bl7 = false;
                        InputStream inputStream2 = it2;
                        char[] cArray = sslKeyStorePassword.toCharArray();
                        Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
                        ((KeyStore)$this$invoke_u24lambda_u2d6).load(inputStream2, cArray);
                        object = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                    char[] cArray = sslPrivateKeyPassword.toCharArray();
                    Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
                    if (((KeyStore)$this$invoke_u24lambda_u2d6).getKey(sslKeyAlias, cArray) == null) {
                        boolean $i$a$-requireNotNull-CommandLineJvmKt$commandLineEnvironment$environment$1$keyStore$1$32 = false;
                        String $i$a$-requireNotNull-CommandLineJvmKt$commandLineEnvironment$environment$1$keyStore$1$32 = "The specified key " + sslKeyAlias + " doesn't exist in the key store " + sslKeyStorePath;
                        throw new IllegalArgumentException($i$a$-requireNotNull-CommandLineJvmKt$commandLineEnvironment$environment$1$keyStore$1$32.toString());
                    }
                    Object keyStore = file2;
                    file2 = $this$applicationEngineEnvironment;
                    Intrinsics.checkNotNullExpressionValue(keyStore, "keyStore");
                    $this$invoke_u24lambda_u2d6 = keyStore;
                    Function0 $i$a$-apply-CommandLineJvmKt$commandLineEnvironment$environment$1$keyStore$22 = new Function0<char[]>(sslKeyStorePassword){
                        final /* synthetic */ String $sslKeyStorePassword;
                        {
                            this.$sslKeyStorePassword = $sslKeyStorePassword;
                            super(0);
                        }

                        @NotNull
                        public final char[] invoke() {
                            char[] cArray = this.$sslKeyStorePassword.toCharArray();
                            Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
                            return cArray;
                        }
                    };
                    Function0 privateKeyPassword$iv = new Function0<char[]>(sslPrivateKeyPassword){
                        final /* synthetic */ String $sslPrivateKeyPassword;
                        {
                            this.$sslPrivateKeyPassword = $sslPrivateKeyPassword;
                            super(0);
                        }

                        @NotNull
                        public final char[] invoke() {
                            char[] cArray = this.$sslPrivateKeyPassword.toCharArray();
                            Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
                            return cArray;
                        }
                    };
                    boolean $i$f$sslConnector = false;
                    Object bl7 = object = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, privateKeyPassword$iv);
                    list2 = $this$sslConnector$iv.getConnectors();
                    boolean bl8 = false;
                    $this$invoke_u24lambda_u2d7.setHost(host2);
                    $this$invoke_u24lambda_u2d7.setPort(Integer.parseInt(sslPort));
                    $this$invoke_u24lambda_u2d7.setKeyStorePath(keyStoreFile);
                    list2.add((EngineConnectorConfig)object);
                }
                if (port2 == null && sslPort == null) {
                    throw new IllegalArgumentException("Neither port nor sslPort specified. Use command line options -port/-sslPort or configure connectors in application.conf");
                }
                Object object = this.$argsMap.get("-watch");
                if (object == null || (object = StringsKt.split$default((CharSequence)object, keyStore$iv = new String[]{","}, false, 0, 6, null)) == null) {
                    Config config10 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue(config10, "combinedConfig");
                    object = HoconApplicationConfigKt.tryGetStringList(config10, this.$hostWatchPaths);
                }
                if (object != null) {
                    Object it3 = object;
                    boolean bl9 = false;
                    $this$applicationEngineEnvironment.setWatchPaths((List<String>)it3);
                }
                this.$environmentBuilder.invoke($this$applicationEngineEnvironment);
            }
        });
        return environment2;
    }

    public static /* synthetic */ ApplicationEngineEnvironment commandLineEnvironment$default(String[] stringArray, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = commandLineEnvironment.1.INSTANCE;
        }
        return CommandLineJvmKt.commandLineEnvironment(stringArray, function1);
    }
}

