/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.ConfigKeys;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EnvironmentUtilsJvmKt;
import io.ktor.util.PlatformUtils;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"commandLineEnvironment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "args", "", "", "([Ljava/lang/String;)Lio/ktor/server/engine/ApplicationEngineEnvironment;", "loadCommonConfiguration", "", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "deploymentConfig", "Lio/ktor/server/config/ApplicationConfig;", "splitPair", "Lkotlin/Pair;", "ch", "", "ktor-server-host-common"})
public final class CommandLineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationEngineEnvironment commandLineEnvironment(@NotNull String[] args2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(args2, "args");
        String[] $this$mapNotNull$iv = args2;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair<String, String> it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (CommandLineKt.splitPair((String)it, '=') == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map<String, String> argumentsPairs = MapsKt.toMap((List)destination$iv$iv);
        ApplicationConfig configuration2 = EnvironmentUtilsJvmKt.buildApplicationConfig(args2);
        String string2 = ApplicationConfigKt.tryGetString(configuration2, ConfigKeys.INSTANCE.getApplicationIdPath());
        if (string2 == null) {
            string2 = "Application";
        }
        String applicationId = string2;
        Logger logger2 = KtorSimpleLoggerJvmKt.KtorSimpleLogger(applicationId);
        String string3 = (String)argumentsPairs.get("-path");
        if (string3 == null && (string3 = ApplicationConfigKt.tryGetString(configuration2, ConfigKeys.INSTANCE.getRootPathPath())) == null) {
            string3 = "";
        }
        String rootPath = string3;
        ApplicationEngineEnvironment environment2 = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1<? super ApplicationEngineEnvironmentBuilder, Unit>)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(logger2, args2, configuration2, rootPath, argumentsPairs){
            final /* synthetic */ Logger $logger;
            final /* synthetic */ String[] $args;
            final /* synthetic */ ApplicationConfig $configuration;
            final /* synthetic */ String $rootPath;
            final /* synthetic */ Map<String, String> $argumentsPairs;
            {
                this.$logger = $logger;
                this.$args = $args;
                this.$configuration = $configuration;
                this.$rootPath = $rootPath;
                this.$argumentsPairs = $argumentsPairs;
                super(1);
            }

            public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
                block11: {
                    String[] $this$invoke_u24lambda_u2d1;
                    boolean bl;
                    EngineConnectorBuilder it;
                    Object object;
                    String string2;
                    String sslPort;
                    String string3;
                    String port2;
                    String string4;
                    String host2;
                    Intrinsics.checkNotNullParameter($this$applicationEngineEnvironment, "$this$applicationEngineEnvironment");
                    $this$applicationEngineEnvironment.setLog(this.$logger);
                    EnvironmentUtilsJvmKt.configurePlatformProperties($this$applicationEngineEnvironment, this.$args);
                    $this$applicationEngineEnvironment.setConfig(this.$configuration);
                    $this$applicationEngineEnvironment.setRootPath(this.$rootPath);
                    String string5 = this.$argumentsPairs.get("-host");
                    if (string5 == null && (string5 = ApplicationConfigKt.tryGetString(this.$configuration, ConfigKeys.INSTANCE.getHostConfigPath())) == null) {
                        string5 = host2 = "0.0.0.0";
                    }
                    if ((string4 = this.$argumentsPairs.get("-port")) == null) {
                        string4 = port2 = ApplicationConfigKt.tryGetString(this.$configuration, ConfigKeys.INSTANCE.getHostPortPath());
                    }
                    if ((string3 = this.$argumentsPairs.get("-sslPort")) == null) {
                        string3 = sslPort = ApplicationConfigKt.tryGetString(this.$configuration, ConfigKeys.INSTANCE.getHostSslPortPath());
                    }
                    if ((string2 = this.$argumentsPairs.get("-sslKeyStore")) == null) {
                        string2 = ApplicationConfigKt.tryGetString(this.$configuration, ConfigKeys.INSTANCE.getHostSslKeyStore());
                    }
                    String sslKeyStorePath = string2;
                    String string6 = ApplicationConfigKt.tryGetString(this.$configuration, ConfigKeys.INSTANCE.getHostSslKeyStorePassword());
                    String sslKeyStorePassword = string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null;
                    String string7 = ApplicationConfigKt.tryGetString(this.$configuration, ConfigKeys.INSTANCE.getHostSslPrivateKeyPassword());
                    String sslPrivateKeyPassword = string7 != null ? ((Object)StringsKt.trim((CharSequence)string7)).toString() : null;
                    String string8 = ApplicationConfigKt.tryGetString(this.$configuration, ConfigKeys.INSTANCE.getHostSslKeyAlias());
                    if (string8 == null) {
                        string8 = "mykey";
                    }
                    String sslKeyAlias = string8;
                    ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$applicationEngineEnvironment;
                    String string9 = ApplicationConfigKt.tryGetString(this.$configuration, ConfigKeys.INSTANCE.getDevelopmentModeKey());
                    if (string9 != null) {
                        String string10 = string9;
                        object = applicationEngineEnvironmentBuilder;
                        boolean bl2 = false;
                        boolean bl3 = Boolean.parseBoolean((String)((Object)it));
                        applicationEngineEnvironmentBuilder = object;
                        bl = bl3;
                    } else {
                        bl = PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE();
                    }
                    applicationEngineEnvironmentBuilder.setDevelopmentMode(bl);
                    if (port2 != null) {
                        EngineConnectorBuilder engineConnectorBuilder;
                        ApplicationEngineEnvironmentBuilder $this$connector$iv = $this$applicationEngineEnvironment;
                        boolean $i$f$connector = false;
                        it = engineConnectorBuilder = new EngineConnectorBuilder(null, 1, null);
                        object = $this$connector$iv.getConnectors();
                        boolean bl4 = false;
                        $this$invoke_u24lambda_u2d1.setHost(host2);
                        $this$invoke_u24lambda_u2d1.setPort(Integer.parseInt(port2));
                        object.add(engineConnectorBuilder);
                    }
                    if (sslPort != null) {
                        EnvironmentUtilsJvmKt.configureSSLConnectors($this$applicationEngineEnvironment, host2, sslPort, sslKeyStorePath, sslKeyStorePassword, sslPrivateKeyPassword, sslKeyAlias);
                    }
                    if (port2 == null && sslPort == null) {
                        throw new IllegalArgumentException("Neither port nor sslPort specified. Use command line options -port/-sslPort or configure connectors in application.conf");
                    }
                    Object object2 = this.$argumentsPairs.get("-watch");
                    if (object2 == null || (object2 = StringsKt.split$default((CharSequence)object2, $this$invoke_u24lambda_u2d1 = new String[]{","}, false, 0, 6, null)) == null) {
                        object2 = ApplicationConfigKt.tryGetStringList(this.$configuration, ConfigKeys.INSTANCE.getHostWatchPaths());
                    }
                    if (object2 == null) break block11;
                    Object it2 = object2;
                    boolean bl5 = false;
                    $this$applicationEngineEnvironment.setWatchPaths((List<String>)it2);
                }
            }
        });
        return environment2;
    }

    public static final void loadCommonConfiguration(@NotNull BaseApplicationEngine.Configuration $this$loadCommonConfiguration, @NotNull ApplicationConfig deploymentConfig) {
        block2: {
            Object object;
            Object object2;
            int it;
            Intrinsics.checkNotNullParameter($this$loadCommonConfiguration, "<this>");
            Intrinsics.checkNotNullParameter(deploymentConfig, "deploymentConfig");
            Object object3 = deploymentConfig.propertyOrNull("callGroupSize");
            if (object3 != null && (object3 = object3.getString()) != null) {
                it = Integer.parseInt((String)object3);
                boolean bl = false;
                $this$loadCommonConfiguration.setCallGroupSize(it);
            }
            if ((object2 = deploymentConfig.propertyOrNull("connectionGroupSize")) != null && (object2 = object2.getString()) != null) {
                it = Integer.parseInt((String)object2);
                boolean bl = false;
                $this$loadCommonConfiguration.setConnectionGroupSize(it);
            }
            if ((object = deploymentConfig.propertyOrNull("workerGroupSize")) == null || (object = object.getString()) == null) break block2;
            it = Integer.parseInt((String)object);
            boolean bl = false;
            $this$loadCommonConfiguration.setWorkerGroupSize(it);
        }
    }

    @Nullable
    public static final Pair<String, String> splitPair(@NotNull String $this$splitPair, char ch) {
        Intrinsics.checkNotNullParameter($this$splitPair, "<this>");
        int idx = StringsKt.indexOf$default((CharSequence)$this$splitPair, ch, 0, false, 6, null);
        boolean bl = false;
        return idx == -1 ? null : new Pair<String, String>(StringsKt.take($this$splitPair, idx), StringsKt.drop($this$splitPair, idx + 1));
    }
}

