/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.callid;

import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.CreatePluginUtilsKt;
import io.ktor.server.application.RouteScopedPlugin;
import io.ktor.server.plugins.callid.CallIdConfig;
import io.ktor.server.plugins.callid.CallIdKt;
import io.ktor.util.AttributeKey;
import io.ktor.util.CharsetKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\u001a\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014*\u00020\u0001H\u0002\u001a\u001e\u0010\u0015\u001a\u00020\u0016*\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0001\u001a\u001c\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\r*D\u0010\u001d\"\u001f\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e2\u001f\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e*\"\u0010\"\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u001e2\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u001e\u00a8\u0006#\u00b2\u0006\u000e\u0010$\u001a\u00060%j\u0002`&X\u008a\u0084\u0002"}, d2={"CALL_ID_DEFAULT_DICTIONARY", "", "CallId", "Lio/ktor/server/application/RouteScopedPlugin;", "Lio/ktor/server/plugins/callid/CallIdConfig;", "getCallId", "()Lio/ktor/server/application/RouteScopedPlugin;", "CallIdKey", "Lio/ktor/util/AttributeKey;", "getCallIdKey", "()Lio/ktor/util/AttributeKey;", "callId", "Lio/ktor/server/application/ApplicationCall;", "(Lio/ktor/server/application/ApplicationCall;)Ljava/lang/String;", "verifyCallIdAgainstDictionary", "", "dictionarySet", "", "", "duplicates", "", "generate", "", "length", "", "dictionary", "nextString", "Lkotlin/random/Random;", "", "CallIdProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "call", "CallIdVerifier", "ktor-server-call-id", "logger", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;"})
public final class CallIdKt {
    @NotNull
    private static final AttributeKey<String> CallIdKey = new AttributeKey("ExtractedCallId");
    @NotNull
    private static final RouteScopedPlugin<CallIdConfig> CallId = CreatePluginUtilsKt.createRouteScopedPlugin("CallId", CallId.1.INSTANCE, CallId.2.INSTANCE);
    @NotNull
    public static final String CALL_ID_DEFAULT_DICTIONARY = "abcdefghijklmnopqrstuvwxyz0123456789+/=-";

    @NotNull
    public static final AttributeKey<String> getCallIdKey() {
        return CallIdKey;
    }

    @NotNull
    public static final RouteScopedPlugin<CallIdConfig> getCallId() {
        return CallId;
    }

    @Nullable
    public static final String getCallId(@NotNull ApplicationCall $this$callId) {
        Intrinsics.checkNotNullParameter($this$callId, "<this>");
        return $this$callId.getAttributes().getOrNull(CallIdKey);
    }

    private static final boolean verifyCallIdAgainstDictionary(String callId, Set<Character> dictionarySet) {
        int n = callId.length();
        for (int i = 0; i < n; ++i) {
            char element = callId.charAt(i);
            if (dictionarySet.contains(Character.valueOf(element))) continue;
            return false;
        }
        return true;
    }

    public static final void generate(@NotNull CallIdConfig $this$generate, int length, @NotNull String dictionary) {
        Intrinsics.checkNotNullParameter($this$generate, "<this>");
        Intrinsics.checkNotNullParameter(dictionary, "dictionary");
        if (!(length >= 1)) {
            boolean $i$a$-require-CallIdKt$generate$42 = false;
            String $i$a$-require-CallIdKt$generate$42 = "Call id should be at least one characters length: " + length;
            throw new IllegalArgumentException($i$a$-require-CallIdKt$generate$42.toString());
        }
        if (!(dictionary.length() > 1)) {
            boolean bl = false;
            String string2 = "Dictionary should consist of several different characters";
            throw new IllegalArgumentException(string2.toString());
        }
        char[] dictionaryCharacters = CollectionsKt.toCharArray((Collection<Character>)ArraysKt.distinct(CharsetKt.toCharArray(dictionary)));
        if (!(dictionaryCharacters.length == dictionary.length())) {
            boolean bl = false;
            String string3 = "Dictionary should not contain duplicates, found: " + CallIdKt.duplicates(dictionary);
            throw new IllegalArgumentException(string3.toString());
        }
        $this$generate.generate((Function1<? super ApplicationCall, String>)new Function1<ApplicationCall, String>(length, dictionaryCharacters){
            final /* synthetic */ int $length;
            final /* synthetic */ char[] $dictionaryCharacters;
            {
                this.$length = $length;
                this.$dictionaryCharacters = $dictionaryCharacters;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull ApplicationCall it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return CallIdKt.access$nextString(Random.Default, this.$length, this.$dictionaryCharacters);
            }
        });
    }

    public static /* synthetic */ void generate$default(CallIdConfig callIdConfig, int n, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        if ((n2 & 2) != 0) {
            string2 = CALL_ID_DEFAULT_DICTIONARY;
        }
        CallIdKt.generate(callIdConfig, n, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Character> duplicates(String $this$duplicates) {
        void $this$groupByTo$iv$iv;
        char[] $this$groupBy$iv = CharsetKt.toCharArray($this$duplicates);
        boolean $i$f$groupBy = false;
        char[] cArray = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        int n = ((void)$this$groupByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object;
            void element$iv$iv;
            void it = element$iv$iv = $this$groupByTo$iv$iv[i];
            boolean bl = false;
            Character key$iv$iv = Character.valueOf((char)it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(Character.valueOf((char)element$iv$iv));
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.sorted(((Map)result$iv).keySet());
    }

    private static final String nextString(Random $this$nextString, int length, char[] dictionary) {
        char[] chars = new char[length];
        int dictionarySize = dictionary.length;
        for (int index2 = 0; index2 < length; ++index2) {
            chars[index2] = dictionary[$this$nextString.nextInt(dictionarySize)];
        }
        return StringsKt.concatToString(chars);
    }

    public static final /* synthetic */ boolean access$verifyCallIdAgainstDictionary(String callId, Set dictionarySet) {
        return CallIdKt.verifyCallIdAgainstDictionary(callId, dictionarySet);
    }

    public static final /* synthetic */ String access$nextString(Random $receiver, int length, char[] dictionary) {
        return CallIdKt.nextString($receiver, length, dictionary);
    }
}

