/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.compression;

import io.ktor.http.ContentType;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.plugins.compression.CompressedResponse;
import io.ktor.server.plugins.compression.CompressionEncoder;
import io.ktor.util.AttributeKey;
import io.ktor.util.StringValuesKt;
import io.ktor.utils.io.ByteReadChannel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ'\u0010&\u001a\u0004\u0018\u0001H'\"\b\b\u0000\u0010'*\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u0006H\u0016J/\u0010-\u001a\u00020.\"\b\b\u0000\u0010'*\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*2\b\u0010/\u001a\u0004\u0018\u0001H'H\u0016\u00a2\u0006\u0002\u00100R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00061"}, d2={"Lio/ktor/server/plugins/compression/CompressedResponse;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "original", "Lio/ktor/http/content/OutgoingContent;", "delegateChannel", "Lkotlin/Function0;", "Lio/ktor/utils/io/ByteReadChannel;", "encoding", "", "encoder", "Lio/ktor/server/plugins/compression/CompressionEncoder;", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/jvm/functions/Function0;Ljava/lang/String;Lio/ktor/server/plugins/compression/CompressionEncoder;)V", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "contentType", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "getDelegateChannel", "()Lkotlin/jvm/functions/Function0;", "getEncoder", "()Lio/ktor/server/plugins/compression/CompressionEncoder;", "getEncoding", "()Ljava/lang/String;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "headers$delegate", "Lkotlin/Lazy;", "getOriginal", "()Lio/ktor/http/content/OutgoingContent;", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "getProperty", "T", "", "key", "Lio/ktor/util/AttributeKey;", "(Lio/ktor/util/AttributeKey;)Ljava/lang/Object;", "readFrom", "setProperty", "", "value", "(Lio/ktor/util/AttributeKey;Ljava/lang/Object;)V", "ktor-server-compression"})
final class CompressedResponse
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final OutgoingContent original;
    @NotNull
    private final Function0<ByteReadChannel> delegateChannel;
    @NotNull
    private final String encoding;
    @NotNull
    private final CompressionEncoder encoder;
    @NotNull
    private final Lazy headers$delegate;

    public CompressedResponse(@NotNull OutgoingContent original, @NotNull Function0<? extends ByteReadChannel> delegateChannel, @NotNull String encoding, @NotNull CompressionEncoder encoder2) {
        Intrinsics.checkNotNullParameter(original, "original");
        Intrinsics.checkNotNullParameter(delegateChannel, "delegateChannel");
        Intrinsics.checkNotNullParameter(encoding, "encoding");
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        this.original = original;
        this.delegateChannel = delegateChannel;
        this.encoding = encoding;
        this.encoder = encoder2;
        this.headers$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<Headers>(this){
            final /* synthetic */ CompressedResponse this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Headers invoke() {
                HeadersBuilder headersBuilder;
                Headers.Companion companion = Headers.Companion;
                CompressedResponse compressedResponse = this.this$0;
                boolean $i$f$build = false;
                HeadersBuilder $this$invoke_u24lambda_u2d0 = headersBuilder = new HeadersBuilder(0, 1, null);
                boolean bl = false;
                StringValuesKt.appendFiltered$default($this$invoke_u24lambda_u2d0, compressedResponse.getOriginal().getHeaders(), false, headers.1.1.INSTANCE, 2, null);
                $this$invoke_u24lambda_u2d0.append(HttpHeaders.INSTANCE.getContentEncoding(), compressedResponse.getEncoding());
                return headersBuilder.build();
            }
        });
    }

    @NotNull
    public final OutgoingContent getOriginal() {
        return this.original;
    }

    @NotNull
    public final Function0<ByteReadChannel> getDelegateChannel() {
        return this.delegateChannel;
    }

    @NotNull
    public final String getEncoding() {
        return this.encoding;
    }

    @NotNull
    public final CompressionEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        return CompressionEncoder.DefaultImpls.compress$default(this.encoder, this.delegateChannel.invoke(), null, 2, null);
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        Lazy lazy = this.headers$delegate;
        return (Headers)lazy.getValue();
    }

    @Override
    @Nullable
    public ContentType getContentType() {
        return this.original.getContentType();
    }

    @Override
    @Nullable
    public HttpStatusCode getStatus() {
        return this.original.getStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Long getContentLength() {
        Long l = this.original.getContentLength();
        Long l2 = l;
        if (l == null) return null;
        long it = ((Number)l2).longValue();
        boolean bl = false;
        Long l3 = this.encoder.predictCompressedLength(it);
        l2 = l3;
        if (l3 == null) return null;
        Long l4 = l2;
        it = ((Number)l4).longValue();
        boolean bl2 = false;
        if (it < 0L) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Long l5 = l4;
        return l5;
    }

    @Override
    @Nullable
    public <T> T getProperty(@NotNull AttributeKey<T> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.original.getProperty(key);
    }

    @Override
    public <T> void setProperty(@NotNull AttributeKey<T> key, @Nullable T value2) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.original.setProperty(key, value2);
    }
}

