/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.util;

import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0082\u0002\u001a \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\b\u0012\u0004\u0012\u00020\u00050\u000b\u001a\u001a\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0005H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0015H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"FirstReservedLetters", "", "ReservedCharacters", "ReservedWords", "", "", "contains", "", "char", "", "filterComponentsImpl", "", "startIndex", "", "normalizePathComponents", "processAndReplaceComponent", "", "", "component", "shouldBeReplaced", "toASCIITable", "", "ktor-server-core"})
public final class PathsKt {
    @NotNull
    private static final boolean[] FirstReservedLetters;
    @NotNull
    private static final Set<String> ReservedWords;
    @NotNull
    private static final boolean[] ReservedCharacters;

    @NotNull
    public static final List<String> normalizePathComponents(@NotNull List<String> $this$normalizePathComponents) {
        Intrinsics.checkNotNullParameter($this$normalizePathComponents, "<this>");
        int n = $this$normalizePathComponents.size();
        for (int index2 = 0; index2 < n; ++index2) {
            String component = $this$normalizePathComponents.get(index2);
            if (!PathsKt.shouldBeReplaced(component)) continue;
            return PathsKt.filterComponentsImpl($this$normalizePathComponents, index2);
        }
        return $this$normalizePathComponents;
    }

    private static final List<String> filterComponentsImpl(List<String> $this$filterComponentsImpl, int startIndex) {
        ArrayList<String> result2 = new ArrayList<String>($this$filterComponentsImpl.size());
        if (startIndex > 0) {
            result2.addAll((Collection)$this$filterComponentsImpl.subList(0, startIndex));
        }
        PathsKt.processAndReplaceComponent((List<String>)result2, $this$filterComponentsImpl.get(startIndex));
        int n = $this$filterComponentsImpl.size();
        for (int index2 = startIndex + 1; index2 < n; ++index2) {
            String component = $this$filterComponentsImpl.get(index2);
            if (PathsKt.shouldBeReplaced(component)) {
                PathsKt.processAndReplaceComponent((List<String>)result2, component);
                continue;
            }
            result2.add(component);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void processAndReplaceComponent(List<String> $this$processAndReplaceComponent, String component) {
        block7: {
            String string2;
            CharSequence charSequence2;
            block6: {
                int index$iv$iv;
                void $this$filterTo$iv$iv;
                if (((CharSequence)component).length() == 0 || Intrinsics.areEqual(component, ".") || Intrinsics.areEqual(component, "~") || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules(component))) {
                    return;
                }
                if (Intrinsics.areEqual(component, "..")) {
                    if (!((Collection)$this$processAndReplaceComponent).isEmpty()) {
                        $this$processAndReplaceComponent.remove(CollectionsKt.getLastIndex($this$processAndReplaceComponent));
                    }
                    return;
                }
                String $this$filter$iv = component;
                boolean $i$f$filter = false;
                CharSequence charSequence3 = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n = $this$filterTo$iv$iv.length();
                for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char element$iv$iv;
                    char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (!(Intrinsics.compare(it, 32) >= 0 && !PathsKt.contains(ReservedCharacters, it))) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                String string3 = ((StringBuilder)destination$iv$iv).toString();
                Intrinsics.checkNotNullExpressionValue(string3, "filterTo(StringBuilder(), predicate).toString()");
                String $this$trimEnd$iv = string3;
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                int n2 = $this$trimEnd$iv$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        index$iv$iv = n2--;
                        char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        if (it == ' ' || it == '.') continue;
                        charSequence2 = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                        break block6;
                    } while (0 <= n2);
                }
                charSequence2 = "";
            }
            String it = string2 = ((Object)charSequence2).toString();
            boolean bl = false;
            String string4 = ((CharSequence)it).length() > 0 ? string2 : null;
            if (string4 == null) break block7;
            String filtered = string4;
            boolean bl2 = false;
            $this$processAndReplaceComponent.add(filtered);
        }
    }

    private static final boolean shouldBeReplaced(String $this$shouldBeReplaced) {
        boolean bl;
        block6: {
            int length = $this$shouldBeReplaced.length();
            if (length == 0) {
                return true;
            }
            char first2 = $this$shouldBeReplaced.charAt(0);
            if (first2 == '.' && (length == 1 || length == 2 && $this$shouldBeReplaced.charAt(1) == '.')) {
                return true;
            }
            if (first2 == '~' && length == 1) {
                return true;
            }
            if (PathsKt.contains(FirstReservedLetters, first2) && (ReservedWords.contains($this$shouldBeReplaced) || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules($this$shouldBeReplaced)))) {
                return true;
            }
            char last2 = $this$shouldBeReplaced.charAt(length - 1);
            if (last2 == ' ' || last2 == '.') {
                return true;
            }
            boolean[] ReservedCharacters = PathsKt.ReservedCharacters;
            CharSequence $this$any$iv = $this$shouldBeReplaced;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(Intrinsics.compare(it, 32) < 0 || PathsKt.contains(ReservedCharacters, it))) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean[] toASCIITable(char[] $this$toASCIITable) {
        int n = 0;
        boolean[] blArray = new boolean[256];
        while (n < 256) {
            int n2 = n++;
            blArray[n2] = ArraysKt.contains($this$toASCIITable, (char)n2);
        }
        return blArray;
    }

    private static final boolean contains(boolean[] $this$contains, char c) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        char codepoint = c;
        return codepoint < $this$contains.length && $this$contains[codepoint];
    }

    static {
        Object[] objectArray = new char[]{'A', 'a', 'C', 'c', 'l', 'L', 'P', 'p', 'n', 'N'};
        FirstReservedLetters = PathsKt.toASCIITable(objectArray);
        objectArray = new String[22];
        objectArray[0] = (char)"CON";
        objectArray[1] = (char)"PRN";
        objectArray[2] = (char)"AUX";
        objectArray[3] = (char)"NUL";
        objectArray[4] = (char)"COM1";
        objectArray[5] = (char)"COM2";
        objectArray[6] = (char)"COM3";
        objectArray[7] = (char)"COM4";
        objectArray[8] = (char)"COM5";
        objectArray[9] = (char)"COM6";
        objectArray[10] = (char)"COM7";
        objectArray[11] = (char)"COM8";
        objectArray[12] = (char)"COM9";
        objectArray[13] = (char)"LPT1";
        objectArray[14] = (char)"LPT2";
        objectArray[15] = (char)"LPT3";
        objectArray[16] = (char)"LPT4";
        objectArray[17] = (char)"LPT5";
        objectArray[18] = (char)"LPT6";
        objectArray[19] = (char)"LPT7";
        objectArray[20] = (char)"LPT8";
        objectArray[21] = (char)"LPT9";
        ReservedWords = SetsKt.setOf(objectArray);
        objectArray = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        ReservedCharacters = PathsKt.toASCIITable(objectArray);
    }
}

