/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputArraysKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\n\u001a\u00020\r*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\r\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\u001a\r\u0010\u0010\u001a\u00020\u0005*\u00020\u0005H\u0080\b\u001a\r\u0010\u0011\u001a\u00020\t*\u00020\u0007H\u0080\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"BASE64_ALPHABET", "", "BASE64_INVERSE_ALPHABET", "", "BASE64_MASK", "", "BASE64_MASK_INT", "", "BASE64_PAD", "", "decodeBase64Bytes", "Lio/ktor/utils/io/core/Input;", "Lio/ktor/utils/io/core/ByteReadPacket;", "", "decodeBase64String", "encodeBase64", "fromBase64", "toBase64", "ktor-utils"})
public final class Base64Kt {
    @NotNull
    private static final String BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final byte BASE64_MASK = 63;
    private static final int BASE64_MASK_INT = 63;
    private static final char BASE64_PAD = '=';
    @NotNull
    private static final int[] BASE64_INVERSE_ALPHABET;

    @NotNull
    public static final String encodeBase64(@NotNull String $this$encodeBase64) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$encodeBase64, "<this>");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$encodeBase64_u24lambda_u2d0 = builder$iv;
            boolean bl = false;
            StringsKt.writeText$default((Output)$this$encodeBase64_u24lambda_u2d0, $this$encodeBase64, 0, 0, null, 14, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return Base64Kt.encodeBase64(byteReadPacket);
    }

    @NotNull
    public static final String encodeBase64(@NotNull byte[] $this$encodeBase64) {
        int n;
        Intrinsics.checkNotNullParameter($this$encodeBase64, "<this>");
        byte[] array2 = $this$encodeBase64;
        int position = 0;
        int writeOffset = 0;
        char[] charArray = new char[$this$encodeBase64.length * 8 / 6 + 3];
        while (position + 3 <= array2.length) {
            byte first2 = array2[position];
            byte second2 = array2[position + 1];
            byte third = array2[position + 2];
            position += 3;
            int chunk = (first2 & 0xFF) << 16 | (second2 & 0xFF) << 8 | third & 0xFF;
            for (int index2 = 3; -1 < index2; --index2) {
                int n2 = chunk >> 6 * index2 & 0x3F;
                n = writeOffset;
                writeOffset = n + 1;
                int $this$toBase64$iv = n2;
                boolean $i$f$toBase64 = false;
                charArray[n] = BASE64_ALPHABET.charAt($this$toBase64$iv);
            }
        }
        int remaining = array2.length - position;
        if (remaining == 0) {
            return kotlin.text.StringsKt.concatToString(charArray, 0, writeOffset);
        }
        int chunk = remaining == 1 ? (array2[position] & 0xFF) << 16 | 0 | 0 : (array2[position] & 0xFF) << 16 | (array2[position + 1] & 0xFF) << 8 | 0;
        int padSize = (3 - remaining) * 8 / 6;
        int index3 = 3;
        if (padSize <= index3) {
            while (true) {
                int n3 = chunk >> 6 * index3 & 0x3F;
                n2 = writeOffset;
                writeOffset = n2 + 1;
                int $this$toBase64$iv = n3;
                boolean $i$f$toBase64 = false;
                charArray[n2] = BASE64_ALPHABET.charAt($this$toBase64$iv);
                if (index3 == padSize) break;
                --index3;
            }
        }
        int n4 = 0;
        while (n4 < padSize) {
            int it = n4++;
            boolean bl = false;
            n = writeOffset;
            writeOffset = n + 1;
            charArray[n] = 61;
        }
        return kotlin.text.StringsKt.concatToString(charArray, 0, writeOffset);
    }

    @NotNull
    public static final String encodeBase64(@NotNull ByteReadPacket $this$encodeBase64) {
        Intrinsics.checkNotNullParameter($this$encodeBase64, "<this>");
        return Base64Kt.encodeBase64(StringsKt.readBytes$default($this$encodeBase64, 0, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decodeBase64String(@NotNull String $this$decodeBase64String) {
        void bytes$iv;
        Intrinsics.checkNotNullParameter($this$decodeBase64String, "<this>");
        byte[] byArray = Base64Kt.decodeBase64Bytes($this$decodeBase64String);
        Charset charset$iv = Charsets.UTF_8;
        int offset$iv = 0;
        int length$iv = ((void)bytes$iv).length;
        boolean $i$f$String = false;
        return new String((byte[])bytes$iv, offset$iv, length$iv, charset$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] decodeBase64Bytes(@NotNull String $this$decodeBase64Bytes) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$decodeBase64Bytes, "<this>");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            String string2;
            Output output;
            block3: {
                BytePacketBuilder $this$decodeBase64Bytes_u24lambda_u2d3 = builder$iv;
                boolean bl = false;
                String string3 = $this$decodeBase64Bytes;
                output = $this$decodeBase64Bytes_u24lambda_u2d3;
                boolean $i$f$dropLastWhile = false;
                for (int index$iv = kotlin.text.StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                    void $this$dropLastWhile$iv;
                    char it = $this$dropLastWhile$iv.charAt(index$iv);
                    boolean bl2 = false;
                    if (it == '=') continue;
                    void var9_11 = $this$dropLastWhile$iv;
                    int n = 0;
                    int n2 = index$iv + 1;
                    String string4 = var9_11.substring(n, n2);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    break block3;
                }
                string2 = "";
            }
            StringsKt.writeText$default(output, string2, 0, 0, null, 14, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return StringsKt.readBytes(Base64Kt.decodeBase64Bytes(byteReadPacket));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Input decodeBase64Bytes(@NotNull ByteReadPacket $this$decodeBase64Bytes) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$decodeBase64Bytes, "<this>");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$decodeBase64Bytes_u24lambda_u2d5 = builder$iv;
            boolean bl = false;
            byte[] data2 = new byte[4];
            block2: while ($this$decodeBase64Bytes.getRemaining() > 0L) {
                void $this$foldIndexed$iv;
                int read2 = InputArraysKt.readAvailable$default((Input)$this$decodeBase64Bytes, data2, 0, 0, 6, null);
                byte[] byArray = data2;
                int initial$iv = 0;
                boolean $i$f$foldIndexed = false;
                int index$iv = 0;
                int accumulator$iv = initial$iv;
                for (void element$iv : $this$foldIndexed$iv) {
                    void result2;
                    void current;
                    int n = index$iv++;
                    void var15_17 = element$iv;
                    int n2 = accumulator$iv;
                    int index2 = n;
                    boolean bl2 = false;
                    void $this$fromBase64$iv = current;
                    boolean $i$f$fromBase64 = false;
                    accumulator$iv = result2 | (byte)((byte)Base64Kt.BASE64_INVERSE_ALPHABET[$this$fromBase64$iv & 0xFF] & 0x3F) << (3 - index2) * 6;
                }
                int chunk = accumulator$iv;
                int n = data2.length - read2;
                int index3 = data2.length - 2;
                if (n > index3) continue;
                while (true) {
                    int origin2 = chunk >> 8 * index3 & 0xFF;
                    $this$decodeBase64Bytes_u24lambda_u2d5.writeByte((byte)origin2);
                    if (index3 == n) continue block2;
                    --index3;
                }
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    public static final char toBase64(int $this$toBase64) {
        boolean $i$f$toBase64 = false;
        return BASE64_ALPHABET.charAt($this$toBase64);
    }

    public static final byte fromBase64(byte $this$fromBase64) {
        boolean $i$f$fromBase64 = false;
        return (byte)((byte)Base64Kt.BASE64_INVERSE_ALPHABET[$this$fromBase64 & 0xFF] & 0x3F);
    }

    static {
        int n = 0;
        int[] nArray = new int[256];
        while (n < 256) {
            int n2 = n++;
            nArray[n2] = kotlin.text.StringsKt.indexOf$default((CharSequence)BASE64_ALPHABET, (char)n2, 0, false, 6, null);
        }
        BASE64_INVERSE_ALPHABET = nArray;
    }
}

