/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.nio;

import io.ktor.utils.io.bits.Memory;
import io.ktor.utils.io.bits.MemoryJvmKt;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.BuffersKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.internal.jvm.ErrorsKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a3\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0007\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u0010\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\u001c\u0010\u0011\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u001a3\u0010\u0014\u001a\u00020\u0001*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0007\u001a%\u0010\u001a\u001a\u0004\u0018\u00010\f*\u00020\u00152\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0002\b\u001f\u001a\u0012\u0010\u001a\u001a\u00020 *\u00020\u00152\u0006\u0010!\u001a\u00020\f\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"read", "", "Ljava/nio/channels/ReadableByteChannel;", "destination", "Lio/ktor/utils/io/bits/Memory;", "destinationOffset", "maxLength", "read-UAd2zVI", "(Ljava/nio/channels/ReadableByteChannel;Ljava/nio/ByteBuffer;II)I", "buffer", "Lio/ktor/utils/io/core/Buffer;", "readPacketAtLeast", "Lio/ktor/utils/io/core/ByteReadPacket;", "n", "", "readPacketAtMost", "readPacketExact", "readPacketImpl", "min", "max", "write", "Ljava/nio/channels/WritableByteChannel;", "source", "sourceOffset", "write-UAd2zVI", "(Ljava/nio/channels/WritableByteChannel;Ljava/nio/ByteBuffer;II)I", "writePacket", "builder", "Lkotlin/Function1;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "", "Lkotlin/ExtensionFunctionType;", "", "p", "ktor-io"})
public final class ChannelsKt {
    @Nullable
    public static final ByteReadPacket writePacket(@NotNull WritableByteChannel $this$writePacket, @NotNull Function1<? super BytePacketBuilder, Unit> builder2) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        Intrinsics.checkNotNullParameter($this$writePacket, "<this>");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            builder2.invoke(builder$iv);
            byteReadPacket2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket p = byteReadPacket2;
        try {
            byteReadPacket = ChannelsKt.writePacket($this$writePacket, p) ? null : p;
        }
        catch (Throwable t) {
            p.release();
            throw t;
        }
        return byteReadPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final boolean writePacket(@NotNull WritableByteChannel $this$writePacket, @NotNull ByteReadPacket p) {
        Intrinsics.checkNotNullParameter($this$writePacket, "<this>");
        Intrinsics.checkNotNullParameter(p, "p");
        try {
            int rc2;
            do {
                ChunkBuffer buffer$iv;
                rc2 = 0;
                Input $this$read_u24default$iv = p;
                int n$iv = 1;
                boolean $i$f$read = false;
                if ($this$read_u24default$iv.prepareRead(n$iv) == null) {
                    StringsKt.prematureEndOfStream(n$iv);
                    throw new KotlinNothingValueException();
                }
                int positionBefore$iv = buffer$iv.getReadPosition();
                try {
                    void endExclusive$iv;
                    void start$iv;
                    ByteBuffer nioBuffer$iv;
                    Buffer node = buffer$iv;
                    boolean bl = false;
                    Buffer $this$readDirect$iv = node;
                    boolean $i$f$readDirect = false;
                    Buffer $this$read$iv$iv = $this$readDirect$iv;
                    boolean $i$f$read2 = false;
                    int n = $this$read$iv$iv.getWritePosition();
                    int n2 = $this$read$iv$iv.getReadPosition();
                    ByteBuffer memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                    boolean bl2 = false;
                    ByteBuffer it = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                    boolean bl3 = false;
                    rc2 = $this$writePacket.write(it);
                    if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                        boolean bl4 = false;
                        String string2 = "Buffer's limit change is not allowed";
                        throw new IllegalStateException(string2.toString());
                    }
                    int rc$iv$iv = nioBuffer$iv.position();
                    $this$read$iv$iv.discardExact(rc$iv$iv);
                }
                finally {
                    int positionAfter$iv = buffer$iv.getReadPosition();
                    if (positionAfter$iv < positionBefore$iv) {
                        throw new IllegalStateException("Buffer's position shouldn't be rewinded");
                    }
                    if (positionAfter$iv == buffer$iv.getWritePosition()) {
                        $this$read_u24default$iv.ensureNext(buffer$iv);
                    } else {
                        $this$read_u24default$iv.setHeadPosition(positionAfter$iv);
                    }
                }
                ByteReadPacket $this$isEmpty$iv = p;
                boolean $i$f$isEmpty = false;
                if (!$this$isEmpty$iv.getEndOfInput()) continue;
                return true;
            } while (rc2 != 0);
            return false;
        }
        catch (Throwable t) {
            p.release();
            throw t;
        }
    }

    @NotNull
    public static final ByteReadPacket readPacketExact(@NotNull ReadableByteChannel $this$readPacketExact, long n) {
        Intrinsics.checkNotNullParameter($this$readPacketExact, "<this>");
        return ChannelsKt.readPacketImpl($this$readPacketExact, n, n);
    }

    @NotNull
    public static final ByteReadPacket readPacketAtLeast(@NotNull ReadableByteChannel $this$readPacketAtLeast, long n) {
        Intrinsics.checkNotNullParameter($this$readPacketAtLeast, "<this>");
        return ChannelsKt.readPacketImpl($this$readPacketAtLeast, n, Long.MAX_VALUE);
    }

    @NotNull
    public static final ByteReadPacket readPacketAtMost(@NotNull ReadableByteChannel $this$readPacketAtMost, long n) {
        Intrinsics.checkNotNullParameter($this$readPacketAtMost, "<this>");
        return ChannelsKt.readPacketImpl($this$readPacketAtMost, 1L, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final ByteReadPacket readPacketImpl(ReadableByteChannel $this$readPacketImpl, long min, long max) {
        if (!(min >= 0L)) {
            boolean $i$a$-require-ChannelsKt$readPacketImpl$32 = false;
            String $i$a$-require-ChannelsKt$readPacketImpl$32 = "min shouldn't be negative: " + min;
            throw new IllegalArgumentException($i$a$-require-ChannelsKt$readPacketImpl$32.toString());
        }
        if (!(min <= max)) {
            boolean $i$a$-require-ChannelsKt$readPacketImpl$42 = false;
            String $i$a$-require-ChannelsKt$readPacketImpl$42 = "min shouldn't be greater than max: " + min + " > " + max;
            throw new IllegalArgumentException($i$a$-require-ChannelsKt$readPacketImpl$42.toString());
        }
        if (max == 0L) {
            return ByteReadPacket.Companion.getEmpty();
        }
        ObjectPool<ChunkBuffer> pool = ChunkBuffer.Companion.getPool();
        ChunkBuffer empty2 = ChunkBuffer.Companion.getEmpty();
        ChunkBuffer head2 = null;
        head2 = empty2;
        ChunkBuffer tail = null;
        tail = empty2;
        try {
            int rc2;
            for (long read2 = 0L; read2 < min || read2 == min && min == 0L; read2 += (long)rc2) {
                ByteBuffer buffer$iv;
                void $this$writeDirect$iv;
                ChunkBuffer part;
                ChunkBuffer chunkBuffer;
                int remInt = (int)RangesKt.coerceAtMost(max - read2, Integer.MAX_VALUE);
                ChunkBuffer it = chunkBuffer = tail;
                boolean bl = false;
                Buffer this_$iv = it;
                boolean $i$f$getWriteRemaining = false;
                int it2 = this_$iv.getLimit() - this_$iv.getWritePosition();
                boolean bl2 = false;
                ChunkBuffer chunkBuffer2 = it2 > 200 || it2 >= remInt ? chunkBuffer : null;
                if (chunkBuffer2 == null) {
                    it = chunkBuffer = pool.borrow();
                    boolean bl3 = false;
                    if (head2 == empty2) {
                        head2 = it;
                        tail = it;
                    }
                    chunkBuffer2 = chunkBuffer;
                }
                if (tail != (part = chunkBuffer2)) {
                    tail.setNext(part);
                    tail = part;
                }
                ChunkBuffer chunkBuffer3 = part;
                int size$iv = 1;
                boolean $i$f$writeDirect = false;
                Buffer this_$iv$iv = (Buffer)$this$writeDirect$iv;
                boolean $i$f$getWriteRemaining2 = false;
                int rem$iv = this_$iv$iv.getLimit() - this_$iv$iv.getWritePosition();
                if (!(size$iv <= rem$iv)) {
                    boolean $i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22 = false;
                    String $i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22 = "size " + size$iv + " is greater than buffer's remaining capacity " + rem$iv;
                    throw new IllegalArgumentException($i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22.toString());
                }
                Intrinsics.checkNotNull($this$writeDirect$iv.getMemory-SK3TCg8().duplicate());
                int writePosition$iv = $this$writeDirect$iv.getWritePosition();
                int limit$iv = $this$writeDirect$iv.getLimit();
                buffer$iv.limit(limit$iv);
                buffer$iv.position(writePosition$iv);
                ByteBuffer bb = buffer$iv;
                boolean bl4 = false;
                int l = bb.limit();
                if (bb.remaining() > remInt) {
                    bb.limit(bb.position() + remInt);
                }
                if ((rc2 = $this$readPacketImpl.read(bb)) == -1) {
                    throw new EOFException("Premature end of stream: was read " + read2 + " bytes of " + min);
                }
                bb.limit(l);
                int delta$iv = buffer$iv.position() - writePosition$iv;
                if (delta$iv < 0 || delta$iv > rem$iv) {
                    ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
                    throw new KotlinNothingValueException();
                }
                $this$writeDirect$iv.commitWritten(delta$iv);
            }
        }
        catch (Throwable t) {
            BuffersKt.releaseAll(head2, pool);
            throw t;
        }
        return new ByteReadPacket(head2, pool);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use read(Memory) instead.")
    public static final int read(@NotNull ReadableByteChannel $this$read, @NotNull Buffer buffer) {
        void endExclusive;
        void start2;
        Intrinsics.checkNotNullParameter($this$read, "<this>");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Buffer this_$iv = buffer;
        boolean $i$f$getWriteRemaining = false;
        if (this_$iv.getLimit() - this_$iv.getWritePosition() == 0) {
            return 0;
        }
        Buffer $this$write$iv = buffer;
        boolean $i$f$write = false;
        int n = $this$write$iv.getLimit();
        int n2 = $this$write$iv.getWritePosition();
        ByteBuffer memory = $this$write$iv.getMemory-SK3TCg8();
        boolean bl = false;
        int rc2 = $this$read.read(MemoryJvmKt.sliceSafe(memory, (int)start2, (int)(endExclusive - start2)));
        if (rc2 == -1) {
            return -1;
        }
        int rc$iv = rc2;
        $this$write$iv.commitWritten(rc$iv);
        return rc$iv;
    }

    public static final int read-UAd2zVI(@NotNull ReadableByteChannel $this$read_u2dUAd2zVI, @NotNull ByteBuffer destination, int destinationOffset, int maxLength) {
        Intrinsics.checkNotNullParameter($this$read_u2dUAd2zVI, "$this$read");
        Intrinsics.checkNotNullParameter(destination, "destination");
        ByteBuffer nioBuffer = MemoryJvmKt.sliceSafe(destination, destinationOffset, maxLength);
        return $this$read_u2dUAd2zVI.read(nioBuffer);
    }

    public static /* synthetic */ int read-UAd2zVI$default(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            boolean bl = false;
            n2 = byteBuffer.limit() - n;
        }
        return ChannelsKt.read-UAd2zVI(readableByteChannel, byteBuffer, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use write(Memory) instead.")
    public static final int write(@NotNull WritableByteChannel $this$write, @NotNull Buffer buffer) {
        void endExclusive;
        void start2;
        Intrinsics.checkNotNullParameter($this$write, "<this>");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Buffer $this$read$iv = buffer;
        boolean $i$f$read = false;
        int n = $this$read$iv.getWritePosition();
        int n2 = $this$read$iv.getReadPosition();
        ByteBuffer memory = $this$read$iv.getMemory-SK3TCg8();
        boolean bl = false;
        int rc$iv = $this$write.write(MemoryJvmKt.sliceSafe(memory, (int)start2, (int)(endExclusive - start2)));
        $this$read$iv.discardExact(rc$iv);
        return rc$iv;
    }

    public static final int write-UAd2zVI(@NotNull WritableByteChannel $this$write_u2dUAd2zVI, @NotNull ByteBuffer source, int sourceOffset, int maxLength) {
        Intrinsics.checkNotNullParameter($this$write_u2dUAd2zVI, "$this$write");
        Intrinsics.checkNotNullParameter(source, "source");
        ByteBuffer nioBuffer = MemoryJvmKt.sliceSafe(source, sourceOffset, maxLength);
        return $this$write_u2dUAd2zVI.write(nioBuffer);
    }

    public static /* synthetic */ int write-UAd2zVI$default(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            boolean bl = false;
            n2 = byteBuffer.limit() - n;
        }
        return ChannelsKt.write-UAd2zVI(writableByteChannel, byteBuffer, n, n2);
    }
}

