/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.pool;

import io.ktor.utils.io.pool.DefaultPool;
import io.ktor.utils.io.pool.ObjectPool;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 $*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001$B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0005H\u0002J\r\u0010\u001b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0013\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u000f\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/ktor/utils/io/pool/DefaultPool;", "T", "", "Lio/ktor/utils/io/pool/ObjectPool;", "capacity", "", "(I)V", "getCapacity", "()I", "instances", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "maxIndex", "next", "", "shift", "top", "", "borrow", "()Ljava/lang/Object;", "clearInstance", "instance", "(Ljava/lang/Object;)Ljava/lang/Object;", "dispose", "", "disposeInstance", "(Ljava/lang/Object;)V", "popTop", "produceInstance", "pushTop", "index", "recycle", "tryPop", "tryPush", "", "(Ljava/lang/Object;)Z", "validateInstance", "Companion", "ktor-io"})
public abstract class DefaultPool<T>
implements ObjectPool<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int capacity;
    private volatile long top;
    private final int maxIndex;
    private final int shift;
    @NotNull
    private final AtomicReferenceArray<T> instances;
    @NotNull
    private final int[] next;
    @NotNull
    private static final AtomicLongFieldUpdater<DefaultPool<?>> Top;

    public DefaultPool(int capacity) {
        this.capacity = capacity;
        if (!(this.capacity > 0)) {
            boolean $i$a$-require-DefaultPool$32 = false;
            String $i$a$-require-DefaultPool$32 = "capacity should be positive but it is " + this.capacity;
            throw new IllegalArgumentException($i$a$-require-DefaultPool$32.toString());
        }
        if (!(this.capacity <= 0x1FFFFFFF)) {
            boolean bl = false;
            String string2 = "capacity should be less or equal to 536870911 but it is " + this.capacity;
            throw new IllegalArgumentException(string2.toString());
        }
        this.maxIndex = Integer.highestOneBit(this.capacity * 4 - 1) * 2;
        this.shift = Integer.numberOfLeadingZeros(this.maxIndex) + 1;
        this.instances = new AtomicReferenceArray(this.maxIndex + 1);
        this.next = new int[this.maxIndex + 1];
    }

    @Override
    public final int getCapacity() {
        return this.capacity;
    }

    @NotNull
    protected abstract T produceInstance();

    @NotNull
    protected T clearInstance(@NotNull T instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance;
    }

    protected void validateInstance(@NotNull T instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
    }

    protected void disposeInstance(@NotNull T instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
    }

    @Override
    @NotNull
    public final T borrow() {
        T t;
        block3: {
            block2: {
                t = this.tryPop();
                if (t == null) break block2;
                T it = t;
                boolean bl = false;
                T t2 = this.clearInstance(it);
                t = t2;
                if (t2 != null) break block3;
            }
            t = this.produceInstance();
        }
        return t;
    }

    @Override
    public final void recycle(@NotNull T instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        this.validateInstance(instance);
        if (!this.tryPush(instance)) {
            this.disposeInstance(instance);
        }
    }

    @Override
    public final void dispose() {
        while (this.tryPop() != null) {
            T instance;
            this.disposeInstance(instance);
        }
        return;
    }

    private final boolean tryPush(T instance) {
        int index2 = 0;
        index2 = (System.identityHashCode(instance) * -1640531527 >>> this.shift) + 1;
        int n = 8;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            if (this.instances.compareAndSet(index2, null, instance)) {
                this.pushTop(index2);
                return true;
            }
            if ((index2 += -1) != 0) continue;
            index2 = this.maxIndex;
        }
        return false;
    }

    private final T tryPop() {
        int index2 = this.popTop();
        return index2 == 0 ? null : this.instances.getAndSet(index2, null);
    }

    private final void pushTop(int index2) {
        long newTop;
        long top;
        if (!(index2 > 0)) {
            boolean bl = false;
            String string2 = "index should be positive";
            throw new IllegalArgumentException(string2.toString());
        }
        do {
            top = this.top;
            long topVersion = (top >> 32 & 0xFFFFFFFFL) + 1L;
            int topIndex = (int)(top & 0xFFFFFFFFL);
            newTop = topVersion << 32 | (long)index2;
            this.next[index2] = topIndex;
        } while (!Top.compareAndSet(this, top, newTop));
    }

    private final int popTop() {
        int topIndex;
        int next;
        long newVersion;
        long newTop;
        long top;
        do {
            if ((top = this.top) == 0L) {
                return 0;
            }
            newVersion = (top >> 32 & 0xFFFFFFFFL) + 1L;
            topIndex = (int)(top & 0xFFFFFFFFL);
            if (topIndex != 0) continue;
            return 0;
        } while (!Top.compareAndSet(this, top, newTop = newVersion << 32 | (long)(next = this.next[topIndex])));
        return topIndex;
    }

    @Override
    public void close() {
        ObjectPool.DefaultImpls.close(this);
    }

    public static final /* synthetic */ long access$getTop$p(DefaultPool $this) {
        return $this.top;
    }

    public static final /* synthetic */ void access$setTop$p(DefaultPool $this, long l) {
        $this.top = l;
    }

    static {
        KProperty1 p$iv = Companion.Top.1.INSTANCE;
        boolean $i$f$longUpdater = false;
        AtomicLongFieldUpdater<DefaultPool> atomicLongFieldUpdater = AtomicLongFieldUpdater.newUpdater(DefaultPool.class, p$iv.getName());
        Intrinsics.checkNotNullExpressionValue(atomicLongFieldUpdater, "newUpdater(Owner::class.java, p.name)");
        Top = atomicLongFieldUpdater;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/ktor/utils/io/pool/DefaultPool$Companion;", "", "()V", "Top", "Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;", "Lio/ktor/utils/io/pool/DefaultPool;", "ktor-io"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

