/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.NoSuchElementException;
import java.util.function.Function;
import javaslang.collection.AbstractIterator;
import javaslang.collection.Array;
import javaslang.collection.Iterator;
import javaslang.collection.Seq;
import javaslang.collection.Set;

interface IteratorModule {

    public static final class GroupedIterator<T>
    implements Iterator<Seq<T>> {
        private final Iterator<T> that;
        private final int size;
        private final int step;
        private final int gap;
        private final int preserve;
        private Object[] buffer;

        GroupedIterator(Iterator<T> that, int size2, int step) {
            if (size2 < 1 || step < 1) {
                throw new IllegalArgumentException("size (" + size2 + ") and step (" + step + ") must both be positive");
            }
            this.that = that;
            this.size = size2;
            this.step = step;
            this.gap = Math.max(step - size2, 0);
            this.preserve = Math.max(size2 - step, 0);
            this.buffer = GroupedIterator.take(that, new Object[size2], 0, size2);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.length > 0;
        }

        @Override
        public Seq<T> next() {
            if (this.buffer.length == 0) {
                throw new NoSuchElementException();
            }
            Object[] result2 = this.buffer;
            if (this.that.hasNext()) {
                this.buffer = new Object[this.size];
                if (this.preserve > 0) {
                    System.arraycopy(result2, this.step, this.buffer, 0, this.preserve);
                }
                if (this.gap > 0) {
                    GroupedIterator.drop(this.that, this.gap);
                    this.buffer = GroupedIterator.take(this.that, this.buffer, this.preserve, this.size);
                } else {
                    this.buffer = GroupedIterator.take(this.that, this.buffer, this.preserve, this.step);
                }
            } else {
                this.buffer = new Object[0];
            }
            return Array.wrap(result2);
        }

        private static void drop(Iterator<?> source, int count2) {
            for (int i = 0; i < count2 && source.hasNext(); ++i) {
                source.next();
            }
        }

        private static Object[] take(Iterator<?> source, Object[] target, int offset2, int count2) {
            int i;
            for (i = offset2; i < count2 + offset2 && source.hasNext(); ++i) {
                target[i] = source.next();
            }
            if (i < target.length) {
                Object[] result2 = new Object[i];
                System.arraycopy(target, 0, result2, 0, i);
                return result2;
            }
            return target;
        }
    }

    public static final class EmptyIterator
    implements Iterator<Object> {
        static final EmptyIterator INSTANCE = new EmptyIterator();

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException(this.stringPrefix() + ".next()");
        }

        @Override
        public void remove() {
            throw new IllegalStateException(this.stringPrefix() + ".remove()");
        }

        @Override
        public String stringPrefix() {
            return "EmptyIterator";
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }
    }

    public static final class DistinctIterator<T, U>
    extends AbstractIterator<T> {
        private final Iterator<? extends T> that;
        private Set<U> known;
        private final Function<? super T, ? extends U> keyExtractor;
        private T next = null;

        DistinctIterator(Iterator<? extends T> that, Set<U> set2, Function<? super T, ? extends U> keyExtractor) {
            this.that = that;
            this.known = set2;
            this.keyExtractor = keyExtractor;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.that.hasNext()) {
                Object elem = this.that.next();
                U key = this.keyExtractor.apply(elem);
                if (this.known.contains(key)) continue;
                this.known = this.known.add(key);
                this.next = elem;
            }
            return this.next != null;
        }

        @Override
        public T getNext() {
            T result2 = this.next;
            this.next = null;
            return result2;
        }
    }

    public static final class ConcatIterator<T>
    extends AbstractIterator<T> {
        private final Iterator<? extends Iterator<? extends T>> iterators;
        private Iterator<? extends T> current = Iterator.empty();

        ConcatIterator(Iterator<? extends Iterator<? extends T>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext() && !this.iterators.isEmpty()) {
                this.current = (Iterator)this.iterators.next();
            }
            return this.current.hasNext();
        }

        @Override
        public T getNext() {
            return (T)this.current.next();
        }
    }
}

