/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import org.jetbrains.annotations.NotNull;

final class SignatureSerializer {
    @NotNull
    public static final SignatureSerializer INSTANCE = new SignatureSerializer();

    private SignatureSerializer() {
    }

    @NotNull
    public final String methodDesc(@NotNull Method method2) {
        Intrinsics.checkNotNullParameter(method2, "method");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Class<?>[] classArray = method2.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, "method.parameterTypes");
        for (Class<?> parameterType : classArray) {
            Intrinsics.checkNotNullExpressionValue(parameterType, "parameterType");
            sb.append(ReflectClassUtilKt.getDesc(parameterType));
        }
        sb.append(")");
        Class<?> clazz = method2.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, "method.returnType");
        sb.append(ReflectClassUtilKt.getDesc(clazz));
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    @NotNull
    public final String constructorDesc(@NotNull Constructor<?> constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Class<?>[] classArray = constructor2.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, "constructor.parameterTypes");
        for (Class<?> parameterType : classArray) {
            Intrinsics.checkNotNullExpressionValue(parameterType, "parameterType");
            sb.append(ReflectClassUtilKt.getDesc(parameterType));
        }
        sb.append(")V");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    @NotNull
    public final String fieldDesc(@NotNull Field field2) {
        Intrinsics.checkNotNullParameter(field2, "field");
        Class<?> clazz = field2.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, "field.type");
        return ReflectClassUtilKt.getDesc(clazz);
    }
}

