/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.ReportLevel;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Jsr305Settings {
    @NotNull
    private final ReportLevel globalLevel;
    @Nullable
    private final ReportLevel migrationLevel;
    @NotNull
    private final Map<FqName, ReportLevel> userDefinedLevelForSpecificAnnotation;
    @NotNull
    private final Lazy description$delegate;
    private final boolean isDisabled;

    public Jsr305Settings(@NotNull ReportLevel globalLevel, @Nullable ReportLevel migrationLevel, @NotNull Map<FqName, ? extends ReportLevel> userDefinedLevelForSpecificAnnotation) {
        Intrinsics.checkNotNullParameter((Object)globalLevel, "globalLevel");
        Intrinsics.checkNotNullParameter(userDefinedLevelForSpecificAnnotation, "userDefinedLevelForSpecificAnnotation");
        this.globalLevel = globalLevel;
        this.migrationLevel = migrationLevel;
        this.userDefinedLevelForSpecificAnnotation = userDefinedLevelForSpecificAnnotation;
        this.description$delegate = LazyKt.lazy((Function0)new Function0<String[]>(this){
            final /* synthetic */ Jsr305Settings this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String[] invoke() {
                List<String> list2;
                Jsr305Settings jsr305Settings = this.this$0;
                List<String> $this$invoke_u24lambda_u2d2 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u2d2.add(jsr305Settings.getGlobalLevel().getDescription());
                ReportLevel reportLevel = jsr305Settings.getMigrationLevel();
                if (reportLevel != null) {
                    ReportLevel it = reportLevel;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u2d2.add("under-migration:" + it.getDescription());
                }
                Map<FqName, ReportLevel> $this$forEach$iv = jsr305Settings.getUserDefinedLevelForSpecificAnnotation();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<FqName, ReportLevel>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<FqName, ReportLevel> element$iv;
                    Map.Entry<FqName, ReportLevel> it = element$iv = iterator2.next();
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u2d2.add("" + '@' + it.getKey() + ':' + it.getValue().getDescription());
                }
                Collection $this$toTypedArray$iv = CollectionsKt.build(list2);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                return stringArray;
            }
        });
        this.isDisabled = this.globalLevel == ReportLevel.IGNORE && this.migrationLevel == ReportLevel.IGNORE && this.userDefinedLevelForSpecificAnnotation.isEmpty();
    }

    public /* synthetic */ Jsr305Settings(ReportLevel reportLevel, ReportLevel reportLevel2, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            reportLevel2 = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(reportLevel, reportLevel2, map2);
    }

    @NotNull
    public final ReportLevel getGlobalLevel() {
        return this.globalLevel;
    }

    @Nullable
    public final ReportLevel getMigrationLevel() {
        return this.migrationLevel;
    }

    @NotNull
    public final Map<FqName, ReportLevel> getUserDefinedLevelForSpecificAnnotation() {
        return this.userDefinedLevelForSpecificAnnotation;
    }

    public final boolean isDisabled() {
        return this.isDisabled;
    }

    @NotNull
    public String toString() {
        return "Jsr305Settings(globalLevel=" + (Object)((Object)this.globalLevel) + ", migrationLevel=" + (Object)((Object)this.migrationLevel) + ", userDefinedLevelForSpecificAnnotation=" + this.userDefinedLevelForSpecificAnnotation + ')';
    }

    public int hashCode() {
        int result2 = this.globalLevel.hashCode();
        result2 = result2 * 31 + (this.migrationLevel == null ? 0 : this.migrationLevel.hashCode());
        result2 = result2 * 31 + ((Object)this.userDefinedLevelForSpecificAnnotation).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Jsr305Settings)) {
            return false;
        }
        Jsr305Settings jsr305Settings = (Jsr305Settings)other;
        if (this.globalLevel != jsr305Settings.globalLevel) {
            return false;
        }
        if (this.migrationLevel != jsr305Settings.migrationLevel) {
            return false;
        }
        return Intrinsics.areEqual(this.userDefinedLevelForSpecificAnnotation, jsr305Settings.userDefinedLevelForSpecificAnnotation);
    }
}

